/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.core.enumeration;

import java.io.Serializable;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;

public final class Type
implements Serializable {
    private int code;
    private String name;
    private static final String NAME_FILE = "File";
    private static final String NAME_DIRECTORY = "Directory";
    private static final int CODE_FILE = 0;
    private static final int CODE_DIRECTORY = 1;
    public static final Type FILE = new Type(0, "File");
    public static final Type DIRECTORY = new Type(1, "Directory");

    private Type() {
    }

    private Type(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Type valueOf(String code) throws IllegalEnumerationException {
        if (NAME_FILE.equalsIgnoreCase(code)) {
            return FILE;
        }
        if (NAME_DIRECTORY.equalsIgnoreCase(code)) {
            return DIRECTORY;
        }
        throw new IllegalEnumerationException("Illegal Code : " + code);
    }

    public static Type valueOf(int code) throws IllegalEnumerationException {
        if (0 == code) {
            return FILE;
        }
        if (1 == code) {
            return DIRECTORY;
        }
        throw new IllegalEnumerationException("Illegal Code : " + code);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.code;
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Type other = (Type)object;
        return this.code == other.code;
    }

    public String toString() {
        return this.name;
    }
}

