/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;
import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserWindowComponentQueryManageConfig;
import org.phosphoresce.dbbrowser.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DatabaseBrowserWindowComponentConfig
implements Serializable {
    public static final String NODE_NAME = "windowComponent";
    private int messagePaneLocation;
    private DatabaseBrowserWindowComponentQueryManageConfig queryManageConfig;

    DatabaseBrowserWindowComponentConfig() {
        this.initialize();
    }

    DatabaseBrowserWindowComponentConfig(Node root) {
        this.initialize();
        this.load(root);
    }

    private void initialize() {
        this.messagePaneLocation = 80;
        this.queryManageConfig = new DatabaseBrowserWindowComponentQueryManageConfig();
    }

    void save(Document document, Node root) {
        Node node = root.appendChild(document.createElement(NODE_NAME));
        Node messagePaneLocation = node.appendChild(document.createElement("messagePaneLocation"));
        messagePaneLocation.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getMessagePaneLocation())));
        this.getQueryManageConfig().save(document, node);
    }

    void load(Node root) {
        NodeList nodeList = root.getChildNodes();
        this.initialize();
        for (int i = 0; i <= nodeList.getLength() - 1; ++i) {
            Node node = nodeList.item(i);
            if ("messagePaneLocation".equals(node.getNodeName())) {
                this.messagePaneLocation = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
            }
            if (!"queryManage".equals(node.getNodeName())) continue;
            this.queryManageConfig = new DatabaseBrowserWindowComponentQueryManageConfig(node);
        }
    }

    public int getMessagePaneLocation() {
        return this.messagePaneLocation;
    }

    public void setMessagePaneLocation(int messagePaneLocation) {
        this.messagePaneLocation = messagePaneLocation;
    }

    public DatabaseBrowserWindowComponentQueryManageConfig getQueryManageConfig() {
        return this.queryManageConfig;
    }

    public void setQueryManageConfig(DatabaseBrowserWindowComponentQueryManageConfig queryManageConfig) {
        this.queryManageConfig = queryManageConfig;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DatabaseBrowserWindowComponentConfig{");
        buffer.append("messagePaneLocation=");
        buffer.append(this.getMessagePaneLocation());
        buffer.append(",");
        buffer.append("queryManageConfig=");
        buffer.append(this.getQueryManageConfig());
        buffer.append("}");
        return buffer.toString();
    }
}

