/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.dbbrowser.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DatabaseBrowserConnectionConfig
implements Serializable {
    public static final String NODE_NAME = "databaseConfig";
    private String name;
    private DatabaseConfig databaseConfig;

    DatabaseBrowserConnectionConfig() {
        this.initialize();
    }

    DatabaseBrowserConnectionConfig(Node root) {
        this.initialize();
        this.load(root);
    }

    DatabaseBrowserConnectionConfig(DatabaseConfig databaseConfig) {
        this.initialize();
        this.databaseConfig = databaseConfig;
    }

    private void initialize() {
        this.name = "";
        this.databaseConfig = new DatabaseConfig();
    }

    void save(Document document, Node root) {
        Node node = root.appendChild(document.createElement(NODE_NAME));
        Node name = node.appendChild(document.createElement("name"));
        Node driver = node.appendChild(document.createElement("driver"));
        Node url = node.appendChild(document.createElement("url"));
        Node user = node.appendChild(document.createElement("user"));
        Node password = node.appendChild(document.createElement("password"));
        name.appendChild(document.createTextNode(this.getName()));
        driver.appendChild(document.createTextNode(this.getDatabaseConfig().getJdbcDriver()));
        url.appendChild(document.createTextNode(this.getDatabaseConfig().getJdbcUrl()));
        user.appendChild(document.createTextNode(this.getDatabaseConfig().getJdbcUser()));
        password.appendChild(document.createTextNode(this.getDatabaseConfig().getJdbcPassword()));
    }

    void load(Node root) {
        NodeList nodeList = root.getChildNodes();
        this.initialize();
        for (int i = 0; i <= nodeList.getLength() - 1; ++i) {
            Node node = nodeList.item(i);
            if ("name".equals(node.getNodeName())) {
                this.name = XMLUtil.getTextContent(node);
                continue;
            }
            if ("driver".equals(node.getNodeName())) {
                this.getDatabaseConfig().setJdbcDriver(XMLUtil.getTextContent(node));
                continue;
            }
            if ("url".equals(node.getNodeName())) {
                this.getDatabaseConfig().setJdbcUrl(XMLUtil.getTextContent(node));
                continue;
            }
            if ("user".equals(node.getNodeName())) {
                this.getDatabaseConfig().setJdbcUser(XMLUtil.getTextContent(node));
                continue;
            }
            if (!"password".equals(node.getNodeName())) continue;
            this.getDatabaseConfig().setJdbcPassword(XMLUtil.getTextContent(node));
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DatabaseConfig getDatabaseConfig() {
        if (this.databaseConfig == null) {
            this.databaseConfig = new DatabaseConfig();
        }
        return this.databaseConfig;
    }

    public void setDatabaseConfig(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DatabaseBrowserConnectionConfig{");
        buffer.append("name=");
        buffer.append(this.getName());
        buffer.append(",");
        buffer.append("databaseConfig=");
        buffer.append(this.getDatabaseConfig());
        buffer.append("}");
        return buffer.toString();
    }
}

