/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser;

import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.dbbrowser.DatabaseBrowser;
import org.phosphoresce.dbbrowser.gui.common.window.ConnectionConfigureFrame;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserFrame;

public final class DatabaseBrowserSession
implements Serializable {
    private static DatabaseBrowserSession instance = null;
    private DatabaseConfig config = null;
    private transient DatabaseSession commonDatabaseSession = null;
    private transient Map databaseSessionMap = new LinkedHashMap();
    private transient DatabaseBrowserFrame browserFrame = null;

    private DatabaseBrowserSession() {
    }

    public static DatabaseBrowserSession instance() {
        if (instance == null) {
            instance = new DatabaseBrowserSession();
        }
        return instance;
    }

    public void initializeConfig() {
        ConnectionConfigureFrame configureFrame = new ConnectionConfigureFrame((Frame)((Object)this.browserFrame), this);
        configureFrame.setLocationRelativeTo((Component)((Object)this.browserFrame));
        configureFrame.setVisible(true);
        if (this.config == null) {
            DatabaseBrowser.exit();
        }
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    public void setConfig(DatabaseConfig config) throws DatabaseSessionException {
        this.config = config;
        this.disposeAllDatabaseSession();
    }

    public DatabaseSession getCommonDatabaseSession() throws DatabaseSessionException {
        if (this.commonDatabaseSession == null) {
            this.commonDatabaseSession = this.createNewDatabaseSession();
        }
        return this.commonDatabaseSession;
    }

    public DatabaseSession getDatabaseSession(String name) throws DatabaseSessionException {
        if (!this.databaseSessionMap.containsKey(name)) {
            this.databaseSessionMap.put(name, this.createNewDatabaseSession());
        }
        return (DatabaseSession)this.databaseSessionMap.get(name);
    }

    private DatabaseSession createNewDatabaseSession() throws DatabaseSessionException {
        return new DatabaseSession(this.getConfig());
    }

    public void disposeAllDatabaseSession() throws DatabaseSessionException {
        if (this.commonDatabaseSession != null) {
            this.commonDatabaseSession.rollback();
            this.commonDatabaseSession.close();
        }
        this.commonDatabaseSession = null;
        Iterator iterator = this.databaseSessionMap.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            DatabaseSession databaseSession = (DatabaseSession)this.databaseSessionMap.get(name);
            if (databaseSession == null) continue;
            databaseSession.rollback();
            databaseSession.close();
        }
        this.databaseSessionMap.clear();
    }

    public boolean isInstancedBrowserFrame() {
        return this.browserFrame != null;
    }

    public DatabaseBrowserFrame getBrowserFrame() {
        if (this.browserFrame == null) {
            this.browserFrame = DatabaseBrowserFrame.instance();
        }
        return this.browserFrame;
    }

    void setBrowserFrame(DatabaseBrowserFrame browserFrame) {
        this.browserFrame = browserFrame;
    }

    protected void finalize() throws Throwable {
        this.commonDatabaseSession.close();
        super.finalize();
    }
}

