/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.core;

import java.sql.SQLException;

public final class DatabaseError {
    private int rowIndex = -1;
    private int columnIndex = -1;
    private Throwable exception = null;

    public DatabaseError(int rowIndex, int columnIndex, Throwable exception) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.exception = exception;
    }

    public DatabaseError(int rowIndex, Throwable exception) {
        this.rowIndex = rowIndex;
        this.exception = exception;
    }

    public DatabaseError(Throwable exception) {
        this.exception = exception;
    }

    private DatabaseError() {
    }

    public String getErrorMessage() {
        StringBuffer buffer = new StringBuffer();
        if (this.rowIndex >= 0) {
            buffer.append(this.rowIndex + 1);
            buffer.append(" row");
        }
        if (this.columnIndex >= 0) {
            buffer.append(" ");
            buffer.append(this.columnIndex + 1);
            buffer.append(" column");
        }
        if (this.columnIndex < 0 && this.rowIndex < 0) {
            buffer.append(" transaction");
        }
        buffer.append(" error : ");
        if (this.exception != null) {
            buffer.append(this.exception.getMessage());
        }
        return buffer.toString();
    }

    public String getErrorCode() {
        if (this.exception instanceof SQLException) {
            return String.valueOf(((SQLException)this.exception).getErrorCode());
        }
        return "";
    }

    public boolean isSQLException() {
        return this.exception instanceof SQLException;
    }

    public Throwable getException() {
        return this.exception;
    }
}

