package org.phosphoresce.commons.eswing;

import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

import javax.swing.JFrame;

import org.phosphoresce.commons.eswing.core.ESwingComponent;

/**
 * JFramegNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/01	Kitagawa		VK쐬
 *-->
 */
public class EFrame extends JFrame implements ESwingComponent {

	/** EBhETCY(EBhEXe[^X֌W) */
	private Rectangle realBounds = getBounds();

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		getContentPane().setLayout(null);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setState(Frame.NORMAL);
		setResizable(true);
		addComponentListener(new ComponentListener() {
			public void componentShown(ComponentEvent e) {
				if (getExtendedState() == JFrame.NORMAL) {
					realBounds = getBounds();
				}
			}

			public void componentResized(ComponentEvent e) {
				if (getExtendedState() == JFrame.NORMAL) {
					realBounds = getBounds();
				}
			}

			public void componentMoved(ComponentEvent e) {
				if (getExtendedState() == JFrame.NORMAL) {
					realBounds = getBounds();
				}
			}

			public void componentHidden(ComponentEvent e) {
				if (getExtendedState() == JFrame.NORMAL) {
					realBounds = getBounds();
				}
			}
		});
	}

	/**
	 * RXgN^<br>
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JFrame#JFrame()
	 */
	public EFrame() throws HeadlessException {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param gc GraphicsConfigurationIuWFNg
	 * @see JFrame#JFrame(GraphicsConfiguration)
	 */
	public EFrame(GraphicsConfiguration gc) {
		super(gc);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param title t[^Cg
	 * @param gc GraphicsConfigurationIuWFNg
	 * @see JFrame#JFrame(String, GraphicsConfiguration)
	 */
	public EFrame(String title, GraphicsConfiguration gc) {
		super(title, gc);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param title t[^Cg
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JFrame#JFrame(String)
	 */
	public EFrame(String title) throws HeadlessException {
		super(title);
		dressup();
	}

	/**
	 * EBhETCY(EBhEXe[^X֌W)擾܂B<br>
	 * @return EBhETCY(EBhEXe[^X֌W)
	 */
	public Rectangle getRealBounds() {
		return realBounds;
	}
}
