/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.eswing.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import org.phosphoresce.commons.eswing.core.ESwingConfig;
import org.phosphoresce.commons.eswing.table.ETableCellDefaultRenderer;

public class ETableCellStepColoredRenderer
extends ETableCellDefaultRenderer {
    private boolean stepColoring = true;

    public ETableCellStepColoredRenderer(JTable table, boolean stepColoring) {
        super(table);
        this.stepColoring = stepColoring;
    }

    public ETableCellStepColoredRenderer(JTable table) {
        this(table, true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color background = super.getBackground();
        Color foreground = super.getForeground();
        if (this.stepColoring) {
            if (!isSelected && !hasFocus && row % 2 != 0) {
                background = ESwingConfig.getTableStepedCellBackgroundColor();
                foreground = ESwingConfig.getTableStepedCellForegroungColor();
            }
            this.setBackground(background);
            this.setForeground(foreground);
        }
        return this;
    }

    public boolean isStepColoring() {
        return this.stepColoring;
    }

    public void setStepColoring(boolean stepColoring) {
        this.stepColoring = stepColoring;
    }
}

