/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.csv;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.phosphoresce.commons.csv.CSVRecord;

public final class CSVRecordList
implements Serializable {
    private List list = null;

    public CSVRecordList() {
        this.list = new LinkedList();
    }

    public CSVRecordList(CSVRecordList list) {
        this.list = new LinkedList(list.list);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(CSVRecord record) {
        return this.list.contains(record);
    }

    public boolean containsAll(CSVRecordList list) {
        return this.list.containsAll(list.list);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public CSVRecord[] toArray() {
        return this.list.toArray(new CSVRecord[this.list.size()]);
    }

    public boolean addAll(CSVRecordList list) {
        return this.list.addAll(list.list);
    }

    public boolean addAll(int index, CSVRecordList list) {
        this.expand(index);
        return this.list.addAll(index, list.list);
    }

    public boolean retainAll(CSVRecordList list) {
        return this.list.retainAll(list.list);
    }

    public void clear() {
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public void expand(int size) {
        int listSize = this.list.size();
        for (int i = 0; i <= size - listSize; ++i) {
            this.list.add(new CSVRecord());
        }
    }

    public void add(CSVRecord record) {
        this.list.add(record);
    }

    public void add(int index, CSVRecord record) {
        this.expand(index);
        this.list.add(index, record);
    }

    public CSVRecord get(int index) {
        this.expand(index + 1);
        return (CSVRecord)this.list.get(index);
    }

    public CSVRecord set(int index, CSVRecord record) {
        this.expand(index + 1);
        return this.list.set(index, record);
    }

    public boolean remove(CSVRecord record) {
        return this.list.remove(record);
    }

    public CSVRecord remove(int index) {
        this.expand(index + 1);
        return (CSVRecord)this.list.remove(index);
    }

    public boolean removeAll(CSVRecordList list) {
        return this.list.removeAll(list.list);
    }

    public int indexOf(CSVRecord record) {
        return this.list.indexOf(record);
    }

    public int lastIndexOf(CSVRecord record) {
        return this.list.lastIndexOf(record);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int index) {
        this.expand(index);
        return this.list.listIterator(index);
    }

    public CSVRecordList subList(int fromIndex, int toIndex) {
        this.expand(fromIndex);
        this.expand(toIndex);
        List record = this.list.subList(fromIndex, toIndex);
        CSVRecordList result = new CSVRecordList();
        Iterator iterator = record.iterator();
        while (iterator.hasNext()) {
            result.add((CSVRecord)iterator.next());
        }
        return result;
    }
}

