/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserWindowBoundsConfig;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserWindowComponentConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DatabaseBrowserWindowConfig
implements Serializable {
    public static final String NODE_NAME = "windowConfig";
    private DatabaseBrowserWindowBoundsConfig boundsConfig;
    private DatabaseBrowserWindowComponentConfig componentConfig;

    DatabaseBrowserWindowConfig() {
    }

    private void initialize() {
        this.boundsConfig = null;
        this.componentConfig = null;
    }

    void save(Document document, Node root) {
        Node node = root.appendChild(document.createElement(NODE_NAME));
        this.getBoundsConfig().save(document, node);
        this.getComponentConfig().save(document, root);
    }

    void load(Node root) {
        NodeList nodeList = root.getChildNodes();
        this.initialize();
        for (int i = 0; i <= nodeList.getLength() - 1; ++i) {
            Node node = nodeList.item(i);
            if ("windowBounds".equals(node.getNodeName())) {
                this.boundsConfig = new DatabaseBrowserWindowBoundsConfig(node);
                continue;
            }
            if (!"windowComponent".equals(node.getNodeName())) continue;
            this.componentConfig = new DatabaseBrowserWindowComponentConfig(node);
        }
    }

    public DatabaseBrowserWindowBoundsConfig getBoundsConfig() {
        if (this.boundsConfig == null) {
            this.boundsConfig = new DatabaseBrowserWindowBoundsConfig();
        }
        return this.boundsConfig;
    }

    public void setBoundsConfig(DatabaseBrowserWindowBoundsConfig boundsConfig) {
        this.boundsConfig = boundsConfig;
    }

    public DatabaseBrowserWindowComponentConfig getComponentConfig() {
        if (this.componentConfig == null) {
            this.componentConfig = new DatabaseBrowserWindowComponentConfig();
        }
        return this.componentConfig;
    }

    public void setComponentConfig(DatabaseBrowserWindowComponentConfig componentConfig) {
        this.componentConfig = componentConfig;
    }
}

