/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser;

import java.awt.Frame;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.core.ESwingConfig;
import org.phosphoresce.commons.eswing.core.ESwingConfigManager;
import org.phosphoresce.commons.logging.appender.TextPaneAppender;
import org.phosphoresce.commons.logging.config.LoggingColorSet;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserConfig;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserPane;
import org.phosphoresce.dbbrowser.resource.definition.dbdriver.DatabaseBrowserJDBCSample;

public final class DatabaseBrowser {
    private DatabaseBrowser() {
    }

    public static void main(String[] args) {
        try {
            DatabaseBrowser.initialize();
            Log log = LogFactory.getLog((Class)DatabaseBrowser.class);
            log.info((Object)"initialized application.");
            DatabaseBrowser.startup();
            log.info((Object)"successed to startup application.");
        }
        catch (Throwable throwable) {
            String errorMessage = "raised critical application exception.";
            EMessageDialog.showError((Frame)null, (String)errorMessage, (Throwable)throwable);
            DatabaseBrowser.exit();
        }
    }

    public static void initialize() throws Throwable {
        DatabaseBrowser.initializeSwing();
        DatabaseBrowser.initializeLogger();
        DatabaseBrowser.initializeConfigs();
    }

    private static void initializeSwing() throws Throwable {
        ESwingConfigManager.configure();
        ESwingConfig.initializeMessageDialogConfig();
    }

    private static void initializeLogger() throws Throwable {
        DOMConfigurator.configure((URL)DatabaseBrowser.class.getResource("/database-browser-log4j.xml"));
        TextPaneAppender appender = TextPaneAppender.getAppender((String)"textpane");
        if (appender != null) {
            appender.setColorSet(new LoggingColorSet());
        }
    }

    private static void initializeConfigs() throws Throwable {
        DatabaseBrowserConfig.instance().load();
        DatabaseBrowserJDBCSample.instance();
    }

    private static void startup() throws Throwable {
        DatabaseBrowserConfig config = DatabaseBrowserConfig.instance();
        DatabaseBrowserSession session = DatabaseBrowserSession.instance();
        session.initializeConfig();
        session.getBrowserFrame().setBounds(config.getWindowConfig().getBoundsConfig().getBounds());
        DatabaseBrowserPane.instance().setLastDividerLocation(config.getWindowConfig().getComponentConfig().getWindowMessagePaneLocation());
        session.getBrowserFrame().setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit() {
        try {
            DatabaseBrowserConfig config = DatabaseBrowserConfig.instance();
            DatabaseBrowserSession session = DatabaseBrowserSession.instance();
            config.getWindowConfig().getBoundsConfig().setBounds(session.getBrowserFrame().getBounds());
            config.getWindowConfig().getComponentConfig().setWindowMessagePaneLocation(DatabaseBrowserPane.instance().getLastDividerLocation());
            config.save();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }
}

