package org.phosphoresce.commons.eswing.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Properties;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

import org.phosphoresce.commons.eswing.resource.ESwingImage;
import org.phosphoresce.commons.eswing.util.FontUtil;
import org.phosphoresce.commons.eswing.util.SizeUtil;
import org.phosphoresce.commons.util.StringUtil;

/**
 * gSwingeR|[lgɑ΂ݒlǗNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/01	Kitagawa		VK쐬
 *-->
 */
public final class ESwingConfig {

	/**
	 * NXCjVCU
	 */
	static {
		initialize();
	}

	// Common Setting Information

	/** Look&FeelNX */
	private static String lookAndFeelName;

	/** ReitHg */
	private static Font containerFont;

	/** pX[htHg */
	private static Font passwordFont;

	/** ReiwiF */
	private static Color containerBackgroundColor;

	/** ReiOiF */
	private static Color containerForegroundColor;

	/** ̓tH[wiF */
	private static Color inputFormBackgroundColor;

	/** ̓tH[OiF */
	private static Color inputFormForegroundColor;

	// Extends Table Setting

	/** e[uZtH[JXwiF */
	private static Color tableFocusedCellBackgroundColor;

	/** e[uZtH[JXOiF */
	private static Color tableFocusedCellForegroungColor;

	/** e[uZXebvFwiF */
	private static Color tableStepedCellBackgroundColor;

	/** e[uZXebvFOiF */
	private static Color tableStepedCellForegroungColor;

	/** e[uZzo[FwiF */
	private static Color tableHoverCellBackgroundColor;

	/** e[uZzo[FOiF */
	private static Color tableHoverCellForegroungColor;

	// FileChooser Setting

	/** Filechooserڍו\ACR */
	private static ImageIcon filechooserDetailsViewIcon;

	/** Filechooserꗗ\ACR */
	private static ImageIcon filechooserListViewIcon;

	/** FilechooserVKtH_ACR */
	private static ImageIcon filechooserNewFolderIcon;

	/** FilechooserʃtH_ACR */
	private static ImageIcon filechooserUpFolderIcon;

	// Message Dialog Setting

	/** bZ[W_CAOG[ACR */
	private static Icon messageDialogErrorIcon;

	/** bZ[W_CAOCtH[VACR */
	private static Icon messageDialogInformationIcon;

	/** bZ[W_CAOxACR */
	private static Icon messageDialogWarningIcon;

	/** bZ[W_CAOACR */
	private static Icon messageDialogQuestionIcon;

	/** bZ[W_CAOACRTCY */
	private static Dimension messageDialogIconSize;

	/** bZ[W_CAO{^TCY */
	private static Dimension messageDialogButtonSize;

	/** bZ[W_CAObZ[WyCTCY */
	private static Dimension messageDialogMessagePaneSize;

	/** bZ[W_CAOڍ׃bZ[WyCTCY */
	private static Dimension messageDialogDitailMessagePaneSize;

	// Constructor

	/**
	 * RXgN^<br>
	 */
	private ESwingConfig() {
		super();
	}

	// Initialize Method

	/**
	 * ESwingݒ胊\[XvpeBIuWFNg擾܂B<br>
	 * @return ESwingݒ胊\[XvpeBIuWFNg
	 */
	private static Properties getProperties() {
		String filename = "eswing-config";
		Properties properties = new Properties();
		try {
			properties.load(ESwingConfig.class.getResourceAsStream(filename + "." + System.getProperty("os.name") + "." + System.getProperty("os.version")));
		} catch (Exception e1) {
			try {
				properties.load(ESwingConfig.class.getResourceAsStream(filename + "." + System.getProperty("os.name")));
			} catch (Exception e2) {
				try {
					properties.load(ESwingConfig.class.getResourceAsStream(filename));
				} catch (Exception e3) {
					//
				}
			}
		}
		return properties;
	}

	/**
	 * NX܂B<br>
	 */
	public static void initialize() {
		initializeGUILookConfig();
		initializeStanderdComponent();
		initializeTable();
		initializeFilechooser();
		initializeMessageDialogConfig();
	}

	/**
	 * GUI\֘Ȁs܂B<br>
	 */
	public static void initializeGUILookConfig() {
		Properties properties = getProperties();
		if (StringUtil.isEmpty(properties.getProperty("lookAndFeelName"))) {
			lookAndFeelName = UIManager.getSystemLookAndFeelClassName();
		} else {
			lookAndFeelName = properties.getProperty("lookAndFeelName");
		}
		if (StringUtil.isEmpty(properties.getProperty("containerFont"))) {
			containerFont = new Font("SansSerif", Font.TRUETYPE_FONT, 12);
		} else {
			containerFont = FontUtil.createFontFromName(properties.getProperty("containerFont"));
		}
		if (StringUtil.isEmpty(properties.getProperty("passwordFont"))) {
			passwordFont = new Font("Tahoma", Font.TRUETYPE_FONT, 12);
		} else {
			passwordFont = FontUtil.createFontFromName(properties.getProperty("passwordFont"));
		}
	}

	/**
	 * WIȃR|[lg̏s܂B<br>
	 */
	public static void initializeStanderdComponent() {
		Properties properties = getProperties();
		if (StringUtil.isEmpty(properties.getProperty("containerBackgroundColor"))) {
			containerBackgroundColor = SystemColor.control;
		} else {
			containerBackgroundColor = Color.decode(properties.getProperty("containerBackgroundColor"));
		}
		if (StringUtil.isEmpty(properties.getProperty("containerForegroundColor"))) {
			containerForegroundColor = SystemColor.controlText;
		} else {
			containerForegroundColor = Color.decode(properties.getProperty("containerForegroundColor"));
		}
		if (StringUtil.isEmpty(properties.getProperty("inputFormBackgroundColor"))) {
			inputFormBackgroundColor = SystemColor.white;
		} else {
			inputFormBackgroundColor = Color.decode(properties.getProperty("inputFormBackgroundColor"));
		}
		if (StringUtil.isEmpty(properties.getProperty("inputFormForegroundColor"))) {
			inputFormForegroundColor = SystemColor.controlText;
		} else {
			inputFormForegroundColor = Color.decode(properties.getProperty("inputFormForegroundColor"));
		}
	}

	/**
	 * e[u֘Ȁs܂B<br>
	 */
	public static void initializeTable() {
		Properties properties = getProperties();
		if (StringUtil.isEmpty(properties.getProperty("containerForegroundColor"))) {
			tableFocusedCellBackgroundColor = Color.decode("#f8dd72");
		} else {
			tableFocusedCellBackgroundColor = Color.decode(properties.getProperty("containerForegroundColor"));
		}
		if (StringUtil.isEmpty(properties.getProperty("containerForegroundColor"))) {
			tableFocusedCellForegroungColor = Color.decode("#000000");
		} else {
			tableFocusedCellForegroungColor = Color.decode(properties.getProperty("containerForegroundColor"));
		}
		if (StringUtil.isEmpty(properties.getProperty("containerForegroundColor"))) {
			tableStepedCellBackgroundColor = Color.decode("#f0f0f0");
		} else {
			tableStepedCellBackgroundColor = Color.decode(properties.getProperty("containerForegroundColor"));
		}
		if (StringUtil.isEmpty(properties.getProperty("containerForegroundColor"))) {
			tableStepedCellForegroungColor = Color.decode("#000000");
		} else {
			tableStepedCellForegroungColor = Color.decode(properties.getProperty("containerForegroundColor"));
		}
		if (StringUtil.isEmpty(properties.getProperty("containerForegroundColor"))) {
			tableHoverCellBackgroundColor = Color.decode("#b4c2da");
		} else {
			tableHoverCellBackgroundColor = Color.decode(properties.getProperty("containerForegroundColor"));
		}
		if (StringUtil.isEmpty(properties.getProperty("containerForegroundColor"))) {
			tableHoverCellForegroungColor = Color.decode("#000000");
		} else {
			tableHoverCellForegroungColor = Color.decode(properties.getProperty("containerForegroundColor"));
		}
	}

	/**
	 * FileChooser֘Ȁs܂B<br>
	 */
	public static void initializeFilechooser() {
		Properties properties = getProperties();
		if (StringUtil.isEmpty(properties.getProperty("filechooserDetailsViewIcon"))) {
			filechooserDetailsViewIcon = new ImageIcon(ESwingImage.FILECHOOSER_DETAILS_VIEW_ICON);
		} else {
			filechooserDetailsViewIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("filechooserDetailsViewIcon")));
		}
		if (StringUtil.isEmpty(properties.getProperty("filechooserListViewIcon"))) {
			filechooserListViewIcon = new ImageIcon(ESwingImage.FILECHOOSER_LIST_VIEW_ICON);
		} else {
			filechooserListViewIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("filechooserListViewIcon")));
		}
		if (StringUtil.isEmpty(properties.getProperty("filechooserNewFolderIcon"))) {
			filechooserNewFolderIcon = new ImageIcon(ESwingImage.FILECHOOSER_NEW_FOLDER_ICON);
		} else {
			filechooserNewFolderIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("filechooserNewFolderIcon")));
		}
		if (StringUtil.isEmpty(properties.getProperty("filechooserUpFolderIcon"))) {
			filechooserUpFolderIcon = new ImageIcon(ESwingImage.FILECHOOSER_UP_FOLDER_ICON);
		} else {
			filechooserUpFolderIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("filechooserUpFolderIcon")));
		}
	}

	/**
	 * bZ[W_CAȌs܂B<br>
	 */
	public static void initializeMessageDialogConfig() {
		Properties properties = getProperties();
		if (StringUtil.isEmpty(properties.getProperty("messageDialogErrorIcon"))) {
			messageDialogErrorIcon = (Icon) UIManager.getLookAndFeelDefaults().get("OptionPane.errorIcon");
		} else {
			messageDialogErrorIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("messageDialogErrorIcon")));
		}
		if (StringUtil.isEmpty(properties.getProperty("messageDialogInformationIcon"))) {
			messageDialogInformationIcon = (Icon) UIManager.getLookAndFeelDefaults().get("OptionPane.informationIcon");
		} else {
			messageDialogInformationIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("messageDialogInformationIcon")));
		}
		if (StringUtil.isEmpty(properties.getProperty("messageDialogWarningIcon"))) {
			messageDialogWarningIcon = (Icon) UIManager.getLookAndFeelDefaults().get("OptionPane.warningIcon");
		} else {
			messageDialogWarningIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("messageDialogWarningIcon")));
		}
		if (StringUtil.isEmpty(properties.getProperty("messageDialogQuestionIcon"))) {
			messageDialogQuestionIcon = (Icon) UIManager.getLookAndFeelDefaults().get("OptionPane.questionIcon");
		} else {
			messageDialogQuestionIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("messageDialogQuestionIcon")));
		}
		//if (StringUtil.isEmpty(properties.getProperty("messageDialogIconSize"))) {
		messageDialogIconSize = messageDialogErrorIcon != null ? SizeUtil.getDimension(messageDialogErrorIcon) : new Dimension(32, 32);
		//} else {
		//	messageDialogIconSize = SizeUtil.getDimension(properties.getProperty("messageDialogIconSize"));
		//}
		if (StringUtil.isEmpty(properties.getProperty("messageDialogButtonSize"))) {
			messageDialogButtonSize = new Dimension(86, 24);
		} else {
			messageDialogButtonSize = SizeUtil.getDimension(properties.getProperty("messageDialogButtonSize"));
		}
		if (StringUtil.isEmpty(properties.getProperty("messageDialogMessagePaneSize"))) {
			messageDialogMessagePaneSize = new Dimension(400, 64);
		} else {
			messageDialogMessagePaneSize = SizeUtil.getDimension(properties.getProperty("messageDialogMessagePaneSize"));
		}
		if (StringUtil.isEmpty(properties.getProperty("messageDialogDitailMessagePaneSize"))) {
			messageDialogDitailMessagePaneSize = new Dimension(400, 240);
		} else {
			messageDialogDitailMessagePaneSize = SizeUtil.getDimension(properties.getProperty("messageDialogDitailMessagePaneSize"));
		}
	}

	// Common Setting Information

	/**
	 * Look&FeelNX擾܂B<br>
	 * @return Look&FeelNX
	 */
	public static String getLookAndFeelName() {
		return lookAndFeelName;
	}

	/**
	 * Look&FeelNXݒ肵܂B<br>
	 * @param lookAndFeelName Look&FeelNX
	 */
	public static void setLookAndFeelName(String lookAndFeelName) {
		ESwingConfig.lookAndFeelName = lookAndFeelName;
	}

	/**
	 * ReitHg擾܂B<br>
	 * @return ReitHg
	 */
	public static Font getContainerFont() {
		return containerFont;
	}

	/**
	 * ReitHgݒ肵܂B<br>
	 * @param containerFont ReitHg
	 */
	public static void setContainerFont(Font containerFont) {
		ESwingConfig.containerFont = containerFont;
	}

	/**
	 * pX[htHg擾܂B<br>
	 * @return pX[htHg
	 */
	public static Font getPasswordFont() {
		return passwordFont;
	}

	/**
	 * pX[htHgݒ肵܂B<br>
	 * @param passwordFont pX[htHg
	 */
	public static void setPasswordFont(Font passwordFont) {
		ESwingConfig.passwordFont = passwordFont;
	}

	/**
	 * ReiwiF擾܂B<br>
	 * @return ReiwiF
	 */
	public static Color getContainerBackgroundColor() {
		return containerBackgroundColor;
	}

	/**
	 * ReiwiFݒ肵܂B<br>
	 * @param containerBackgroundColor ReiwiF
	 */
	public static void setContainerBackgroundColor(Color containerBackgroundColor) {
		ESwingConfig.containerBackgroundColor = containerBackgroundColor;
	}

	/**
	 * ReiOiF擾܂B<br>
	 * @return ReiOiF
	 */
	public static Color getContainerForegroundColor() {
		return containerForegroundColor;
	}

	/**
	 * ReiOiFݒ肵܂B<br>
	 * @param containerForegroundColor ReiOiF
	 */
	public static void setContainerForegroundColor(Color containerForegroundColor) {
		ESwingConfig.containerForegroundColor = containerForegroundColor;
	}

	/**
	 * ̓tH[wiF擾܂B<br>
	 * @return ̓tH[wiF
	 */
	public static Color getInputFormBackgroundColor() {
		return inputFormBackgroundColor;
	}

	/**
	 * ̓tH[wiFݒ肵܂B<br>
	 * @param inputFormBackgroundColor ̓tH[wiF
	 */
	public static void setInputFormBackgroundColor(Color inputFormBackgroundColor) {
		ESwingConfig.inputFormBackgroundColor = inputFormBackgroundColor;
	}

	/**
	 * ̓tH[OiF擾܂B<br>
	 * @return ̓tH[OiF
	 */
	public static Color getInputFormForegroundColor() {
		return inputFormForegroundColor;
	}

	/**
	 * ̓tH[OiFݒ肵܂B<br>
	 * @param inputFormForegroundColor ̓tH[OiF
	 */
	public static void setInputFormForegroundColor(Color inputFormForegroundColor) {
		ESwingConfig.inputFormForegroundColor = inputFormForegroundColor;
	}

	// Extends Table Setting

	/**
	 * e[uZtH[JXwiF擾܂B<br>
	 * @return e[uZtH[JXwiF
	 */
	public static Color getTableFocusedCellBackgroundColor() {
		return tableFocusedCellBackgroundColor;
	}

	/**
	 * e[uZtH[JXwiFݒ肵܂B<br>
	 * @param tableFocusedCellBackgroundColor e[uZtH[JXwiF
	 */
	public static void setTableFocusedCellBackgroundColor(Color tableFocusedCellBackgroundColor) {
		ESwingConfig.tableFocusedCellBackgroundColor = tableFocusedCellBackgroundColor;
	}

	/**
	 * e[uZtH[JXOiF擾܂B<br>
	 * @return e[uZtH[JXOiF
	 */
	public static Color getTableFocusedCellForegroungColor() {
		return tableFocusedCellForegroungColor;
	}

	/**
	 * e[uZtH[JXOiFݒ肵܂B<br>
	 * @param tableFocusedCellForegroungColor e[uZtH[JXOiF
	 */
	public static void setTableFocusedCellForegroungColor(Color tableFocusedCellForegroungColor) {
		ESwingConfig.tableFocusedCellForegroungColor = tableFocusedCellForegroungColor;
	}

	/**
	 * e[uZXebvFwiF擾܂B<br>
	 * @return e[uZXebvFwiF
	 */
	public static Color getTableStepedCellBackgroundColor() {
		return tableStepedCellBackgroundColor;
	}

	/**
	 * e[uZXebvFwiFݒ肵܂B<br>
	 * @param tableStepedCellBackgroundColor e[uZXebvFwiF
	 */
	public static void setTableStepedCellBackgroundColor(Color tableStepedCellBackgroundColor) {
		ESwingConfig.tableStepedCellBackgroundColor = tableStepedCellBackgroundColor;
	}

	/**
	 * e[uZXebvFOiF擾܂B<br>
	 * @return e[uZXebvFOiF
	 */
	public static Color getTableStepedCellForegroungColor() {
		return tableStepedCellForegroungColor;
	}

	/**
	 * e[uZXebvFOiFݒ肵܂B<br>
	 * @param tableStepedCellForegroungColor e[uZXebvFOiF
	 */
	public static void setTableStepedCellForegroungColor(Color tableStepedCellForegroungColor) {
		ESwingConfig.tableStepedCellForegroungColor = tableStepedCellForegroungColor;
	}

	/**
	 * e[uZzo[FwiF擾܂B<br>
	 * @return tableHoverCellBackgroundColor
	 */
	public static Color getTableHoverCellBackgroundColor() {
		return tableHoverCellBackgroundColor;
	}

	/**
	 * e[uZzo[FwiFݒ肵܂B<br>
	 * @param tableHoverCellBackgroundColor e[uZzo[FwiF
	 */
	public static void setTableHoverCellBackgroundColor(Color tableHoverCellBackgroundColor) {
		ESwingConfig.tableHoverCellBackgroundColor = tableHoverCellBackgroundColor;
	}

	/**
	 * e[uZzo[FOiF擾܂B<br>
	 * @return e[uZzo[FOiF
	 */
	public static Color getTableHoverCellForegroungColor() {
		return tableHoverCellForegroungColor;
	}

	/**
	 * e[uZzo[FOiFݒ肵܂B<br>
	 * @param tableHoverCellForegroungColor e[uZzo[FOiF
	 */
	public static void setTableHoverCellForegroungColor(Color tableHoverCellForegroungColor) {
		ESwingConfig.tableHoverCellForegroungColor = tableHoverCellForegroungColor;
	}

	// FileChooser Setting

	/**
	 * Filechooserڍו\ACR擾܂B<br>
	 * @return filechooserDetailsViewIcon
	 */
	public static ImageIcon getFilechooserDetailsViewIcon() {
		return filechooserDetailsViewIcon;
	}

	/**
	 * Filechooserڍו\ACRݒ肵܂B<br>
	 * @param filechooserDetailsViewIcon Filechooserڍו\ACR
	 */
	public static void setFilechooserDetailsViewIcon(ImageIcon filechooserDetailsViewIcon) {
		ESwingConfig.filechooserDetailsViewIcon = filechooserDetailsViewIcon;
	}

	/**
	 * Filechooserꗗ\ACR擾܂B<br>
	 * @return Filechooserꗗ\ACR
	 */
	public static ImageIcon getFilechooserListViewIcon() {
		return filechooserListViewIcon;
	}

	/**
	 * Filechooserꗗ\ACRݒ肵܂B<br>
	 * @param filechooserListViewIcon Filechooserꗗ\ACR
	 */
	public static void setFilechooserListViewIcon(ImageIcon filechooserListViewIcon) {
		ESwingConfig.filechooserListViewIcon = filechooserListViewIcon;
	}

	/**
	 * FilechooserVKtH_ACR擾܂B<br>
	 * @return FilechooserVKtH_ACR
	 */
	public static ImageIcon getFilechooserNewFolderIcon() {
		return filechooserNewFolderIcon;
	}

	/**
	 * FilechooserVKtH_ACRݒ肵܂B<br>
	 * @param filechooserNewFolderIcon FilechooserVKtH_ACR
	 */
	public static void setFilechooserNewFolderIcon(ImageIcon filechooserNewFolderIcon) {
		ESwingConfig.filechooserNewFolderIcon = filechooserNewFolderIcon;
	}

	/**
	 * FilechooserʃtH_ACR擾܂B<br>
	 * @return FilechooserʃtH_ACR
	 */
	public static ImageIcon getFilechooserUpFolderIcon() {
		return filechooserUpFolderIcon;
	}

	/**
	 * FilechooserʃtH_ACRݒ肵܂B<br>
	 * @param filechooserUpFolderIcon FilechooserʃtH_ACR
	 */
	public static void setFilechooserUpFolderIcon(ImageIcon filechooserUpFolderIcon) {
		ESwingConfig.filechooserUpFolderIcon = filechooserUpFolderIcon;
	}

	// Message Dialog Setting

	/**
	 * bZ[W_CAOG[ACR擾܂B<br>
	 * @return bZ[W_CAOG[ACR
	 */
	public static Icon getMessageDialogErrorIcon() {
		return messageDialogErrorIcon;
	}

	/**
	 * bZ[W_CAOG[ACRݒ肵܂B<br>
	 * @param messageDialogErrorIcon bZ[W_CAOG[ACR
	 */
	public static void setMessageDialogErrorIcon(Icon messageDialogErrorIcon) {
		ESwingConfig.messageDialogErrorIcon = messageDialogErrorIcon;
	}

	/**
	 * bZ[W_CAOCtH[VACR擾܂B<br>
	 * @return bZ[W_CAOCtH[VACR
	 */
	public static Icon getMessageDialogInformationIcon() {
		return messageDialogInformationIcon;
	}

	/**
	 * bZ[W_CAOCtH[VACRݒ肵܂B<br>
	 * @param messageDialogInformationIcon bZ[W_CAOCtH[VACR
	 */
	public static void setMessageDialogInformationIcon(Icon messageDialogInformationIcon) {
		ESwingConfig.messageDialogInformationIcon = messageDialogInformationIcon;
	}

	/**
	 * bZ[W_CAOACR擾܂B<br>
	 * @return bZ[W_CAOACR
	 */
	public static Icon getMessageDialogQuestionIcon() {
		return messageDialogQuestionIcon;
	}

	/**
	 * bZ[W_CAOACRݒ肵܂B<br>
	 * @param messageDialogQuestionIcon bZ[W_CAOACR
	 */
	public static void setMessageDialogQuestionIcon(Icon messageDialogQuestionIcon) {
		ESwingConfig.messageDialogQuestionIcon = messageDialogQuestionIcon;
	}

	/**
	 * bZ[W_CAOxACR擾܂B<br>
	 * @return bZ[W_CAOxACR
	 */
	public static Icon getMessageDialogWarningIcon() {
		return messageDialogWarningIcon;
	}

	/**
	 * bZ[W_CAOxACRݒ肵܂B<br>
	 * @param messageDialogWarningIcon bZ[W_CAOxACR
	 */
	public static void setMessageDialogWarningIcon(Icon messageDialogWarningIcon) {
		ESwingConfig.messageDialogWarningIcon = messageDialogWarningIcon;
	}

	/**
	 * bZ[W_CAOACRTCY擾܂B<br>
	 * @return bZ[W_CAOACRTCY
	 */
	public static Dimension getMessageDialogIconSize() {
		return messageDialogIconSize;
	}

	/**
	 * bZ[W_CAOACRTCYݒ肵܂B<br>
	 * @param messageDialogIconSize bZ[W_CAOACRTCY
	 */
	public static void setMessageDialogIconSize(Dimension messageDialogIconSize) {
		ESwingConfig.messageDialogIconSize = messageDialogIconSize;
	}

	/**
	 * bZ[W_CAO{^TCY擾܂B<br>
	 * @return bZ[W_CAO{^TCY
	 */
	public static Dimension getMessageDialogButtonSize() {
		return messageDialogButtonSize;
	}

	/**
	 * bZ[W_CAO{^TCYݒ肵܂B<br>
	 * @param messageDialogButtonSize bZ[W_CAO{^TCY
	 */
	public static void setMessageDialogButtonSize(Dimension messageDialogButtonSize) {
		ESwingConfig.messageDialogButtonSize = messageDialogButtonSize;
	}

	/**
	 * bZ[W_CAObZ[WyCTCY擾܂B<br>
	 * @return bZ[W_CAObZ[WyCTCY
	 */
	public static Dimension getMessageDialogMessagePaneSize() {
		return messageDialogMessagePaneSize;
	}

	/**
	 * bZ[W_CAObZ[WyCTCYݒ肵܂B<br>
	 * @param messageDialogMessagePaneSize bZ[W_CAObZ[WyCTCY
	 */
	public static void setMessageDialogMessagePaneSize(Dimension messageDialogMessagePaneSize) {
		ESwingConfig.messageDialogMessagePaneSize = messageDialogMessagePaneSize;
	}

	/**
	 * bZ[W_CAOڍ׃bZ[WyCTCY擾܂B<br>
	 * @return bZ[W_CAOڍ׃bZ[WyCTCY
	 */
	public static Dimension getMessageDialogDitailMessagePaneSize() {
		return messageDialogDitailMessagePaneSize;
	}

	/**
	 * bZ[W_CAOڍ׃bZ[WyCTCYݒ肵܂B<br>
	 * @param messageDialogDitailMessagePaneSize bZ[W_CAOڍ׃bZ[WyCTCY
	 */
	public static void setMessageDialogDitailMessagePaneSize(Dimension messageDialogDitailMessagePaneSize) {
		ESwingConfig.messageDialogDitailMessagePaneSize = messageDialogDitailMessagePaneSize;
	}
}
