package org.phosphoresce.commons.eswing;

import java.awt.Dimension;
import java.awt.Insets;

import javax.swing.JTextField;
import javax.swing.text.Document;

import org.phosphoresce.commons.eswing.core.ESwingComponent;
import org.phosphoresce.commons.eswing.core.ESwingConfig;

/**
 * JTextFieldgNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/02	Kitagawa		VK쐬
 *-->
 */
public class ETextField extends JTextField implements ESwingComponent {

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		setDoubleBuffered(true);
		setSize(new Dimension(100, 20));

		Insets insets = getInsets();
		insets.left = 3;
		insets.right = 3;
		setMargin(insets);
	}

	/**
	 * RXgN^<br>
	 * @see JTextField#JTextField()
	 */
	public ETextField() {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param document DocumentIuWFNg
	 * @param text eLXg
	 * @param columns J
	 * @see JTextField#JTextField(Document, String, int)
	 */
	public ETextField(Document document, String text, int columns) {
		super(document, text, columns);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param columns J
	 * @see JTextField#JTextField(int)
	 */
	public ETextField(int columns) {
		super(columns);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param text eLXg
	 * @param columns J
	 * @see JTextField#JTextField(String, int)
	 */
	public ETextField(String text, int columns) {
		super(text, columns);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param text eLXg
	 * @see JTextField#JTextField(String)
	 */
	public ETextField(String text) {
		super(text);
		dressup();
	}
}
