package org.phosphoresce.commons.eswing;

import javax.swing.BoundedRangeModel;
import javax.swing.JProgressBar;

import org.phosphoresce.commons.eswing.core.ESwingComponent;

/**
 * JProgressBargNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/01	Kitagawa		VK쐬
 *-->
 */
public class EProgressBar extends JProgressBar implements ESwingComponent {

	/** gsmvOXo[Xbh */
	private Thread extendIndeterminateThread = null;

	/**
	 * gsmvOXo[XbhNXB<br>
	 * 
	 * @author Kitagawa<br>
	 * 
	 *<!--
	 * XV		XV			XVe
	 * 2007/05/17	Kitagawa		VK쐬
	 *-->
	 */
	private class IndeterminateThread implements Runnable {

		/**
		 * gsmvOXo[XV܂B<br>
		 * @see java.lang.Runnable#run()
		 */
		public void run() {
			while (extendIndeterminate) {
				try {
					setValue(extendIndeterminateCount += 10, false);
					if (extendIndeterminateCount >= 100) {
						extendIndeterminateCount = 0;
					}
					Thread.sleep(100);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/** gsmvOXo[tO */
	private boolean extendIndeterminate = false;

	/** gsmvOXo[JE^ */
	private int extendIndeterminateCount = 0;

	/** gsmvOXo[ݒ莞őlޔϐ */
	private int extendIndeterminateBackupMaximum = 0;

	/** gsmvOXo[ݒ莞ŏlޔϐ */
	private int extendIndeterminateBackupMinimum = 0;

	/** gsmvOXo[ݒ莞lޔϐ */
	private int extendIndeterminateBackupValue = 0;

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		setDoubleBuffered(true);
	}

	/**
	 * RXgN^<br>
	 * @see JProgressBar#JProgressBar()
	 */
	public EProgressBar() {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param model BoundedRangeModelIuWFNg
	 * @see JProgressBar#JProgressBar(BoundedRangeModel)
	 */
	public EProgressBar(BoundedRangeModel model) {
		super(model);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param orient vOXo[
	 * @param min ŏl
	 * @param max ől
	 * @see JProgressBar#JProgressBar(int, int, int)
	 */
	public EProgressBar(int orient, int min, int max) {
		super(orient, min, max);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param min ŏl
	 * @param max ől
	 * @see JProgressBar#JProgressBar(int, int)
	 */
	public EProgressBar(int min, int max) {
		super(min, max);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param orient vOXo[
	 * @see JProgressBar#JProgressBar(int)
	 */
	public EProgressBar(int orient) {
		super(orient);
		dressup();
	}

	/**
	 * gsmvOXo[tOݒ肵܂B<br>
	 * @param extendIndeterminate gsmvOXo[Ƃē삷ꍇtruew
	 */
	public void setExtendIndeterminate(boolean extendIndeterminate) {
		if (this.extendIndeterminate != extendIndeterminate) {
			this.extendIndeterminate = extendIndeterminate;
			this.extendIndeterminateCount = 0;

			if (extendIndeterminate) {
				this.extendIndeterminateBackupMaximum = getMaximum();
				this.extendIndeterminateBackupMinimum = getMinimum();
				this.extendIndeterminateBackupValue = getValue();

				setMaximum(100);
				setMinimum(0);
				setValue(this.extendIndeterminateCount);

				if (extendIndeterminateThread == null) {
					extendIndeterminateThread = new Thread(new IndeterminateThread());
					extendIndeterminateThread.start();
				}
			} else {
				setMaximum(this.extendIndeterminateBackupMaximum);
				setMinimum(this.extendIndeterminateBackupMinimum);
				setValue(this.extendIndeterminateBackupValue);
				this.extendIndeterminateBackupMaximum = 0;
				this.extendIndeterminateBackupMinimum = 0;
				this.extendIndeterminateBackupValue = 0;
				extendIndeterminateThread = null;
			}
		}
	}

	/**
	 * ilݒ肵܂B<br>
	 * @param n il
	 * @param backup ilޔĂꍇtruew
	 */
	private void setValue(int n, boolean backup) {
		if (backup) {
			this.extendIndeterminateBackupValue = n;
		} else {
			super.setValue(n);
		}
	}

	/**
	 * ilݒ肵܂B<br>
	 * @param n il
	 * @see javax.swing.JProgressBar#setValue(int)
	 */
	public void setValue(int n) {
		setValue(n, extendIndeterminate);
	}

	/**
	 * ől擾܂B<br>
	 * @return ől
	 * @see javax.swing.JProgressBar#getMaximum()
	 */
	public int getMaximum() {
		if (extendIndeterminate) {
			return this.extendIndeterminateBackupMaximum;
		} else {
			return super.getMaximum();
		}
	}

	/**
	 * ŏl擾܂B<br>
	 * @return ŏl
	 * @see javax.swing.JProgressBar#getMinimum()
	 */
	public int getMinimum() {
		if (extendIndeterminate) {
			return this.extendIndeterminateBackupMinimum;
		} else {
			return super.getMinimum();
		}
	}

	/**
	 * il擾܂B<br>
	 * @return il
	 * @see javax.swing.JProgressBar#getValue()
	 */
	public int getValue() {
		if (extendIndeterminate) {
			return this.extendIndeterminateBackupValue;
		} else {
			return super.getValue();
		}
	}

	/**
	 * őlݒ肵܂B<br>
	 * @param n ől
	 * @see javax.swing.JProgressBar#setMaximum(int)
	 */
	public void setMaximum(int n) {
		if (extendIndeterminate) {
			this.extendIndeterminateBackupMaximum = n;
		} else {
			super.setMaximum(n);
		}
	}

	/**
	 * ŏlݒ肵܂B<br>
	 * @param n ŏl
	 * @see javax.swing.JProgressBar#setMinimum(int)
	 */
	public void setMinimum(int n) {
		if (extendIndeterminate) {
			this.extendIndeterminateBackupMinimum = n;
		} else {
			super.setMinimum(n);
		}
	}
}
