package org.phosphoresce.commons.eswing;

import java.awt.Dimension;
import java.awt.Insets;
import java.text.Format;

import javax.swing.JFormattedTextField;

import org.phosphoresce.commons.eswing.core.ESwingComponent;

/**
 * JFormattedTextFieldgNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/02	Kitagawa		VK쐬
 *-->
 */
public class EFormattedTextField extends JFormattedTextField implements ESwingComponent {

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		setDoubleBuffered(true);
		setSize(new Dimension(100, 20));

		Insets insets = getInsets();
		insets.left = 3;
		insets.right = 3;
		setMargin(insets);
	}

	/**
	 * RXgN^<br>
	 * @see JFormattedTextField#JFormattedTextField()
	 */
	public EFormattedTextField() {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param formatter FormatterIuWFNg
	 * @see JFormattedTextField#JFormattedTextField(javax.swing.JFormattedTextField.AbstractFormatter)
	 */
	public EFormattedTextField(AbstractFormatter formatter) {
		super(formatter);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param factory FormatterFactoryIuWFNg
	 * @param value l
	 * @see JFormattedTextField#JFormattedTextField(javax.swing.JFormattedTextField.AbstractFormatterFactory, Object)
	 */
	public EFormattedTextField(AbstractFormatterFactory factory, Object value) {
		super(factory, value);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param factory FormatterFactoryIuWFNg
	 * @see JFormattedTextField#JFormattedTextField(javax.swing.JFormattedTextField.AbstractFormatterFactory)
	 */
	public EFormattedTextField(AbstractFormatterFactory factory) {
		super(factory);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param format FormatIuWFNg
	 * @see JFormattedTextField#JFormattedTextField(Format)
	 */
	public EFormattedTextField(Format format) {
		super(format);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param value l
	 * @see JFormattedTextField#JFormattedTextField(Object)
	 */
	public EFormattedTextField(Object value) {
		super(value);
		dressup();
	}
}
