package org.phosphoresce.commons.eswing.table;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;

import org.phosphoresce.commons.eswing.core.ESwingConfig;

/**
 * e[usXebvF_NX<br>
 * NX͕\R|[lĝ̍쐬͒񋟂Aw肳ꂽʃ_IuWFNgɈϏ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/02	Kitagawa		VK쐬
 *-->
 */
public class ETableCellStepColoredRenderer extends ETableCellDefaultRenderer {

	/** XebvJ[OtO */
	private boolean stepColoring = true;

	/**
	 * RXgN^<br>
	 * @param table JTableIuWFNg
	 * @param stepColoring XebvJ[OtO
	 */
	public ETableCellStepColoredRenderer(JTable table, boolean stepColoring) {
		super(table);
		this.stepColoring = stepColoring;
	}

	/**
	 * RXgN^<br>
	 * @param table JTableIuWFNg
	 */
	public ETableCellStepColoredRenderer(JTable table) {
		this(table, true);
	}

	/**
	 * sʒũIuWFNg̕\R|[lg񋟂܂B<br>
	 * @param table JTableIuWFNg
	 * @param value lIuWFNg
	 * @param isSelected ItO
	 * @param hasFocus tH[JXtO
	 * @param row sʒu
	 * @param column ʒu
	 * @return ComponentIuWFNg
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

		Color background = super.getBackground();
		Color foreground = super.getForeground();

		if (stepColoring) {
			if (!isSelected && !hasFocus) {
				if (row % 2 != 0) {
					background = ESwingConfig.getTableStepedCellBackgroundColor();
					foreground = ESwingConfig.getTableStepedCellForegroungColor();
				}
			}
			setBackground(background);
			setForeground(foreground);
		}

		return this;
	}

	/**
	 * XebvJ[OtO擾܂B<br>
	 * @return XebvJ[OtO
	 */
	public boolean isStepColoring() {
		return stepColoring;
	}

	/**
	 * XebvJ[OtOݒ肵܂B<br>
	 * @param stepColoring XebvJ[OtO
	 */
	public void setStepColoring(boolean stepColoring) {
		this.stepColoring = stepColoring;
	}
}
