/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.eswing.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.phosphoresce.commons.eswing.resource.ESwingImage;
import org.phosphoresce.commons.eswing.util.FontUtil;
import org.phosphoresce.commons.eswing.util.SizeUtil;
import org.phosphoresce.commons.util.StringUtil;

public final class ESwingConfig {
    private static String lookAndFeelName;
    private static Font containerFont;
    private static Font passwordFont;
    private static Color containerBackgroundColor;
    private static Color containerForegroundColor;
    private static Color inputFormBackgroundColor;
    private static Color inputFormForegroundColor;
    private static Color tableFocusedCellBackgroundColor;
    private static Color tableFocusedCellForegroungColor;
    private static Color tableStepedCellBackgroundColor;
    private static Color tableStepedCellForegroungColor;
    private static Color tableHoverCellBackgroundColor;
    private static Color tableHoverCellForegroungColor;
    private static ImageIcon filechooserDetailsViewIcon;
    private static ImageIcon filechooserListViewIcon;
    private static ImageIcon filechooserNewFolderIcon;
    private static ImageIcon filechooserUpFolderIcon;
    private static Icon messageDialogErrorIcon;
    private static Icon messageDialogInformationIcon;
    private static Icon messageDialogWarningIcon;
    private static Icon messageDialogQuestionIcon;
    private static Dimension messageDialogIconSize;
    private static Dimension messageDialogButtonSize;
    private static Dimension messageDialogMessagePaneSize;
    private static Dimension messageDialogDitailMessagePaneSize;

    private ESwingConfig() {
    }

    private static Properties getProperties() {
        String filename = "eswing-config";
        Properties properties = new Properties();
        try {
            properties.load(ESwingConfig.class.getResourceAsStream(filename + "." + System.getProperty("os.name") + "." + System.getProperty("os.version")));
        }
        catch (Exception e1) {
            try {
                properties.load(ESwingConfig.class.getResourceAsStream(filename + "." + System.getProperty("os.name")));
            }
            catch (Exception e2) {
                try {
                    properties.load(ESwingConfig.class.getResourceAsStream(filename));
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return properties;
    }

    public static void initialize() {
        ESwingConfig.initializeGUILookConfig();
        ESwingConfig.initializeStanderdComponent();
        ESwingConfig.initializeTable();
        ESwingConfig.initializeFilechooser();
        ESwingConfig.initializeMessageDialogConfig();
    }

    public static void initializeGUILookConfig() {
        Properties properties = ESwingConfig.getProperties();
        lookAndFeelName = StringUtil.isEmpty((String)properties.getProperty("lookAndFeelName")) ? UIManager.getSystemLookAndFeelClassName() : properties.getProperty("lookAndFeelName");
        containerFont = StringUtil.isEmpty((String)properties.getProperty("containerFont")) ? new Font("SansSerif", 0, 12) : FontUtil.createFontFromName(properties.getProperty("containerFont"));
        passwordFont = StringUtil.isEmpty((String)properties.getProperty("passwordFont")) ? new Font("Tahoma", 0, 12) : FontUtil.createFontFromName(properties.getProperty("passwordFont"));
    }

    public static void initializeStanderdComponent() {
        Properties properties = ESwingConfig.getProperties();
        containerBackgroundColor = StringUtil.isEmpty((String)properties.getProperty("containerBackgroundColor")) ? SystemColor.control : Color.decode(properties.getProperty("containerBackgroundColor"));
        containerForegroundColor = StringUtil.isEmpty((String)properties.getProperty("containerForegroundColor")) ? SystemColor.controlText : Color.decode(properties.getProperty("containerForegroundColor"));
        inputFormBackgroundColor = StringUtil.isEmpty((String)properties.getProperty("inputFormBackgroundColor")) ? SystemColor.white : Color.decode(properties.getProperty("inputFormBackgroundColor"));
        inputFormForegroundColor = StringUtil.isEmpty((String)properties.getProperty("inputFormForegroundColor")) ? SystemColor.controlText : Color.decode(properties.getProperty("inputFormForegroundColor"));
    }

    public static void initializeTable() {
        Properties properties = ESwingConfig.getProperties();
        tableFocusedCellBackgroundColor = StringUtil.isEmpty((String)properties.getProperty("containerForegroundColor")) ? Color.decode("#f8dd72") : Color.decode(properties.getProperty("containerForegroundColor"));
        tableFocusedCellForegroungColor = StringUtil.isEmpty((String)properties.getProperty("containerForegroundColor")) ? Color.decode("#000000") : Color.decode(properties.getProperty("containerForegroundColor"));
        tableStepedCellBackgroundColor = StringUtil.isEmpty((String)properties.getProperty("containerForegroundColor")) ? Color.decode("#f0f0f0") : Color.decode(properties.getProperty("containerForegroundColor"));
        tableStepedCellForegroungColor = StringUtil.isEmpty((String)properties.getProperty("containerForegroundColor")) ? Color.decode("#000000") : Color.decode(properties.getProperty("containerForegroundColor"));
        tableHoverCellBackgroundColor = StringUtil.isEmpty((String)properties.getProperty("containerForegroundColor")) ? Color.decode("#b4c2da") : Color.decode(properties.getProperty("containerForegroundColor"));
        tableHoverCellForegroungColor = StringUtil.isEmpty((String)properties.getProperty("containerForegroundColor")) ? Color.decode("#000000") : Color.decode(properties.getProperty("containerForegroundColor"));
    }

    public static void initializeFilechooser() {
        Properties properties = ESwingConfig.getProperties();
        filechooserDetailsViewIcon = StringUtil.isEmpty((String)properties.getProperty("filechooserDetailsViewIcon")) ? new ImageIcon(ESwingImage.FILECHOOSER_DETAILS_VIEW_ICON) : new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("filechooserDetailsViewIcon")));
        filechooserListViewIcon = StringUtil.isEmpty((String)properties.getProperty("filechooserListViewIcon")) ? new ImageIcon(ESwingImage.FILECHOOSER_LIST_VIEW_ICON) : new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("filechooserListViewIcon")));
        filechooserNewFolderIcon = StringUtil.isEmpty((String)properties.getProperty("filechooserNewFolderIcon")) ? new ImageIcon(ESwingImage.FILECHOOSER_NEW_FOLDER_ICON) : new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("filechooserNewFolderIcon")));
        filechooserUpFolderIcon = StringUtil.isEmpty((String)properties.getProperty("filechooserUpFolderIcon")) ? new ImageIcon(ESwingImage.FILECHOOSER_UP_FOLDER_ICON) : new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("filechooserUpFolderIcon")));
    }

    public static void initializeMessageDialogConfig() {
        Properties properties = ESwingConfig.getProperties();
        messageDialogErrorIcon = StringUtil.isEmpty((String)properties.getProperty("messageDialogErrorIcon")) ? (Icon)UIManager.getLookAndFeelDefaults().get("OptionPane.errorIcon") : new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("messageDialogErrorIcon")));
        messageDialogInformationIcon = StringUtil.isEmpty((String)properties.getProperty("messageDialogInformationIcon")) ? (Icon)UIManager.getLookAndFeelDefaults().get("OptionPane.informationIcon") : new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("messageDialogInformationIcon")));
        messageDialogWarningIcon = StringUtil.isEmpty((String)properties.getProperty("messageDialogWarningIcon")) ? (Icon)UIManager.getLookAndFeelDefaults().get("OptionPane.warningIcon") : new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("messageDialogWarningIcon")));
        messageDialogQuestionIcon = StringUtil.isEmpty((String)properties.getProperty("messageDialogQuestionIcon")) ? (Icon)UIManager.getLookAndFeelDefaults().get("OptionPane.questionIcon") : new ImageIcon(Toolkit.getDefaultToolkit().getImage(properties.getProperty("messageDialogQuestionIcon")));
        messageDialogIconSize = messageDialogErrorIcon != null ? SizeUtil.getDimension(messageDialogErrorIcon) : new Dimension(32, 32);
        messageDialogButtonSize = StringUtil.isEmpty((String)properties.getProperty("messageDialogButtonSize")) ? new Dimension(86, 24) : SizeUtil.getDimension(properties.getProperty("messageDialogButtonSize"));
        messageDialogMessagePaneSize = StringUtil.isEmpty((String)properties.getProperty("messageDialogMessagePaneSize")) ? new Dimension(400, 64) : SizeUtil.getDimension(properties.getProperty("messageDialogMessagePaneSize"));
        messageDialogDitailMessagePaneSize = StringUtil.isEmpty((String)properties.getProperty("messageDialogDitailMessagePaneSize")) ? new Dimension(400, 240) : SizeUtil.getDimension(properties.getProperty("messageDialogDitailMessagePaneSize"));
    }

    public static String getLookAndFeelName() {
        return lookAndFeelName;
    }

    public static void setLookAndFeelName(String lookAndFeelName) {
        ESwingConfig.lookAndFeelName = lookAndFeelName;
    }

    public static Font getContainerFont() {
        return containerFont;
    }

    public static void setContainerFont(Font containerFont) {
        ESwingConfig.containerFont = containerFont;
    }

    public static Font getPasswordFont() {
        return passwordFont;
    }

    public static void setPasswordFont(Font passwordFont) {
        ESwingConfig.passwordFont = passwordFont;
    }

    public static Color getContainerBackgroundColor() {
        return containerBackgroundColor;
    }

    public static void setContainerBackgroundColor(Color containerBackgroundColor) {
        ESwingConfig.containerBackgroundColor = containerBackgroundColor;
    }

    public static Color getContainerForegroundColor() {
        return containerForegroundColor;
    }

    public static void setContainerForegroundColor(Color containerForegroundColor) {
        ESwingConfig.containerForegroundColor = containerForegroundColor;
    }

    public static Color getInputFormBackgroundColor() {
        return inputFormBackgroundColor;
    }

    public static void setInputFormBackgroundColor(Color inputFormBackgroundColor) {
        ESwingConfig.inputFormBackgroundColor = inputFormBackgroundColor;
    }

    public static Color getInputFormForegroundColor() {
        return inputFormForegroundColor;
    }

    public static void setInputFormForegroundColor(Color inputFormForegroundColor) {
        ESwingConfig.inputFormForegroundColor = inputFormForegroundColor;
    }

    public static Color getTableFocusedCellBackgroundColor() {
        return tableFocusedCellBackgroundColor;
    }

    public static void setTableFocusedCellBackgroundColor(Color tableFocusedCellBackgroundColor) {
        ESwingConfig.tableFocusedCellBackgroundColor = tableFocusedCellBackgroundColor;
    }

    public static Color getTableFocusedCellForegroungColor() {
        return tableFocusedCellForegroungColor;
    }

    public static void setTableFocusedCellForegroungColor(Color tableFocusedCellForegroungColor) {
        ESwingConfig.tableFocusedCellForegroungColor = tableFocusedCellForegroungColor;
    }

    public static Color getTableStepedCellBackgroundColor() {
        return tableStepedCellBackgroundColor;
    }

    public static void setTableStepedCellBackgroundColor(Color tableStepedCellBackgroundColor) {
        ESwingConfig.tableStepedCellBackgroundColor = tableStepedCellBackgroundColor;
    }

    public static Color getTableStepedCellForegroungColor() {
        return tableStepedCellForegroungColor;
    }

    public static void setTableStepedCellForegroungColor(Color tableStepedCellForegroungColor) {
        ESwingConfig.tableStepedCellForegroungColor = tableStepedCellForegroungColor;
    }

    public static Color getTableHoverCellBackgroundColor() {
        return tableHoverCellBackgroundColor;
    }

    public static void setTableHoverCellBackgroundColor(Color tableHoverCellBackgroundColor) {
        ESwingConfig.tableHoverCellBackgroundColor = tableHoverCellBackgroundColor;
    }

    public static Color getTableHoverCellForegroungColor() {
        return tableHoverCellForegroungColor;
    }

    public static void setTableHoverCellForegroungColor(Color tableHoverCellForegroungColor) {
        ESwingConfig.tableHoverCellForegroungColor = tableHoverCellForegroungColor;
    }

    public static ImageIcon getFilechooserDetailsViewIcon() {
        return filechooserDetailsViewIcon;
    }

    public static void setFilechooserDetailsViewIcon(ImageIcon filechooserDetailsViewIcon) {
        ESwingConfig.filechooserDetailsViewIcon = filechooserDetailsViewIcon;
    }

    public static ImageIcon getFilechooserListViewIcon() {
        return filechooserListViewIcon;
    }

    public static void setFilechooserListViewIcon(ImageIcon filechooserListViewIcon) {
        ESwingConfig.filechooserListViewIcon = filechooserListViewIcon;
    }

    public static ImageIcon getFilechooserNewFolderIcon() {
        return filechooserNewFolderIcon;
    }

    public static void setFilechooserNewFolderIcon(ImageIcon filechooserNewFolderIcon) {
        ESwingConfig.filechooserNewFolderIcon = filechooserNewFolderIcon;
    }

    public static ImageIcon getFilechooserUpFolderIcon() {
        return filechooserUpFolderIcon;
    }

    public static void setFilechooserUpFolderIcon(ImageIcon filechooserUpFolderIcon) {
        ESwingConfig.filechooserUpFolderIcon = filechooserUpFolderIcon;
    }

    public static Icon getMessageDialogErrorIcon() {
        return messageDialogErrorIcon;
    }

    public static void setMessageDialogErrorIcon(Icon messageDialogErrorIcon) {
        ESwingConfig.messageDialogErrorIcon = messageDialogErrorIcon;
    }

    public static Icon getMessageDialogInformationIcon() {
        return messageDialogInformationIcon;
    }

    public static void setMessageDialogInformationIcon(Icon messageDialogInformationIcon) {
        ESwingConfig.messageDialogInformationIcon = messageDialogInformationIcon;
    }

    public static Icon getMessageDialogQuestionIcon() {
        return messageDialogQuestionIcon;
    }

    public static void setMessageDialogQuestionIcon(Icon messageDialogQuestionIcon) {
        ESwingConfig.messageDialogQuestionIcon = messageDialogQuestionIcon;
    }

    public static Icon getMessageDialogWarningIcon() {
        return messageDialogWarningIcon;
    }

    public static void setMessageDialogWarningIcon(Icon messageDialogWarningIcon) {
        ESwingConfig.messageDialogWarningIcon = messageDialogWarningIcon;
    }

    public static Dimension getMessageDialogIconSize() {
        return messageDialogIconSize;
    }

    public static void setMessageDialogIconSize(Dimension messageDialogIconSize) {
        ESwingConfig.messageDialogIconSize = messageDialogIconSize;
    }

    public static Dimension getMessageDialogButtonSize() {
        return messageDialogButtonSize;
    }

    public static void setMessageDialogButtonSize(Dimension messageDialogButtonSize) {
        ESwingConfig.messageDialogButtonSize = messageDialogButtonSize;
    }

    public static Dimension getMessageDialogMessagePaneSize() {
        return messageDialogMessagePaneSize;
    }

    public static void setMessageDialogMessagePaneSize(Dimension messageDialogMessagePaneSize) {
        ESwingConfig.messageDialogMessagePaneSize = messageDialogMessagePaneSize;
    }

    public static Dimension getMessageDialogDitailMessagePaneSize() {
        return messageDialogDitailMessagePaneSize;
    }

    public static void setMessageDialogDitailMessagePaneSize(Dimension messageDialogDitailMessagePaneSize) {
        ESwingConfig.messageDialogDitailMessagePaneSize = messageDialogDitailMessagePaneSize;
    }

    static {
        ESwingConfig.initialize();
    }
}

