package org.phosphoresce.commons.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * ʓt[eBeBNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2005/11/22	Kitagawa		VK쐬
 *-->
 */
public final class DateUtil {

	/** tFyyyyMMdd */
	public static final String FORMAT_YYYYMMDD = "yyyyMMdd";

	/** tFyyyy/MM/dd */
	public static final String FORMAT_YYYYsMMsDD = "yyyy/MM/dd";

	/** tFyyyy/MM/dd HH:mm */
	public static final String FORMAT_YYYYsMMsDD_24HHcMM = "yyyy/MM/dd HH:mm";

	/** tFyyyy/MM/dd HH:mm:ss */
	public static final String FORMAT_YYYYsMMsDD_24HHcMMcSS = "yyyy/MM/dd HH:mm:ss";

	/** tFyyyy/MM/dd HH:mm:ss.SSS */
	public static final String FORMAT_YYYYsMMsDD_24HHcMMcSSdSSS = "yyyy/MM/dd HH:mm:ss.SSS";

	/** tFyyyy/MM/dd hh:mm:ss.SSS a */
	public static final String FORMAT_YYYYsMMsDD_12HHcMMcSSdSSS_A = "yyyy/MM/dd hh:mm:ss.SSS a";

	/** tFy/M/d */
	public static final String FORMAT_YsMsD = "y/M/d";

	/** tFyyyy/M/d HH:mm */
	public static final String FORMAT_YsMsD_24HHcMM = "y/M/d HH:mm";

	/** tFyyyy/M/d HH:mm:ss */
	public static final String FORMAT_YsMsD_24HHcMMcSS = "y/M/d HH:mm:ss";

	/** tFyyyy/M/d HH:mm:ss.SSS */
	public static final String FORMAT_YsMsD_24HHcMMcSSdSSS = "y/M/d HH:mm:ss.SSS";

	/** tFyyyy/M/d hh:mm:ss.SSS a */
	public static final String FORMAT_YsMsD_12HHcMMcSSdSSS_A = "y/M/d hh:mm:ss.SSS a";

	/** tFyyyy/M/d H:m */
	public static final String FORMAT_YsMsD_24HcM = "y/M/d H:m";

	/** tFyyyy/M/d H:m:s */
	public static final String FORMAT_YsMsD_24HcMcS = "y/M/d H:m:s";

	/** tFyyyy/M/d H:m:s.S */
	public static final String FORMAT_YsMsD_24HcMcSdS = "y/M/d H:m:s.S";

	/** tFyyyy/M/d h:m:s.S a */
	public static final String FORMAT_YsMsD_12HcMcSdS_A = "y/M/d h:m:s.S a";

	/** tFyyyyMMddHHmmssSSS */
	public static final String FORMAT_YYYYMMDD24HHMMSSSSS = "yyyyMMddHHmmssSSS";

	/** tFHH:mm */
	public static final String FORMAT_24HHcMM = "HH:mm";

	/** tFHH:mm:ss */
	public static final String FORMAT_24HHcMMcSS = "HH:mm:ss";

	/** tFHH:mm:ss.SSS */
	public static final String FORMAT_24HHcMMcSSdSSS = "HH:mm:ss.SSS";

	/** tFH:m */
	public static final String FORMAT_24HcM = "H:m";

	/** tFH:m:s */
	public static final String FORMAT_24HcMcS = "H:m:s";

	/** tFH:m:s.S */
	public static final String FORMAT_24HcMcSdS = "H:m:s.S";

	/** tFyyyyMMdd_HHmm */
	public static final String FORMAT_YYYYMMDDu24HHMM = "yyyyMMdd_HHmm";

	/** tFyyyy */
	public static final String FORMAT_YYYY = "yyyy";

	/** tFMM */
	public static final String FORMAT_MM = "MM";

	/** tFdd */
	public static final String FORMAT_DD = "dd";

	/** tFHH */
	public static final String FORMAT_24HH = "HH";

	/** tFhh */
	public static final String FORMAT_12HH = "hh";

	/** tFmm */
	public static final String FORMAT_MI = "mm";

	/** tFss */
	public static final String FORMAT_SS = "ss";

	/** tFSSS */
	public static final String FORMAT_SSS = "SSS";

	/** tFa */
	public static final String FORMAT_A = "a";

	/** fBtHgt */
	public static final String DEFAULT_FORMAT = FORMAT_YYYYsMMsDD;

	/**
	 * RXgN^<br>
	 */
	private DateUtil() {
		//
	}

	/**
	 * w肳ꂽtŋLqꂽtDateIuWFNgɕϊ܂B<br>
	 * SimpleDateFormatX[ÕbvAR[fBO̊ȈՉړIƂ\bhB<br>
	 * @param date tŋLqꂽt
	 * @param format t
	 * @return ϊDateIuWFNg
	 */
	public static Date parse(String date, String format) {
		try {
			return StringUtil.isEmpty(date) ? null : new SimpleDateFormat(format).parse(date);
		} catch (ParseException e) {
			throw new RuntimeException("tA܂͓t񂪕sȈׁADateIuWFNgւ̕ϊɎs܂ [" + date + "]");
		}
	}

	/**
	 * w肳ꂽtŋLqꂽtDateIuWFNgɕϊ܂B<br>
	 * SimpleDateFormatX[ÕbvAR[fBO̊ȈՉړIƂ\bhB<br>
	 * @param date tŋLqꂽt
	 * @param format t
	 * @return ϊDateIuWFNg
	 */
	public static Date parse(String date, String[] format) {
		for (int i = 0; i <= format.length - 1; i++) {
			try {
				return StringUtil.isEmpty(date) ? null : new SimpleDateFormat(format[i]).parse(date);
			} catch (ParseException e) {
				if (i < format.length - 1) {
					continue;
				} else {
					throw new RuntimeException("tA܂͓t񂪕sȈׁADateIuWFNgւ̕ϊɎs܂ [" + date + "]");
				}
			}
		}
		return null;
	}

	/**
	 * fBtHgtŋLqꂽtDateIuWFNgɕϊ܂B<br>
	 * SimpleDateFormatX[ÕbvAR[fBO̊ȈՉړIƂ\bhB<br>
	 * @param date fBtHgtŋLqꂽt
	 * @return ϊDateIuWFNg
	 */
	public static Date parse(String date) {
		return parse(date, DEFAULT_FORMAT);
	}

	/**
	 * w肳ꂽtɂ킹tƂēt擾܂B<br>
	 * @param date DateIuWFNg
	 * @param format t
	 * @return tɂ킹t
	 */
	public static String format(Date date, String format) {
		return date == null ? "" : new SimpleDateFormat(format).format(date);
	}

	/**
	 * fBtHgtɂ킹tƂēt擾܂B<br>
	 * @param date DateIuWFNg
	 * @return fBtHgtɂ킹t
	 */
	public static String format(Date date) {
		return format(date, DEFAULT_FORMAT);
	}

	/**
	 * w肳ꂽDateIuWFNg̔N擾܂B<br>
	 * @param date DateIuWFNg
	 * @return w肳ꂽDateIuWFNg̔N
	 */
	public static String getYear(Date date) {
		return date == null ? "" : format(new Date(), FORMAT_YYYY);
	}

	/**
	 * w肳ꂽDateIuWFNǧ擾܂B<br>
	 * @param date DateIuWFNg
	 * @return w肳ꂽDateIuWFNǧ
	 */
	public static String getMonth(Date date) {
		return date == null ? "" : format(new Date(), FORMAT_MM);
	}

	/**
	 * w肳ꂽDateIuWFNg̓擾܂B<br>
	 * @param date DateIuWFNg
	 * @return w肳ꂽDateIuWFNg̓
	 */
	public static String getDay(Date date) {
		return date == null ? "" : format(new Date(), FORMAT_DD);
	}

	/**
	 * w肳ꂽDateIuWFNg̎擾܂B<br>
	 * @param date DateIuWFNg
	 * @return w肳ꂽDateIuWFNg̎
	 */
	public static String getHour(Date date) {
		return date == null ? "" : format(new Date(), FORMAT_24HH);
	}

	/**
	 * w肳ꂽDateIuWFNg̎(12ԕ\L)擾܂B<br>
	 * @param date DateIuWFNg
	 * @return w肳ꂽDateIuWFNg̎(12ԕ\L)
	 */
	public static String getHour12(Date date) {
		return date == null ? "" : format(new Date(), FORMAT_12HH);
	}

	/**
	 * w肳ꂽDateIuWFNg̕擾܂B<br>
	 * @param date DateIuWFNg
	 * @return w肳ꂽDateIuWFNg̕
	 */
	public static String getMinute(Date date) {
		return date == null ? "" : format(new Date(), FORMAT_MI);
	}

	/**
	 * w肳ꂽDateIuWFNg̕b擾܂B<br>
	 * @param date DateIuWFNg
	 * @return w肳ꂽDateIuWFNg̕b
	 */
	public static String getSecond(Date date) {
		return date == null ? "" : format(new Date(), FORMAT_SS);
	}

	/**
	 * w肳ꂽDateIuWFNg̃~b擾܂B<br>
	 * @param date DateIuWFNg
	 * @return w肳ꂽDateIuWFNg̃~b
	 */
	public static String getMilliSecond(Date date) {
		return date == null ? "" : format(new Date(), FORMAT_SSS);
	}

	/**
	 * w肳ꂽDateIuWFNgߑO̎Ԃł邩肵܂B<br>
	 * @param date DateIuWFNg
	 * @return w肳ꂽDateIuWFNgߑO̎Ԃłꍇtrueԋp
	 */
	public static boolean isAM(Date date) {
		//return "ߑO".equals(format(date, FORMAT_A));
		return format(date, FORMAT_24HH).equals(format(date, FORMAT_12HH));
	}

	/**
	 * ݂DateIuWFNg擾܂B<br>
	 * DateIuWFNg̃CX^X̂܂ܕԋp郁\bhłA
	 * ѐ̈א݂Ă܂B<br>
	 * @return ݂DateIuWFNg
	 */
	public static Date getNowDate() {
		return new Date();
	}

	/**
	 * ݂̔N(yyyy)擾܂B<br>
	 * @return ݂̔N(yyyy)
	 */
	public static String getNowYear() {
		return getYear(new Date());
	}

	/**
	 * ݂̌(MM)擾܂B<br>
	 * @return ݂̌(MM)
	 */
	public static String getNowMonth() {
		return getMonth(new Date());
	}

	/**
	 * ݂̓(dd)擾܂B<br>
	 * @return ݂̓(dd)
	 */
	public static String getNowDay() {
		return getDay(new Date());
	}

	/**
	 * ݂̎(HH)擾܂B<br>
	 * @return ݂̎(HH)
	 */
	public static String getNowHour() {
		return getHour(new Date());
	}

	/**
	 * ݂̎(hh)擾܂B<br>
	 * @return ݂̎(hh)
	 */
	public static String getNowHour12() {
		return getHour12(new Date());
	}

	/**
	 * ݂̕(mm)擾܂B<br>
	 * @return ݂̕(mm)
	 */
	public static String getNowMinute() {
		return getMinute(new Date());
	}

	/**
	 * ݂̎ԂߑOł邩肵܂B<br>
	 */
	public static boolean isAMAtNow() {
		return isAM(new Date());
	}

	/**
	 * 񂪎w肳ꂽDateIuWFNgƏoL
	 * ł邩ǂ肵܂B<br>
	 * @param value Ώە
	 * @param pattern 菑
	 * @return Lȕ̏ꍇtrueԋp
	 */
	public static boolean isValidityDateStringValue(String value, String pattern) {
		if (value == null || pattern == null) {
			return false;
		}

		try {
			SimpleDateFormat format = new SimpleDateFormat(pattern);
			format.parse(value);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	/**
	 * 񂪎w肳ꂽDateFormatIuWFNgDateIuWFNgƏoL
	 * ł邩ǂ肵܂B<br>
	 * @param value Ώە
	 * @param format DateFormatIuWFNg
	 * @return Lȕ̏ꍇtrueԋp
	 */
	public static boolean isValidityDateStringValue(String value, DateFormat format) {
		if (value == null || format == null) {
			return false;
		}

		try {
			format.parse(value);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	/**
	 * fBtHg̏ŕDateIuWFNgƏoL
	 * ł邩ǂ肵܂B<br>
	 * @param value Ώە
	 * @return Lȕ̏ꍇtrueԋp
	 */
	public static boolean isValidityDateStringValue(String value) {
		if (value == null) {
			return false;
		}

		try {
			SimpleDateFormat format = new SimpleDateFormat(DEFAULT_FORMAT);
			format.parse(value);
		} catch (Exception e) {
			return false;
		}
		return true;
	}
}
