package org.phosphoresce.dbbrowser.resource.definition.dbdriver;

import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/**
 * DatabaseBrowserTvJDBC`XMLRecnhNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/26	Kitagawa		VK쐬
 *-->
 */
final class DatabaseBrowserJDBCSampleContentHandler implements ContentHandler {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** m[hl[(`m[h) */
	public static final String NODE_NAME_DEFINITION = "definition";

	/** m[h(`m[h) */
	public static final String NODE_ATTR_DEFINITION_NAME = "name";

	/** m[hl[(hCo) */
	public static final String NODE_NAME_DRIVER = "driver";

	/** m[hl[(TvJDBCAhX) */
	public static final String NODE_NAME_SAMPLE_ADDRESS = "sample-address";

	/** p[X`IuWFNg */
	private DatabaseBrowserJDBCSampleDefinition definition = null;

	/** `Xg */
	private List definitionList = new LinkedList();

	/** p[Xobt@ */
	private StringBuffer buffer = new StringBuffer();

	/** p[XtO */
	private boolean parsing = false;

	/** `m[hzp[XtO */
	private boolean parseInDefinition = false;

	/**
	 * RXgN^<br>
	 */
	public DatabaseBrowserJDBCSampleContentHandler() {
		super();
	}

	/**
	 * `Xg擾܂B<br>
	 * @return `Xg
	 */
	public List getDefinitionList() {
		return definitionList;
	}

	/**
	 * SAXCxg̔肷IuWFNg󂯎܂B<br>
	 * @param locator SAXCxg̈ʒuԂIuWFNg
	 * @see org.xml.sax.ContentHandler#setDocumentLocator(org.xml.sax.Locator)
	 */
	public void setDocumentLocator(Locator locator) {
	}

	/**
	 * ړURIOԃ}bsÕXR[vJn܂B<br>
	 * @param prefix 錾閼OԐړ
	 * @param uri ړ̃}bv於OURI
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#startPrefixMapping(java.lang.String, java.lang.String)
	 */
	public void startPrefixMapping(String prefix, String uri) throws SAXException {
	}

	/**
	 * ړ URI ̃}bsÕXR[vI܂B<br>
	 * @param prefix }bsOꂽړ
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#endPrefixMapping(java.lang.String)
	 */
	public void endPrefixMapping(String prefix) throws SAXException {
	}

	/**
	 * ̊Jnʒm󂯎܂B<br>
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#startDocument()
	 */
	public void startDocument() throws SAXException {
		log.info("Start parse sample JDBC definition resource.");
		parsing = true;
	}

	/**
	 * ̏Iʒm󂯎܂B<br>
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#endDocument()
	 */
	public void endDocument() throws SAXException {
		log.info("Parsed sample JDBC definition resource.");
		parsing = false;
	}

	/**
	 * vf̊Jnʒm󂯎܂B<br>
	 * @param uri OURI
	 * @param localName ړ܂܂Ȃ[J
	 * @param qName ړC
	 * @param atts vfɒǉꂽ
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
	 */
	public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
		if (NODE_NAME_DEFINITION.equals(localName)) {
			if (parseInDefinition) {
				throw new SAXException("not found 'definition' node end tag.");
			}
			parseInDefinition = true;
			definition = new DatabaseBrowserJDBCSampleDefinition();
			definition.setName(atts.getValue(NODE_ATTR_DEFINITION_NAME));
		} else if (NODE_NAME_DRIVER.equals(localName)) {
			if (!parseInDefinition) {
				throw new SAXException("not found 'definition' start end tag.");
			}
			buffer = new StringBuffer();
		} else if (NODE_NAME_SAMPLE_ADDRESS.equals(localName)) {
			if (!parseInDefinition) {
				throw new SAXException("not found 'definition' start end tag.");
			}
			buffer = new StringBuffer();
		}
	}

	/**
	 * vf̏Iʒm󂯎܂B<br>
	 * @param uri OURI
	 * @param localName ړ܂܂Ȃ[J
	 * @param qName ړCꂽXML
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#endElement(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void endElement(String uri, String localName, String qName) throws SAXException {
		if (NODE_NAME_DEFINITION.equals(localName)) {
			if (!parseInDefinition) {
				throw new SAXException("not found 'definition' node start tag.");
			}
			parseInDefinition = false;
			definitionList.add(definition);

			log.debug("loaded JDBC sample definition : " + definition);
		} else if (NODE_NAME_DRIVER.equals(localName)) {
			definition.setDriver(buffer.toString());
		} else if (NODE_NAME_SAMPLE_ADDRESS.equals(localName)) {
			definition.setSampleUrl(buffer.toString());
		}
	}

	/**
	 * f[^̒ʒm󂯎܂B<br>
	 * @param ch XML̕
	 * @param start z̊Jnʒu
	 * @param length z񂩂ǂݎ镶
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#characters(char[], int, int)
	 */
	public void characters(char[] ch, int start, int length) throws SAXException {
		buffer.append(ch, start, length);
	}

	/**
	 * vfRecɊ܂܂閳ł󔒕̒ʒm󂯎܂B<br>
	 * @param ch XML̕
	 * @param start z̊Jnʒu
	 * @param length z񂩂ǂݎ镶
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#ignorableWhitespace(char[], int, int)
	 */
	public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
	}

	/**
	 * XLbvꂽ̂̒ʒm󂯎܂B<br>
	 * @param name XLbvꂽ̖̂O
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#skippedEntity(java.lang.String)
	 */
	public void skippedEntity(String name) throws SAXException {
	}

	/**
	 * ߂̒ʒm󂯎܂B<br>
	 * @param target ߂̃^[Qbg
	 * @param data ߂󂯂f[^
	 * @throws SAXException SAXOꍇɃX[܂
	 * @see org.xml.sax.ContentHandler#processingInstruction(java.lang.String, java.lang.String)
	 */
	public void processingInstruction(String target, String data) throws SAXException {
	}
}
