package org.phosphoresce.dbbrowser.gui.window.about;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.EDialog;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.DatabaseBrowserConstants;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

/**
 * AoEg_CAO<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/24	Kitagawa		VK쐬
 *-->
 */
public final class AboutDialog extends EDialog {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static AboutDialog instance = null;

	/** Reipl */
	private EPanel containerPanel = null;

	/** AoEgC[Wpl */
	private EPanel aboutImagePanel = null;

	/** AoEgC[Wx */
	private ELabel aboutImageLabel = null;

	/** AvP[Vo[Wx */
	private ELabel applicationVersionLabel = null;

	/** TCgAhXx */
	private ELabel siteAddressLabel = null;

	/** {^pl */
	private EPanel buttonPanel = null;

	/** OK{^ */
	private EButton okButton = null;

	/**
	 * RXgN^<br>
	 * @param owner ʃReiIuWFNg
	 * @param modal [_tO
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 */
	private AboutDialog(Frame owner, boolean modal) throws HeadlessException {
		super(owner, modal);
		initialize();
		pack();
	}

	/**
	 * RXgN^<br>
	 */
	private AboutDialog() {
		super();
		initialize();
		pack();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static AboutDialog instance() {
		if (instance == null) {
			instance = new AboutDialog(DatabaseBrowserSession.instance().getBrowserFrame(), true);
		}
		return instance;
	}

	/**
	 * AoEg_CAO\܂B<br>
	 */
	public static void showAboutDialog() {
		instance().setVisible(true);
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setSize(new Dimension(420, 330));
		this.setContentPane(getContainerPanel());
		this.setTitle(DatabaseBrowserConstants.APPLICATION_TITLE);
		this.setLocationRelativeTo(getParent());

		getRootPane().setDefaultButton(getOkButton());
	}

	/**
	 * Reipl擾܂B<br>
	 * @return Reipl
	 */
	private EPanel getContainerPanel() {
		if (containerPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 1;
			gridBagConstraints1.weightx = 0.0D;
			gridBagConstraints1.weighty = 0.0D;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.gridy = 0;
			gridBagConstraints.weightx = 0.0D;
			gridBagConstraints.weighty = 0.0D;
			containerPanel = new EPanel();
			containerPanel.setLayout(new GridBagLayout());
			containerPanel.add(getAboutImagePanel(), gridBagConstraints);
			containerPanel.add(getButtonPanel(), gridBagConstraints1);
		}
		return containerPanel;
	}

	/**
	 * AoEgC[Wpl擾܂B<br>
	 * @return AoEgC[Wpl
	 */
	private EPanel getAboutImagePanel() {
		if (aboutImagePanel == null) {
			aboutImagePanel = new EPanel();
			aboutImagePanel.setLayout(null);
			aboutImagePanel.setPreferredSize(new Dimension(400, 250));
			aboutImagePanel.setMaximumSize(new Dimension(400, 250));
			aboutImagePanel.setMinimumSize(new Dimension(400, 250));
			aboutImagePanel.setBackground(Color.white);
			aboutImagePanel.add(getSiteAddressLabel(), null);
			aboutImagePanel.add(getApplicationVersionLabel(), null);
			aboutImagePanel.add(getAboutImageLabel(), null);
		}
		return aboutImagePanel;
	}

	/**
	 * AoEgC[Wx擾܂B<br>
	 * @return AoEgC[Wx
	 */
	private ELabel getAboutImageLabel() {
		if (aboutImageLabel == null) {
			aboutImageLabel = new ELabel();
			aboutImageLabel.setPreferredSize(new Dimension(400, 250));
			aboutImageLabel.setMaximumSize(new Dimension(400, 250));
			aboutImageLabel.setMinimumSize(new Dimension(400, 250));
			aboutImageLabel.setBounds(new Rectangle(0, 0, 400, 250));
			aboutImageLabel.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_APP_ABOUT_IMAGE));
		}
		return aboutImageLabel;
	}

	/**
	 * AvP[Vo[Wx擾܂B<br>
	 * @return AvP[Vo[Wx
	 */
	private ELabel getApplicationVersionLabel() {
		if (applicationVersionLabel == null) {
			applicationVersionLabel = new ELabel();
			applicationVersionLabel.setBounds(new Rectangle(17, 130, 371, 21));
			applicationVersionLabel.setText("Version " + DatabaseBrowserConstants.APPLICATION_VERSION);
		}
		return applicationVersionLabel;
	}

	/**
	 * TCgAhXx擾܂B<br>
	 * @return TCgAhXx
	 */
	private ELabel getSiteAddressLabel() {
		if (siteAddressLabel == null) {
			siteAddressLabel = new ELabel();
			siteAddressLabel.setBounds(new Rectangle(17, 224, 371, 21));
			siteAddressLabel.setText("http://sourceforge.jp/projects/phosphoresce/");
		}
		return siteAddressLabel;
	}

	/**
	 * {^pl擾܂B<br>
	 * @return {^pl
	 */
	private EPanel getButtonPanel() {
		if (buttonPanel == null) {
			buttonPanel = new EPanel();
			buttonPanel.setLayout(null);
			buttonPanel.setPreferredSize(new Dimension(400, 36));
			buttonPanel.setMaximumSize(new Dimension(400, 36));
			buttonPanel.setMinimumSize(new Dimension(400, 36));
			buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.darkGray));
			buttonPanel.add(getOkButton(), null);
		}
		return buttonPanel;
	}

	/**
	 * OK{^擾܂B<br>
	 * @return OK{^
	 */
	private EButton getOkButton() {
		if (okButton == null) {
			okButton = new EButton();
			okButton.setText("OK");
			okButton.setBounds(new Rectangle(307, 6, 86, 24));
			okButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					dispose();
				}
			});
		}
		return okButton;
	}
}
