package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.event.MouseEvent;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.csv.CSVManager;
import org.phosphoresce.commons.csv.CSVRecord;
import org.phosphoresce.commons.csv.CSVRecordList;
import org.phosphoresce.commons.csv.CSVToken;
import org.phosphoresce.commons.database.DatabaseInformation;
import org.phosphoresce.commons.database.accessor.RecordTableModelAccessor;
import org.phosphoresce.commons.database.accessor.ResultColumn;
import org.phosphoresce.commons.database.accessor.ResultColumnDefinition;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.commons.database.core.DatabaseQueryManager;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.sample.TableSorter;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;

/**
 * NGGfB^e폈sNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/20	Kitagawa		VK쐬
 *-->
 */
final class QueryManageActionContainer {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static QueryManageActionContainer instance = null;

	/**
	 * RXgN^<br>
	 */
	private QueryManageActionContainer() {
		super();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static QueryManageActionContainer instance() {
		if (instance == null) {
			instance = new QueryManageActionContainer();
		}
		return instance;
	}

	/**
	 * R[hANZXe[uf擾܂B<br>
	 * @return R[hANZXe[uf
	 */
	private RecordTableModelAccessor getTableModelAccessor() {
		JTable table = QueryManageResultTablePane.instance().getResultTable();
		TableModel model = table.getModel();
		if (model == null) {
			return null;
		} else {
			if (model instanceof RecordTableModelAccessor) {
				return (RecordTableModelAccessor) model;
			} else if (model instanceof TableSorter) {
				TableSorter sorter = (TableSorter) model;
				return (RecordTableModelAccessor) sorter.getTableModel();
			}
		}
		return null;
	}

	/**
	 * e[uXg̃NbNCxgANVs܂B<br>
	 * @param e MouseEventIuWFNg
	 */
	public void tableClickAction(MouseEvent e) {
		try {
			if (e.getClickCount() >= 2) {

				// eR|[lgIuWFNg擾
				DatabaseInformation information = new DatabaseInformation(DatabaseBrowserSession.instance().getCommonDatabaseSession());
				JTree tree = QueryManageEditorPane.instance().getCatalogSchemaTableListPanel().getTableTree();
				JTextArea textArea = QueryManageTextPane.instance().getQueryText();

				String separator = information.getCatalogSeparator();
				int row = tree.getClosestRowForLocation(e.getX(), e.getY());
				DefaultMutableTreeNode node = (DefaultMutableTreeNode) tree.getPathForRow(row).getLastPathComponent();
				if (node.getUserObject() != null && node.getUserObject() instanceof DatabaseTable) {
					DatabaseTable table = (DatabaseTable) node.getUserObject();
					if (table.getTableHolder() != null) {
						textArea.setText("select * from " + table.getTableHolder().getName() + separator + table.getName());
					} else {
						textArea.setText("select * from " + table.getName());
					}
					execute();

					log.trace("execute select query of tree table element.");
				}
			}
		} catch (Throwable throwable) {
			String errorMessage = "failed to insert row.";
			log.error(errorMessage, throwable);
			EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
		}
	}

	/**
	 * s}CxgANVs܂B<br>
	 */
	public void inertrow() {
		try {
			// eR|[lgIuWFNg擾
			JTable table = QueryManageResultTablePane.instance().getResultTable();
			QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();

			// s}
			RecordTableModelAccessor accessor = getTableModelAccessor();
			if (accessor != null) {
				accessor.insertRow();
				log.trace("inserted new row.");
			}
		} catch (Throwable throwable) {
			String errorMessage = "failed to insert row.";
			log.error(errorMessage, throwable);
			EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
		}
	}

	/**
	 * s폜CxgANVs܂B<br>
	 */
	public void deleterow() {
		log.trace("delete selected row.");
		try {
			// eR|[lgIuWFNg擾
			JTable table = QueryManageResultTablePane.instance().getResultTable();
			QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();

			// s폜
			RecordTableModelAccessor accessor = getTableModelAccessor();
			if (accessor != null) {
				int[] rows = table.getSelectedRows();
				for (int i = 0; i <= rows.length - 1; i++) {
					accessor.deleteRow(rows[i]);
				}
				log.trace("deleted " + rows.length + " rows.");
			}
		} catch (Throwable throwable) {
			String errorMessage = "failed to delete row.";
			log.error(errorMessage, throwable);
			EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
		}
	}

	/**
	 * NGsCxgANVs܂B<br>
	 */
	public void execute() {
		log.trace("execute query.");
		try {
			// eIuWFNg擾
			DatabaseSession session = DatabaseBrowserSession.instance().getDatabaseSession(QueryManageConstants.DBSESSION_KEY);
			JTable table = QueryManageResultTablePane.instance().getResultTable();
			QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();

			// G[NA
			errorPanel.clearError();

			// ZbV
			session.rollback();
			session.close();

			// ʃe[u
			table.setModel(new DefaultTableModel());

			// QueryManagerIuWFNgs
			DatabaseQueryManager manager = new DatabaseQueryManager(session);
			manager.setQuery(QueryManageTextPane.instance().getQueryText().getText());
			manager.execute();

			// NGsʏ
			if (manager.hasError()) {
				errorPanel.addError(manager.getError());
			} else {
				if (!manager.isSelectQuery()) {
					table.setModel(new DefaultTableModel(new String[][] { { String.valueOf(manager.getUpdateCount()) } }, new String[] { "update_count" }));
					table.setEnabled(false);
					table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
					session.commit();
				} else {
					RecordTableModelAccessor accessor = new RecordTableModelAccessor(manager.getResultSet());
					TableSorter sorter = new TableSorter(accessor, table.getTableHeader());
					table.setModel(sorter);
					table.setEnabled(true);
					table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
					session.commit();
					// e[uJ␳
					for (int i = 0; i <= accessor.getResultRowDefinition().getColumnCount() - 1; i++) {
						TableColumnModel columnModel = table.getColumnModel();
						String headerString = (String) table.getTableHeader().getColumnModel().getColumn(i).getHeaderValue();
						int size = accessor.getResultColumnDefinition(i).getDisplaySize();
						size = size < headerString.length() ? headerString.length() : size;
						size = size > 25 ? 25 : size;
						columnModel.getColumn(i).setPreferredWidth(size * 6);
					}
				}
			}
		} catch (Throwable throwable) {
			String errorMessage = "failed to execute query.";
			log.error(errorMessage, throwable);
			EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
		}
	}

	/**
	 * R~bgCxgANVs܂B<br>
	 */
	public void commit() {
		log.trace("session commit.");
		try {
			// eIuWFNg擾
			DatabaseSession session = DatabaseBrowserSession.instance().getDatabaseSession(QueryManageConstants.DBSESSION_KEY);
			JTable table = QueryManageResultTablePane.instance().getResultTable();
			QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();

			// G[NA
			QueryManageErrorListPane.instance().clearError();

			RecordTableModelAccessor accessor = getTableModelAccessor();
			if (accessor != null) {
				accessor.updateResult();
				session.commit();
				accessor.refreshResult();

				// G[ݒ
				errorPanel.clearError();
				errorPanel.addError(accessor.getErrors());

				log.trace("commited session transaction.");
			}
		} catch (Throwable throwable) {
			String errorMessage = "failed to commit.";
			log.error(errorMessage, throwable);
			EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
		}
	}

	/**
	 * [obNCxgANVs܂B<br>
	 */
	public void rollback() {
		log.trace("session rollback.");
		try {
			// eIuWFNg擾
			DatabaseSession session = DatabaseBrowserSession.instance().getDatabaseSession(QueryManageConstants.DBSESSION_KEY);
			JTable table = QueryManageResultTablePane.instance().getResultTable();
			QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();

			// G[NA
			QueryManageErrorListPane.instance().clearError();

			RecordTableModelAccessor accessor = getTableModelAccessor();
			if (accessor != null) {
				session.rollback();
				accessor.refreshResult();

				// G[ݒ
				errorPanel.clearError();
				errorPanel.addError(accessor.getErrors());

				log.trace("rollbacked session transaction.");
			}
		} catch (Throwable throwable) {
			String errorMessage = "failed to rollback.";
			log.error(errorMessage, throwable);
			EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
		}
	}

	/**
	 * ʕۑCxgANVs܂B<br>
	 */
	public void save() {
		log.trace("save result.");
		try {
			// eIuWFNg擾
			DatabaseSession session = DatabaseBrowserSession.instance().getDatabaseSession(QueryManageConstants.DBSESSION_KEY);
			JTable table = QueryManageResultTablePane.instance().getResultTable();
			QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();

			RecordTableModelAccessor accessor = getTableModelAccessor();
			if (accessor != null) {
				JFileChooser chooser = new JFileChooser();
				chooser.setDialogType(JFileChooser.SAVE_DIALOG);
				chooser.setDialogTitle("Save to CSV File");
				chooser.setMultiSelectionEnabled(false);
				chooser.addChoosableFileFilter(new FileFilter() {
					public String getDescription() {
						return "CSVt@C(*.csv)";
					}

					public boolean accept(File file) {
						if (file == null) {
							return false;
						}
						if (file.isDirectory()) {
							return true;
						}
						if (file.getAbsolutePath().endsWith(".csv")) {
							return true;
						}
						return false;
					}
				});
				boolean loopflag = true;
				while (loopflag) {
					int chooserReturn = chooser.showSaveDialog(DatabaseBrowserSession.instance().getBrowserFrame());
					File file = chooser.getSelectedFile();
					if (chooserReturn == JFileChooser.APPROVE_OPTION) {
						boolean save = false;
						if (file.exists()) {
							String filename = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
							int returnvalue = EMessageDialog.showQuestion(DatabaseBrowserSession.instance().getBrowserFrame(), filename
									+ " is already exist.<br>over write this file ?");
							if (returnvalue == EMessageDialog.BUTTON_YES) {
								save = true;
							}
						} else {
							save = true;
						}
						if (save) {
							log.trace("save to " + file + ".");
							loopflag = false;
							save(file);
						}
					} else {
						loopflag = false;
					}
				}
			}
		} catch (Throwable throwable) {
			String errorMessage = "failed to save result.";
			log.error(errorMessage, throwable);
			EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
		}
	}

	/**
	 * e[ufێew肳ꂽCSVt@Cɕۑ܂B<br>
	 * @throws Throwable ɗ\ʗOꍇɃX[܂
	 */
	private void save(File file) throws Throwable {
		RecordTableModelAccessor accessor = getTableModelAccessor();
		if (file == null || accessor == null) {
			return;
		}
		CSVRecordList list = new CSVRecordList();
		// Jo
		CSVRecord definitionRecord = new CSVRecord();
		for (int i = 0; i <= accessor.getColumnCount() - 1; i++) {
			ResultColumnDefinition columnDefinition = accessor.getResultColumnDefinition(i);
			CSVToken token = new CSVToken(columnDefinition.getName());
			definitionRecord.add(token);
		}
		list.add(definitionRecord);
		// ʓeo
		for (int i = 0; i <= accessor.getRowCount() - 1; i++) {
			CSVRecord record = new CSVRecord();
			for (int j = 0; j <= accessor.getColumnCount() - 1; j++) {
				ResultColumn column = accessor.getResultColumn(i, j);
				Object object = column.getValue();
				CSVToken token = new CSVToken(object == null ? "" : object.toString());
				record.add(token);
			}
			list.add(record);
		}
		CSVManager.save(list, file);
	}
}
