package org.phosphoresce.dbbrowser;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.util.ObjectUtil;
import org.phosphoresce.dbbrowser.exception.BrowserConfigException;

/**
 * DatabaseBrowserݒNX<br>
 * NXSerializableC^tF[XAi\ȃtB[ĥ݂ێ܂B<br>
 * OIɉis\ȃtB[hێꍇ́A͕ۑɑΏۂƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/24	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserConfig implements Serializable {

	/** VAo[WID */
	private static final long serialVersionUID = 4013287882658631214L;

	/** K[IuWFNg */
	private static transient Log log = LogFactory.getLog(DatabaseBrowserConfig.class);

	/** VOgZtCX^X */
	private static transient DatabaseBrowserConfig instance = null;

	/** ŋߗpf[^x[Xڑݒ */
	private DatabaseConfig recentDatabaseConfig = null;

	/** `ς݃f[^x[Xڑݒ胊Xg */
	private List databaseConfigDefinitionList = null;

	/** `ς݃f[^x[Xڑݒ`Xg */
	private List databaseConfigDefinitionNameList = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowserConfig() {
		super();
	}

	/**
	 * ZtCX^X擾܂B<br>
	 * @return DatabaseBrowserConfigNXtCX^X
	 */
	public static DatabaseBrowserConfig instance() {
		if (instance == null) {
			instance = new DatabaseBrowserConfig();
		}
		return instance;
	}

	/**
	 * ݒIuWFNgt@Cɕۑ܂B<br>
	 * @throws BrowserConfigException ɕۑȂꍇɔ
	 */
	public static void save() throws BrowserConfigException {
		try {
			ObjectUtil.saveSerializableObject(instance, DatabaseBrowserConstants.APPLICATION_CONFIG_FILE);
		} catch (Throwable e) {
			throw new BrowserConfigException("failed to save config file.", e);
		}
	}

	/**
	 * ݒIuWFNgt@Cǂݍ݂܂B<br>
	 * AAt@C݂Ȃꍇ͏񂪃NA܂B<br>
	 * ܂Aǂݍ݂ɏIȂꍇ͗O̓X[ꂸAɏ܂B<br>
	 * @throws BrowserConfigException ɓǂݍݏȂꍇɔ
	 */
	public static void load() throws BrowserConfigException {
		try {
			if (new File(DatabaseBrowserConstants.APPLICATION_CONFIG_FILE).exists()) {
				instance = (DatabaseBrowserConfig) ObjectUtil.loadSerializableObject(DatabaseBrowserConstants.APPLICATION_CONFIG_FILE);
			} else {
				instance = null;
			}
		} catch (Throwable e) {
			//throw new BrowserConfigException("failed to load config.", e);
			log.warn("failed to load config.", e);
		}
	}

	/**
	 * `ς݃f[^x[Xڑݒ`Xg擾܂B<br>
	 * @return `ς݃f[^x[Xڑݒ`Xg
	 */
	private List getDatabaseConfigDefinitionNameList() {
		if (databaseConfigDefinitionNameList == null) {
			databaseConfigDefinitionNameList = new LinkedList();
		}
		return databaseConfigDefinitionNameList;
	}

	/**
	 * `ς݃f[^x[Xڑݒ胊Xg擾܂B<br>
	 * @return `ς݃f[^x[Xڑݒ胊Xg
	 */
	private List getDatabaseConfigDefinitionList() {
		if (databaseConfigDefinitionList == null) {
			databaseConfigDefinitionList = new LinkedList();
		}
		return databaseConfigDefinitionList;
	}

	/**
	 * ŋߗpf[^x[Xڑݒ擾܂B<br>
	 * @return ŋߗpf[^x[Xڑݒ
	 */
	public DatabaseConfig getRecentDatabaseConfig() {
		if (recentDatabaseConfig == null) {
			recentDatabaseConfig = new DatabaseConfig();
		}
		return recentDatabaseConfig;
	}

	/**
	 * ŋߗpf[^x[Xڑݒݒ肵܂B<br>
	 * @param recentDatabaseConfig ŋߗpf[^x[Xڑݒ
	 */
	public void setRecentDatabaseConfig(DatabaseConfig recentDatabaseConfig) {
		this.recentDatabaseConfig = recentDatabaseConfig;
	}

	/**
	 * `ς݃f[^x[Xڑݒ萔擾܂B<br>
	 * @return `ς݃f[^x[Xڑݒ萔
	 */
	public int getDatabaseConfigDefinitionCount() {
		return getDatabaseConfigDefinitionList().size();
	}

	/**
	 * w肳ꂽڑݒ`ɑ݂邩肵܂B<br>
	 * @param name ڑݒ`
	 * @return ڑݒ`ɑ݂ꍇtrueԋp
	 */
	public boolean containsDatabaseConfigDefinitionName(String name) {
		return getDatabaseConfigDefinitionNameList().contains(name);
	}

	/**
	 * w肳ꂽڑݒ`̃CfbNX擾܂B<br>
	 * @param name ڑݒ`
	 * @return ڑݒ`̃CfbNX
	 */
	public int getDatabaseConfigDefinitionIndex(String name) {
		return getDatabaseConfigDefinitionNameList().indexOf(name);
	}

	/**
	 * w肳ꂽCfbNX̐ڑݒ`擾܂B<br>
	 * @param index `CfbNX
	 * @return w肳ꂽCfbNX̐ڑݒ`
	 */
	public String getDatabaseConfigDefinitionName(int index) {
		if (index < 0 || index > getDatabaseConfigDefinitionNameList().size() - 1) {
			return "";
		} else {
			return (String) getDatabaseConfigDefinitionNameList().get(index);
		}
	}

	/**
	 * w肳ꂽCfbNX̐ڑݒ擾܂B<br>
	 * @param index `CfbNX
	 * @return w肳ꂽCfbNX̐ڑݒ
	 */
	public DatabaseConfig getDatabaseConfigDefinition(int index) {
		if (index < 0 || index > getDatabaseConfigDefinitionList().size() - 1) {
			return new DatabaseConfig();
		} else {
			return (DatabaseConfig) getDatabaseConfigDefinitionList().get(index);
		}
	}

	/**
	 * w肳ꂽCfbNX̒`ݒ肵܂B<br>
	 * Xg͈͊ÕCfbNXw肳ꂽꍇ͖ɒǉ܂B<br>
	 * @param index CfbNX
	 * @param name `
	 * @param config `
	 */
	public void setDatabaseConfigDefinition(int index, String name, DatabaseConfig config) {
		if (index < 0 || index > getDatabaseConfigDefinitionList().size() - 1) {
			getDatabaseConfigDefinitionNameList().add(name);
			getDatabaseConfigDefinitionList().add(config);
		} else {
			getDatabaseConfigDefinitionNameList().set(index, name);
			getDatabaseConfigDefinitionList().set(index, config);
		}
	}
}
