package org.phosphoresce.dbbrowser;

import java.awt.Frame;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.core.ESwingConfig;
import org.phosphoresce.commons.eswing.core.ESwingConfigManager;
import org.phosphoresce.commons.logging.appender.TextPaneAppender;
import org.phosphoresce.commons.logging.config.LoggingColorSet;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserFrame;
import org.phosphoresce.dbbrowser.resource.definition.dbdriver.DatabaseBrowserJDBCSample;

/**
 * DatabaseBrowserAvP[VCNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/16	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowser {

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowser() {
		super();
	}

	/**
	 * C\bh<br>
	 * @param args R}hC
	 */
	public static void main(String[] args) {
		try {
			initialize();

			Log log = LogFactory.getLog(DatabaseBrowser.class);
			log.info("initialized application.");

			startup();
			log.info("successed to startup application.");
		} catch (Throwable throwable) {
			String errorMessage = "raised critical application exception.";
			EMessageDialog.showError((Frame) null, errorMessage, throwable);
			exit();
		}
	}

	/**
	 * ꊇōs܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	public static void initialize() throws Throwable {
		initializeSwing();
		initializeLogger();
		initializeConfigs();
	}

	/**
	 * Swing֘Ȁs܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	private static void initializeSwing() throws Throwable {
		ESwingConfigManager.configure();
		ESwingConfig.initializeMessageDialogConfig();
	}

	/**
	 * K[֘Ȁs܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	private static void initializeLogger() throws Throwable {
		DOMConfigurator.configure(DatabaseBrowser.class.getResource(DatabaseBrowserConstants.LOG4J_CONFIG_FILE));
		TextPaneAppender appender = TextPaneAppender.getAppender("textpane");
		if (appender != null) {
			appender.setColorSet(new LoggingColorSet());
		}
	}

	/**
	 * AvP[V̏s܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	private static void initializeConfigs() throws Throwable {
		DatabaseBrowserConfig.load();
		DatabaseBrowserJDBCSample.instance();
	}

	/**
	 * DatabaseBrowserN܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	private static void startup() throws Throwable {
		DatabaseBrowserSession browserSession = DatabaseBrowserSession.instance();
		DatabaseBrowserFrame browserFrame = DatabaseBrowserFrame.instance();

		browserSession.setBrowserFrame(browserFrame);

		browserFrame.setLocationRelativeTo(null);
		browserSession.initializeConfig();

		browserFrame.setVisible(true);
	}

	/**
	 * DatabaseBrowserI܂B<br>
	 */
	public static void exit() {
		System.exit(0);
	}
}
