/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.accessor.ResultColumn;

public class RecordTableModelAccessorRenderer
extends DefaultTableCellRenderer {
    private JTable parentTable;

    public RecordTableModelAccessorRenderer(JTable table) {
        this.parentTable = table;
    }

    private RecordTableModelAccessorRenderer() {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color background = table.getBackground();
        Color foreground = table.getForeground();
        if (value instanceof ResultColumn) {
            ResultColumn accessor = (ResultColumn)value;
            ResultAccessorState resultType = accessor.state;
            if (!isSelected) {
                if (resultType == ResultAccessorState.UPDATE) {
                    background = Color.decode("#ffdddd");
                    foreground = Color.decode("#000000");
                } else if (resultType == ResultAccessorState.INSERT) {
                    background = Color.decode("#ddffdd");
                    foreground = Color.decode("#000000");
                } else if (resultType == ResultAccessorState.DELETE) {
                    background = Color.decode("#ccaaaa");
                    foreground = Color.decode("#000000");
                } else if (resultType == ResultAccessorState.INSERT_DELETE) {
                    background = Color.decode("#ccccaa");
                    foreground = Color.decode("#000000");
                } else if (resultType == ResultAccessorState.REMOVED) {
                    background = Color.decode("#888888");
                    foreground = Color.decode("#000000");
                } else if (resultType == ResultAccessorState.UPDATE_ERROR) {
                    background = Color.decode("#ff0000");
                    foreground = Color.decode("#000000");
                } else if (resultType == ResultAccessorState.INSERT_ERROR) {
                    background = Color.decode("#ff0000");
                    foreground = Color.decode("#000000");
                }
            } else if (resultType == ResultAccessorState.UPDATE) {
                background = this.marge(table.getSelectionBackground(), Color.decode("#ffdddd"));
                foreground = this.marge(table.getSelectionForeground(), Color.decode("#000000"));
            } else if (resultType == ResultAccessorState.INSERT) {
                background = this.marge(table.getSelectionBackground(), Color.decode("#ddffdd"));
                foreground = this.marge(table.getSelectionForeground(), Color.decode("#000000"));
            } else if (resultType == ResultAccessorState.DELETE) {
                background = this.marge(table.getSelectionBackground(), Color.decode("#ccaaaa"));
                foreground = this.marge(table.getSelectionForeground(), Color.decode("#000000"));
            } else if (resultType == ResultAccessorState.INSERT_DELETE) {
                background = this.marge(table.getSelectionBackground(), Color.decode("#ccccaa"));
                foreground = this.marge(table.getSelectionForeground(), Color.decode("#000000"));
            } else if (resultType == ResultAccessorState.REMOVED) {
                background = this.marge(table.getSelectionBackground(), Color.decode("#888888"));
                foreground = this.marge(table.getSelectionForeground(), Color.decode("#000000"));
            } else if (resultType == ResultAccessorState.UPDATE_ERROR) {
                background = this.marge(table.getSelectionBackground(), Color.decode("#ff0000"));
                foreground = this.marge(table.getSelectionForeground(), Color.decode("#000000"));
            } else if (resultType == ResultAccessorState.INSERT_ERROR) {
                background = this.marge(table.getSelectionBackground(), Color.decode("#ff0000"));
                foreground = this.marge(table.getSelectionForeground(), Color.decode("#000000"));
            } else {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            }
            if (accessor.getValue() == null) {
                foreground = Color.decode("#aaaaaa");
                this.setText("<null>");
            }
        }
        this.setBackground(background);
        this.setForeground(foreground);
        return this;
    }

    private Color marge(Color color1, Color color2) {
        int r1 = color1.getRed();
        int g1 = color1.getGreen();
        int b1 = color1.getBlue();
        int r2 = color2.getRed();
        int g2 = color2.getGreen();
        int b2 = color2.getBlue();
        int rm = r2 - g1 / 5 - b1 / 5;
        int gm = g2 - r1 / 5 - b1 / 5;
        int bm = b2 - r1 / 5 - g1 / 5;
        rm = rm < 0 ? 0 : rm;
        gm = gm < 0 ? 0 : gm;
        bm = bm < 0 ? 0 : bm;
        return new Color(rm, gm, bm);
    }
}

