/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.launcher;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.launcher.LauncherConstants;
import org.phosphoresce.launcher.exception.PropertiesLoadException;
import org.phosphoresce.launcher.util.LauncherUtil;
import org.phosphoresce.launcher.util.PropertiesUtil;
import org.phosphoresce.launcher.util.StringUtil;

public final class LauncherSession
implements LauncherConstants {
    private boolean debug;
    private String[] library;
    private String mainClass;

    private LauncherSession() {
    }

    public LauncherSession(String properties) throws PropertiesLoadException {
        this.debug = Boolean.valueOf(PropertiesUtil.getValue(properties, "launcher.debug"));
        this.library = StringUtil.getTokenArray(PropertiesUtil.getValue(properties, "launcher.library"), ",");
        this.mainClass = PropertiesUtil.getValue(properties, "launcher.mainclass");
    }

    private List getFileList(File file) {
        LinkedList<File> list = new LinkedList<File>();
        if (file != null) {
            list.add(file);
            if (file.isDirectory()) {
                File[] files = file.listFiles(new FileFilter(){

                    public boolean accept(File path) {
                        return path != null && LauncherUtil.isLibrary(path.getAbsolutePath());
                    }
                });
                for (int i = 0; i <= files.length - 1; ++i) {
                    list.addAll(this.getFileList(files[i]));
                }
            }
        }
        return list;
    }

    public URL[] getLibraryURLs() throws MalformedURLException {
        LinkedList libraryList = new LinkedList();
        LinkedList<URL> urlList = new LinkedList<URL>();
        for (int i = 0; i <= this.library.length - 1; ++i) {
            libraryList.addAll(this.getFileList(new File(this.library[i])));
        }
        Iterator iterator = libraryList.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            urlList.add(file.toURL());
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String[] getLibrary() {
        return this.library;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-- Launcher Session Information");
        buffer.append("\n");
        buffer.append(" Debug     : " + this.debug);
        buffer.append("\n");
        buffer.append(" MainClass : " + this.mainClass);
        buffer.append("\n");
        buffer.append(" Library   : ");
        for (int i = 0; i <= this.library.length - 1; ++i) {
            buffer.append(i == 0 ? "" : "             ");
            buffer.append(this.library[i]);
            buffer.append(i == this.library.length - 1 ? "" : "\n");
        }
        return buffer.toString();
    }
}

