/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.launcher.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.phosphoresce.launcher.LauncherConstants;
import org.phosphoresce.launcher.LauncherSession;
import org.phosphoresce.launcher.exception.ClassLoaderException;
import org.phosphoresce.launcher.util.StringUtil;

public final class LauncherUtil
implements LauncherConstants {
    private LauncherUtil() {
    }

    public static boolean isLibrary(String filename) {
        File file;
        if (!StringUtil.isEmpty(filename) && (file = new File(filename)).exists() && file.isFile()) {
            int i = 0;
            while (i <= LauncherConstants.LIBRARY_EXTENSTIONS.length - 1) {
                if (file.getAbsolutePath().toUpperCase().endsWith("." + LauncherConstants.LIBRARY_EXTENSTIONS[i].toUpperCase())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static ClassLoader createClassLoader(LauncherSession session) throws ClassLoaderException {
        try {
            URL[] urls = session.getLibraryURLs();
            if (session.isDebug()) {
                System.out.println("-- ClassLoader Load Library");
                int i = 0;
                while (i <= urls.length - 1) {
                    System.out.println(" " + urls[i]);
                    ++i;
                }
            }
            return URLClassLoader.newInstance(urls);
        }
        catch (Exception e) {
            throw new ClassLoaderException("\u30bb\u30c3\u30b7\u30e7\u30f3\u304c\u4fdd\u6301\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u60c5\u5831\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public static void outputError(String message, Throwable throwable) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String filename = "error_" + format.format(new Date()) + ".log";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace();
        throwable.printStackTrace(printWriter);
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(filename));
            writer.println(message);
            writer.println(stringWriter.toString());
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            System.err.println("\u30a8\u30e9\u30fc\u30ed\u30b0\u306e\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u4e2d\u306b\u5165\u51fa\u529b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            e.printStackTrace();
        }
    }
}

