package org.phosphoresce.library.wpoi.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.phosphoresce.library.wpoi.exception.PoiException;
import org.phosphoresce.library.wpoi.util.PoiPrintConfig;

/**
 * POIV[gNXB<br>
 * org.apache.poi.hssf.usermodel.HSSFSheet̐ƎȃC^tF[XyсA
 * sێA񋟂邱ƂړIƂNXB<br>
 * HSSFSheetɑ΂SĂ̐C^tF[X͎ȂׁAg
 * HSSFSheetIuWFNg̎擾\bh͓NXɎB<br>
 * NX̃CX^XPoiWorkbook񋟂̂
 * [UӐ}IɃCX^X𐶐邱Ƃ͑z肵ȂB<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/11/21
 * 
 *<!--
 * XV       XV          XVe
 * 2005/11/21	Kitagawa		VK쐬
 * 2005/12/07	Kitagawa		PoiPrintConfigIuWFNgɂݒC^tF[Xǉ
 *-->
 */
public final class PoiSheet {

	/** MOIuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** PoiWorkbookIuWFNgCX^X */
	private PoiWorkbook pWorkbook;

	/** gHSSFSheetIuWFNg */
	private HSSFSheet hssfSheet;

	/**
	 * RXgN^<br>
	 */
	private PoiSheet() {
		//
	}

	/**
	 * RXgN^<br>
	 * @param pWorkbook PoiWorkbookIuWFNg
	 * @param hssfSheet HSSFSheetIuWFNg
	 */
	protected PoiSheet(PoiWorkbook pWorkbook, HSSFSheet hssfSheet) {
		this.pWorkbook = pWorkbook;
		this.hssfSheet = hssfSheet;

		// hssfSheetɑ΂ăRs[y[Xgs}̏sہAŏIsHSSFRownull̏ꍇɐ퓮삵ȂׁAIuWFNgǉ
		this.hssfSheet.createRow(hssfSheet.getLastRowNum() + 1);

		log.trace("******** V[gCX^X𐶐܂[" + getSheetName() + "]");
	}

	/**
	 * gHSSFSheetIuWFNg擾܂B<br>
	 * @return HSSFSheetIuWFNg
	 */
	protected HSSFSheet getHssfSheet() {
		return hssfSheet;
	}

	/**
	 * w肳ꂽV[gݒIuWFNg猻݂PoiSheet
	 * HSSFSheetIuWFNgɑ΂ĐݒKp܂B<br>
	 * @param config PoiSheetConfigIuWFNg
	 */
	public void applyPrintConfig(PoiPrintConfig config) {
		final double MARGIN_COEFFICIENT = 2.5;

		hssfSheet.setAutobreaks(config.isAutobreaks());
		hssfSheet.setHorizontallyCenter(config.isHorizontallyCenter());
		hssfSheet.setVerticallyCenter(config.isVerticallyCenter());
		hssfSheet.setMargin(HSSFSheet.TopMargin, config.getMarginOfTop() / MARGIN_COEFFICIENT);
		hssfSheet.setMargin(HSSFSheet.BottomMargin, config.getMarginOfBottom() / MARGIN_COEFFICIENT);
		hssfSheet.setMargin(HSSFSheet.LeftMargin, config.getMarginOfLeft() / MARGIN_COEFFICIENT);
		hssfSheet.setMargin(HSSFSheet.RightMargin, config.getMarginOfRight() / MARGIN_COEFFICIENT);

		hssfSheet.getHeader().setLeft(config.getHeaderLeftString());
		hssfSheet.getHeader().setCenter(config.getHeaderCenterString());
		hssfSheet.getHeader().setRight(config.getHeaderRightString());
		hssfSheet.getFooter().setLeft(config.getFooterLeftString());
		hssfSheet.getFooter().setCenter(config.getFooterCenterString());
		hssfSheet.getFooter().setRight(config.getFooterRightString());

		hssfSheet.getPrintSetup().setHeaderMargin(config.getMarginOfHeader() / MARGIN_COEFFICIENT);
		hssfSheet.getPrintSetup().setFooterMargin(config.getMarginOfFooter() / MARGIN_COEFFICIENT);
		hssfSheet.getPrintSetup().setFitHeight(config.getFitPageVerticalCount());
		hssfSheet.getPrintSetup().setFitWidth(config.getFitPageHorizontalCount());
		hssfSheet.getPrintSetup().setLandscape(config.isLandscape());
		hssfSheet.getPrintSetup().setScale(config.getScale());
		hssfSheet.getPrintSetup().setCopies(config.getCopies());
		hssfSheet.getPrintSetup().setDraft(config.isDraft());
		hssfSheet.getPrintSetup().setHResolution(config.getDpi());
		hssfSheet.getPrintSetup().setVResolution(config.getDpi());
		hssfSheet.getPrintSetup().setLeftToRight(config.isPrintTopToDown());
		hssfSheet.getPrintSetup().setNoColor(config.isMonoPrint());
		hssfSheet.getPrintSetup().setNotes(config.isPrintComment());
		hssfSheet.getPrintSetup().setPageStart(config.getStartPage());
		hssfSheet.getPrintSetup().setPaperSize(config.getPaperSize());

		//		hssfSheet.getPrintSetup().setNoOrientation(false); // ?
		//		hssfSheet.getPrintSetup().setOptions((short) 10); // ?
		//		hssfSheet.getPrintSetup().setUsePage(false); // ?
		//		hssfSheet.getPrintSetup().setValidSettings(false); // ?
	}

	/**
	 * V[gݒ肷B<br>
	 * @param name V[g
	 */
	public void setSheetName(String name) {
		for (int i = 0; i <= pWorkbook.getHssfWorkbook().getNumberOfSheets(); i++) {
			if (pWorkbook.getHssfWorkbook().getSheetAt(i).equals(hssfSheet)) {
				pWorkbook.getHssfWorkbook().setSheetName(i, name, HSSFWorkbook.ENCODING_UTF_16);
				break;
			}
		}
	}

	/**
	 * V[g擾B<br>
	 * @return V[g
	 */
	public String getSheetName() {
		for (int i = 0; i <= pWorkbook.getHssfWorkbook().getNumberOfSheets(); i++) {
			if (pWorkbook.getHssfWorkbook().getSheetAt(i).equals(hssfSheet)) {
				return pWorkbook.getHssfWorkbook().getSheetName(i);
			}
		}

		return null;
	}

	/**
	 * V[gێősʒu擾B<br>
	 * @return V[gێősʒu
	 */
	public int getLastRowNum() {
		return hssfSheet.getLastRowNum();
	}

	/**
	 * V[gێőJʒu擾B<br>
	 * @return V[gێőJʒu
	 */
	public short getLastColNum() {
		short col = 0;
		for (int i = 0; i <= getLastRowNum(); i++) {
			HSSFRow row = hssfSheet.getRow(i);
			if (row != null) {
				if (col < row.getLastCellNum()) {
					col = row.getLastCellNum();
				}
			}
		}
		return col;
	}

	/**
	 * w肳ꂽsʒuPoiRowIuWFNg擾܂B<br>
	 * fourceInstancetruew肳ĂHSSFRownull̏ꍇA
	 * VKHSSFRowCX^X𐶐܂B<br>
	 * @param row sʒu
	 * @param fourceInstance Ώۂ̍snull̏ꍇɋIɃCX^X𐶐ꍇtruew
	 * @return PoiRowIuWFNg
	 */
	public PoiRow getPoiRow(int row, boolean fourceInstance) {
		if (hssfSheet == null) {
			return null;
		} else {
			if (hssfSheet.getRow(row) == null) {
				if (fourceInstance) {
					return new PoiRow(pWorkbook, this, hssfSheet.createRow(row));
				} else {
					return null;
				}
			} else {
				return new PoiRow(pWorkbook, this, hssfSheet.getRow(row));
			}
		}
	}

	/**
	 * w肳ꂽsʒuPoiRowIuWFNg擾܂B<br>
	 * @param row sʒu
	 * @return PoiRowIuWFNg
	 */
	public PoiRow getPoiRow(int row) {
		return getPoiRow(row, false);
	}

	/**
	 * w肳ꂽsʒuyуJʒuPoiCellIuWFNg擾܂B<br>
	 * @param row sʒu
	 * @param col Jʒu
	 * @param fourceInstance Ώۂ̍syуZnull̏ꍇɋIɃCX^X𐶐ꍇtruew
	 * @return PoiCellIuWFNg
	 */
	public PoiCell getPoiCell(int row, short col, boolean fourceInstance) {
		if (fourceInstance) {
			PoiRow pRow = getPoiRow(row, true);
			PoiCell pCell = pRow.getPoiCell(col, true);
			return pCell;
		} else {
			PoiRow pRow = getPoiRow(row, false);
			PoiCell pCell = pRow.getPoiCell(col, false);
			return pCell;
		}
	}

	/**
	 * w肳ꂽsʒuyуJʒuPoiCellIuWFNg擾܂B<br>
	 * @param row sʒu
	 * @param col Jʒu
	 * @return PoiCellIuWFNg
	 */
	public PoiCell getPoiCell(int row, short col) {
		return getPoiCell(row, col, false);
	}

	/**
	 * w肳ꂽPoiRange͈͂̓ew肳ꂽsʒuAJʒuɑ΂ĕʂ܂B<br>
	 * @param fromRange ʑΏۃZ͈̓IuWFNg
	 * @param row ʐsʒu
	 * @param col ʐJʒu
	 * @throws PoiException ɃJS̕ʂsȂꍇɔ܂
	 */
	public void copyPaste(PoiRange fromRange, int row, short col) throws PoiException {
		Region[] regions = PoiUtil.getMargedRegions(hssfSheet, fromRange);

		PoiRange toRange = new PoiRange(fromRange);

		int shiftRow = row - fromRange.getRowFrom();
		short shiftCol = (short) (col - fromRange.getColFrom());

		toRange.shift(shiftRow, shiftCol);

		PoiUtil.clearMargedRegions(hssfSheet, toRange);

		for (int i = 0; i <= regions.length - 1; i++) {
			Region region = new Region();

			region.setRowFrom(regions[i].getRowFrom() + shiftRow);
			region.setRowTo(regions[i].getRowTo() + shiftRow);
			region.setColumnFrom((short) (regions[i].getColumnFrom() + shiftCol));
			region.setColumnTo((short) (regions[i].getColumnTo() + shiftCol));

			hssfSheet.addMergedRegion(region);
		}

		for (int i = fromRange.getRowFrom(); i <= fromRange.getRowTo(); i++) {
			HSSFRow rowFrom = hssfSheet.getRow(i);
			HSSFRow rowTo = hssfSheet.getRow(i + shiftRow);

			PoiUtil.copyRow(rowFrom, rowTo);
		}
	}

	/**
	 * w肳ꂽsɑ΂čsǉ܂B<br>
	 * @param row }Ώۍsʒu
	 */
	public void insertRow(int row) {
		hssfSheet.shiftRows(row, hssfSheet.getLastRowNum(), 1, true, true);
		hssfSheet.createRow(row);
		//log.trace("Inserted row [index=" + row + "]");
	}

	/**
	 * w肳ꂽsʒu̍s폜܂B<br>
	 * se폜邾ł͂ȂΏۂ̍ŝ̂폜ďɍsl߂鏈s܂B<br>
	 * ܂A폜ΏۍsɌZ݂ꍇ́ǍZċl߂鏈s܂B<br>
	 * @param row
	 */
	public void deleteRow(int row) {
		// sCX^X폜
		if (hssfSheet.getRow(row) != null) {
			hssfSheet.removeRow(hssfSheet.getRow(row));
		}

		// Z⊮
		for (int i = 0; i <= hssfSheet.getNumMergedRegions() - 1; i++) {
			Region region = hssfSheet.getMergedRegionAt(i);

			if (region.getRowFrom() == row && row == region.getRowTo()) {
				hssfSheet.removeMergedRegion(i);
				i = 0;
			} else if (row >= region.getRowFrom() && region.getRowTo() >= row) {
				hssfSheet.removeMergedRegion(i);
				region.setRowTo(region.getRowTo() - 1);
				hssfSheet.addMergedRegion(region);
				i = 0;
			}
		}

		// sl
		hssfSheet.shiftRows(row + 1, hssfSheet.getLastRowNum(), -1, true, true);
	}
}
