/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.library.wpoi.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.phosphoresce.library.wpoi.adapter.PoiRow;
import org.phosphoresce.library.wpoi.adapter.PoiSheet;
import org.phosphoresce.library.wpoi.adapter.PoiValue;
import org.phosphoresce.library.wpoi.adapter.PoiWorkbook;
import org.phosphoresce.library.wpoi.exception.PoiException;

public final class PoiCell {
    private Log log = LogFactory.getLog(this.getClass());
    private PoiWorkbook pWorkbook;
    private PoiSheet pSheet;
    private PoiRow pRow;
    private HSSFCell hssfCell;

    private PoiCell() {
    }

    protected PoiCell(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiRow pRow, HSSFCell hssfCell) {
        this.pWorkbook = pWorkbook;
        this.pSheet = pSheet;
        this.pRow = pRow;
        this.hssfCell = hssfCell;
    }

    protected HSSFCell getHssfCell() {
        return this.hssfCell;
    }

    public int getRowNum() throws PoiException {
        if (this.hssfCell == null) {
            return -1;
        }
        for (int i = 0; i <= this.pSheet.getLastRowNum(); ++i) {
            for (short j = 0; j <= this.pSheet.getLastColNum(); j = (short)(j + 1)) {
                if (!this.hssfCell.equals(this.pSheet.getPoiCell(i, j, true).getHssfCell())) continue;
                return i;
            }
        }
        return -1;
    }

    public short getColNum() throws PoiException {
        if (this.hssfCell == null) {
            return -1;
        }
        for (int i = 0; i <= this.pSheet.getLastRowNum(); ++i) {
            for (short j = 0; j <= this.pSheet.getLastColNum(); j = (short)(j + 1)) {
                if (!this.hssfCell.equals(this.pSheet.getPoiCell(i, j, true).getHssfCell())) continue;
                return j;
            }
        }
        return -1;
    }

    public void setValue(PoiValue value) throws PoiException {
        if (this.hssfCell == null) {
            return;
        }
        this.hssfCell.setEncoding((short)1);
        if (value.isNullValue()) {
            this.hssfCell.setCellValue("");
            this.log.trace((Object)"\u30bb\u30eb\u5024\u8a2d\u5b9a          : null");
        } else if (value.isBoolean()) {
            this.hssfCell.setCellValue(value.getBooleanValue());
            this.log.trace((Object)("\u30bb\u30eb\u5024\u8a2d\u5b9a(Boolean) : " + value.getBooleanValue()));
        } else if (value.isDate()) {
            this.hssfCell.setCellValue(value.getDateValue());
            this.log.trace((Object)("\u30bb\u30eb\u5024\u8a2d\u5b9a(Date)    : " + value.getDateValue()));
        } else if (value.isNumeric()) {
            this.hssfCell.setCellValue(value.getNumericValue());
            this.log.trace((Object)("\u30bb\u30eb\u5024\u8a2d\u5b9a(Numeric) : " + value.getNumericValue()));
        } else if (value.isString()) {
            if (value.isNumericalStringValue()) {
                this.hssfCell.setCellValue((double)Long.parseLong(value.getStringValue()));
                this.log.trace((Object)("\u30bb\u30eb\u5024\u8a2d\u5b9a(String)  : " + value.getStringValue() + " [\u6570\u5024\u3068\u3057\u3066\u30bb\u30c3\u30c8\u3055\u308c\u307e\u3057\u305f]"));
            } else {
                this.hssfCell.setCellValue(value.getStringValue());
                this.log.trace((Object)("\u30bb\u30eb\u5024\u8a2d\u5b9a(String)  : " + value.getStringValue()));
            }
        }
    }

    public String getForceStringValue() {
        return this.getForceStringValue(false);
    }

    public String getForceStringValue(boolean forceCalc) {
        if (this.hssfCell == null) {
            return "";
        }
        if (this.hssfCell.getCellType() == 3) {
            return "";
        }
        if (this.hssfCell.getCellType() == 4) {
            return String.valueOf(this.hssfCell.getBooleanCellValue());
        }
        if (this.hssfCell.getCellType() == 5) {
            return Byte.toString(this.hssfCell.getErrorCellValue());
        }
        if (!forceCalc && this.hssfCell.getCellType() == 2) {
            return String.valueOf(this.hssfCell.getCellFormula());
        }
        if (forceCalc && this.hssfCell.getCellType() == 2) {
            return "NaN".equals(this.renderIntOrDblValue(this.hssfCell.getNumericCellValue())) ? "" : this.renderIntOrDblValue(this.hssfCell.getNumericCellValue());
        }
        if (this.hssfCell.getCellType() == 0) {
            return "NaN".equals(this.renderIntOrDblValue(this.hssfCell.getNumericCellValue())) ? "" : this.renderIntOrDblValue(this.hssfCell.getNumericCellValue());
        }
        if (this.hssfCell.getCellType() == 1) {
            return String.valueOf(this.hssfCell.getStringCellValue());
        }
        return "";
    }

    private String renderIntOrDblValue(double value) {
        try {
            String dBuf = String.valueOf(value);
            String iBuf = String.valueOf(new Double(value).intValue());
            return Double.parseDouble(dBuf) == Double.parseDouble(iBuf) ? iBuf : dBuf;
        }
        catch (Exception e) {
            return "NaN";
        }
    }
}

