/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.library.wpoi.dyna;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.library.wpoi.adapter.PoiValue;
import org.phosphoresce.library.wpoi.dyna.PoiDynaList;
import org.phosphoresce.library.wpoi.dyna.PoiDynaMap;
import org.phosphoresce.library.wpoi.dyna.PoiDynaMapDescribe;
import org.phosphoresce.library.wpoi.exception.PoiException;

public class PoiDynaMapFactory {
    private static Log log = LogFactory.getLog((Class)PoiDynaMapFactory.class);
    public static final int DEFAULT_SEARCH_DEPTH = 3;

    public static PoiDynaList createDynaList(Object[] beans, int maxSearchDepth, String[] excludeKeys) throws PoiException {
        PoiDynaList dynaList = new PoiDynaList();
        if (beans == null || beans.length == 0) {
            return new PoiDynaList();
        }
        for (int i = 0; i <= beans.length - 1; ++i) {
            Object bean = beans[i];
            dynaList.add(PoiDynaMapFactory.createDynaMap(bean, maxSearchDepth, excludeKeys));
        }
        return dynaList;
    }

    public static PoiDynaList createDynaList(Object[] beans, int maxSearchDepth) throws PoiException {
        return PoiDynaMapFactory.createDynaList(beans, maxSearchDepth, null);
    }

    public static PoiDynaList createDynaList(Object[] beans, String[] excludeKeys) throws PoiException {
        return PoiDynaMapFactory.createDynaList(beans, 3, excludeKeys);
    }

    public static PoiDynaList createDynaList(Object[] beans) throws PoiException {
        return PoiDynaMapFactory.createDynaList(beans, 3);
    }

    public static PoiDynaList createDynaList(List beanList, int maxSearchDepth, String[] excludeKeys) throws PoiException {
        if (beanList == null || beanList.size() == 0) {
            return new PoiDynaList();
        }
        return PoiDynaMapFactory.createDynaList(beanList.toArray(new Object[beanList.size()]), maxSearchDepth, excludeKeys);
    }

    public static PoiDynaList createDynaList(List beanList, int maxSearchDepth) throws PoiException {
        if (beanList == null || beanList.size() == 0) {
            return new PoiDynaList();
        }
        return PoiDynaMapFactory.createDynaList(beanList.toArray(new Object[beanList.size()]), maxSearchDepth);
    }

    public static PoiDynaList createDynaList(List beanList, String[] excludeKeys) throws PoiException {
        return PoiDynaMapFactory.createDynaList(beanList, 3, excludeKeys);
    }

    public static PoiDynaList createDynaList(List beanList) throws PoiException {
        return PoiDynaMapFactory.createDynaList(beanList, 3);
    }

    public static PoiDynaMap createDynaMap(Object bean, int maxSearchDepth, String[] excludeKeys) throws PoiException {
        try {
            if (bean == null) {
                return null;
            }
            if (bean instanceof Object[]) {
                throw new PoiException("PoiDynaMap\u751f\u6210\u5bfe\u8c61Bean\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u914d\u5217\u306b\u306a\u3063\u3066\u3044\u307e\u3059");
            }
            if (bean instanceof List) {
                throw new PoiException("PoiDynaMap\u751f\u6210\u5bfe\u8c61Bean\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304cList\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u306a\u3063\u3066\u3044\u307e\u3059");
            }
            PoiDynaMapDescribe describe = new PoiDynaMapDescribe();
            return PoiDynaMapFactory.renderDynaMap(describe.describe(bean), 0, maxSearchDepth, describe, excludeKeys);
        }
        catch (Exception e) {
            throw new PoiException("\u6307\u5b9a\u3055\u308c\u305fBean\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304b\u3089PoiDynaMap\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f[" + bean.getClass().getName() + "]", e);
        }
    }

    public static PoiDynaMap createDynaMap(Object bean, int maxSearchDepth) throws PoiException {
        return PoiDynaMapFactory.createDynaMap(bean, maxSearchDepth, null);
    }

    public static PoiDynaMap createDynaMap(Object bean, String[] excludeKeys) throws PoiException {
        return PoiDynaMapFactory.createDynaMap(bean, 3, excludeKeys);
    }

    public static PoiDynaMap createDynaMap(Object bean) throws PoiException {
        return PoiDynaMapFactory.createDynaMap(bean, null);
    }

    private static PoiDynaMap renderDynaMap(Map map, int depth, int maxSearchDepth, PoiDynaMapDescribe describe, String[] excludeKeys) throws PoiException {
        if (depth > maxSearchDepth) {
            log.trace((Object)"\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u518d\u8d77\u691c\u7d22\u9650\u754c\u5024\u3092\u8d85\u3048\u305f\u306e\u3067\u3053\u308c\u4ee5\u4e0a\u306e\u691c\u7d22\u306f\u884c\u3044\u307e\u305b\u3093");
            return null;
        }
        try {
            PoiDynaMap dynaMap = new PoiDynaMap();
            if (map == null) {
                return null;
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object2;
                PoiDynaList dynaList;
                String key = (String)iterator.next();
                Object object = map.get(key);
                log.trace((Object)("**** \u9805\u76ee : " + key));
                boolean skip = false;
                if (excludeKeys != null) {
                    for (int i = 0; i <= excludeKeys.length - 1; ++i) {
                        if (!key.equals(excludeKeys[i])) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) {
                    log.trace((Object)("**** \u9805\u76ee(" + key + ")\u306f\u7121\u8996\u3055\u308c\u307e\u3059"));
                    continue;
                }
                if (PoiValue.isValidPoiValue(object)) {
                    PoiValue render = PoiValue.createPoiValue(object);
                    dynaMap.put(key, render);
                    continue;
                }
                if (object instanceof Object[]) {
                    dynaList = new PoiDynaList();
                    for (int i = 0; i <= ((Object[])object).length - 1; ++i) {
                        object2 = ((Object[])object)[i];
                        if (PoiValue.isValidPoiValue(object2)) {
                            log.trace((Object)"PoiDynaMap\u751f\u6210\u5143Map\u5185\u306bBean\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u914d\u5217\u4ee5\u5916\u306e\u914d\u5217\u304c\u542b\u307e\u308c\u3066\u3044\u308b\u305f\u3081\u7121\u8996\u3057\u307e\u3057\u305f");
                            continue;
                        }
                        dynaList.add(PoiDynaMapFactory.renderDynaMap(describe.describe(object2), depth + 1, maxSearchDepth, describe, excludeKeys));
                    }
                    dynaMap.put(key, dynaList);
                    continue;
                }
                if (object instanceof Collection) {
                    dynaList = new PoiDynaList();
                    Iterator iterator2 = ((Collection)object).iterator();
                    while (iterator2.hasNext()) {
                        object2 = iterator2.next();
                        if (PoiValue.isValidPoiValue(object2)) {
                            log.trace((Object)"PoiDynaMap\u751f\u6210\u5143Map\u5185\u306bBean\u30aa\u30d6\u30b8\u30a7\u30af\u30c8Collection\u4ee5\u5916\u306eCollection\u304c\u542b\u307e\u308c\u3066\u3044\u308b\u305f\u3081\u7121\u8996\u3057\u307e\u3057\u305f");
                            continue;
                        }
                        dynaList.add(PoiDynaMapFactory.renderDynaMap(describe.describe(object2), depth + 1, maxSearchDepth, describe, excludeKeys));
                    }
                    dynaMap.put(key, dynaList);
                    continue;
                }
                PoiDynaMap innerDynaMap = PoiDynaMapFactory.renderDynaMap(describe.describe(object), depth + 1, maxSearchDepth, describe, excludeKeys);
                if (innerDynaMap == null) continue;
                PoiDynaMap render = innerDynaMap.getNestedDynaMap(key);
                dynaMap.putAll(render);
            }
            return dynaMap;
        }
        catch (Exception e) {
            throw new PoiException("\u6b63\u5e38\u306bMap\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304b\u3089PoiDynaMap\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u751f\u6210\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }
}

