/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.library.wpoi.adapter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.phosphoresce.library.wpoi.adapter.PoiUtil;
import org.phosphoresce.library.wpoi.exception.PoiException;

public final class PoiValue
implements Serializable {
    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_DATE = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_NUMERIC = 3;
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final Date DEFAULT_DATE = new Date(-2209021200000L);
    public static final String DEFAULT_STRING = "";
    public static final double DEFAULT_NUMERIC = 0.0;
    private int type;
    private Object value;

    private PoiValue() {
    }

    public PoiValue(boolean value) {
        this.type = 0;
        this.value = value;
    }

    public PoiValue(Boolean value) {
        this.type = 0;
        this.value = value;
    }

    public PoiValue(Date value) {
        this.type = 1;
        this.value = value;
    }

    public PoiValue(int value) {
        this.type = 3;
        this.value = Double.valueOf(String.valueOf(value));
    }

    public PoiValue(Integer value) {
        this.type = 3;
        this.value = value == null ? null : Double.valueOf(String.valueOf(value));
    }

    public PoiValue(long value) {
        this.type = 3;
        this.value = Double.valueOf(String.valueOf(value));
    }

    public PoiValue(Long value) {
        this.type = 3;
        this.value = value == null ? null : Double.valueOf(String.valueOf(value));
    }

    public PoiValue(double value) {
        this.type = 3;
        this.value = Double.valueOf(String.valueOf(value));
    }

    public PoiValue(Double value) {
        this.type = 3;
        this.value = value == null ? null : value;
    }

    public PoiValue(BigDecimal value) {
        this.type = 3;
        this.value = value == null ? null : Double.valueOf(String.valueOf(value.doubleValue()));
    }

    public PoiValue(BigInteger value) {
        this.type = 3;
        this.value = value == null ? null : Double.valueOf(String.valueOf(value.doubleValue()));
    }

    public PoiValue(String value) {
        this.type = 2;
        this.value = value == null ? null : value;
    }

    public PoiValue(int type, String value) throws PoiException {
        try {
            switch (type) {
                case 0: {
                    this.value = value == null ? null : Boolean.valueOf(value);
                    break;
                }
                case 1: {
                    this.value = value == null ? null : PoiUtil.parseDate(value);
                    break;
                }
                case 2: {
                    this.value = value == null ? null : value;
                    break;
                }
                case 3: {
                    this.value = value == null ? null : Double.valueOf(value);
                    break;
                }
                default: {
                    throw new PoiException("\u4e0d\u660e\u306e\u30bb\u30eb\u30bf\u30a4\u30d7[" + type + "]\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
                }
            }
        }
        catch (PoiException e) {
            throw new PoiException("\u7121\u52b9\u306a\u30bb\u30eb\u30bf\u30a4\u30d7[" + type + "]\u3068\u30bb\u30eb\u5024[" + value + "]\u306e\u7d44\u307f\u5408\u308f\u305b\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        catch (RuntimeException e) {
            throw new PoiException("\u7121\u52b9\u306a\u30bb\u30eb\u30bf\u30a4\u30d7[" + type + "]\u3068\u30bb\u30eb\u5024[" + value + "]\u306e\u7d44\u307f\u5408\u308f\u305b\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        this.type = type;
    }

    public boolean isNullValue() {
        return this.value == null;
    }

    public boolean isBoolean() {
        return this.type == 0;
    }

    public boolean isDate() {
        return this.type == 1;
    }

    public boolean isString() {
        return this.type == 2;
    }

    public boolean isNumeric() {
        return this.type == 3;
    }

    public boolean isNumericalStringValue() {
        if (this.value instanceof String) {
            try {
                Long.parseLong((String)this.value);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public boolean getBooleanValue() throws PoiException {
        if (!this.isBoolean()) {
            throw new PoiException("\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u30bf\u30a4\u30d7\u3068\u7570\u306a\u308b\u30bf\u30a4\u30d7\u3067\u5024\u3092\u53d6\u5f97\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        return this.isNullValue() ? false : (Boolean)this.value;
    }

    public Date getDateValue() throws PoiException {
        if (!this.isDate()) {
            throw new PoiException("\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u30bf\u30a4\u30d7\u3068\u7570\u306a\u308b\u30bf\u30a4\u30d7\u3067\u5024\u3092\u53d6\u5f97\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        return this.isNullValue() ? null : (Date)this.value;
    }

    public String getStringValue() throws PoiException {
        if (!this.isString()) {
            throw new PoiException("\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u30bf\u30a4\u30d7\u3068\u7570\u306a\u308b\u30bf\u30a4\u30d7\u3067\u5024\u3092\u53d6\u5f97\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        return this.isNullValue() ? DEFAULT_STRING : (String)this.value;
    }

    public double getNumericValue() throws PoiException {
        if (!this.isNumeric()) {
            throw new PoiException("\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u30bf\u30a4\u30d7\u3068\u7570\u306a\u308b\u30bf\u30a4\u30d7\u3067\u5024\u3092\u53d6\u5f97\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        return this.isNullValue() ? 0.0 : (Double)this.value;
    }

    public String toString() {
        return this.value == null ? DEFAULT_STRING : this.value.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PoiValue)) {
            return false;
        }
        if (!(object == null && this.value == null || object != null && this.value != null)) {
            return false;
        }
        return object.toString().equals(this.value.toString());
    }

    public static PoiValue createPoiValue(Object object) throws PoiException {
        if (object == null) {
            return new PoiValue(DEFAULT_STRING);
        }
        if (object instanceof Boolean) {
            return new PoiValue((Boolean)object);
        }
        if (object instanceof Date) {
            return new PoiValue((Date)object);
        }
        if (object instanceof Integer) {
            return new PoiValue((Integer)object);
        }
        if (object instanceof Long) {
            return new PoiValue((Long)object);
        }
        if (object instanceof Double) {
            return new PoiValue((Double)object);
        }
        if (object instanceof BigDecimal) {
            return new PoiValue((BigDecimal)object);
        }
        if (object instanceof BigInteger) {
            return new PoiValue((BigInteger)object);
        }
        if (object instanceof String) {
            return new PoiValue((String)object);
        }
        throw new PoiException("PoiValue\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304b\u3089PoiValue\u3092\u751f\u6210\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
    }

    public static boolean isValidPoiValue(Object object) {
        try {
            PoiValue.createPoiValue(object);
            return true;
        }
        catch (PoiException e) {
            return false;
        }
    }
}

