/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.library.wpoi.adapter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.Region;
import org.phosphoresce.library.wpoi.adapter.PoiRange;
import org.phosphoresce.library.wpoi.exception.PoiException;

final class PoiUtil {
    PoiUtil() {
    }

    public static void copyCell(HSSFCell cellFrom, HSSFCell cellTo) {
        cellTo.setCellType(cellFrom.getCellType());
        cellTo.setCellStyle(cellFrom.getCellStyle());
        if (3 == cellFrom.getCellType()) {
            cellTo.setCellValue("");
        } else if (4 == cellFrom.getCellType()) {
            cellTo.setCellValue(cellFrom.getBooleanCellValue());
        } else if (5 == cellFrom.getCellType()) {
            cellTo.setCellErrorValue(cellFrom.getErrorCellValue());
        } else if (2 == cellFrom.getCellType()) {
            cellTo.setCellFormula(cellFrom.getCellFormula());
        } else if (0 == cellFrom.getCellType()) {
            cellTo.setCellValue(cellFrom.getNumericCellValue());
        } else if (1 == cellFrom.getCellType()) {
            cellTo.setCellValue(cellFrom.getStringCellValue());
        }
    }

    public static void copyRow(HSSFRow rowFrom, HSSFRow rowTo) {
        short maxCellNum = rowFrom.getLastCellNum() < rowTo.getLastCellNum() ? rowTo.getLastCellNum() : rowFrom.getLastCellNum();
        for (short i = 0; i <= maxCellNum; i = (short)(i + 1)) {
            HSSFCell cellFrom = rowFrom.getCell(i);
            HSSFCell cellTo = rowTo.getCell(i);
            if (cellFrom != null && cellTo != null) {
                PoiUtil.copyCell(cellFrom, cellTo);
                continue;
            }
            if (cellFrom == null && cellTo != null) {
                rowTo.removeCell(cellTo);
                continue;
            }
            if (cellFrom == null || cellTo != null) continue;
            rowTo.createCell(i);
            cellTo = rowTo.getCell(i);
            PoiUtil.copyCell(cellFrom, cellTo);
        }
        rowTo.setHeight(rowFrom.getHeight());
    }

    public static boolean isEqualsRegion(Region region1, Region region2) {
        return region1.getColumnFrom() == region2.getColumnFrom() && region1.getColumnTo() == region2.getColumnTo() && region1.getRowFrom() == region2.getRowFrom() && region1.getRowTo() == region1.getRowTo() && region1.getArea() == region1.getArea();
    }

    public static void clearMargedRegion(HSSFSheet sheet, int row, short col) {
        for (int i = 0; i <= sheet.getNumMergedRegions() - 1; ++i) {
            Region region = sheet.getMergedRegionAt(i);
            if (row < region.getRowFrom() || row > region.getRowTo() || col < region.getColumnFrom() || col > region.getColumnTo()) continue;
            sheet.removeMergedRegion(i);
        }
    }

    public static void clearMargedRegions(HSSFSheet sheet, PoiRange range) {
        for (int i = range.getRowFrom(); i <= range.getRowTo(); ++i) {
            for (short j = range.getColFrom(); j <= range.getColTo(); j = (short)(j + 1)) {
                PoiUtil.clearMargedRegion(sheet, i, j);
            }
        }
    }

    public static Region getMargedRegion(HSSFSheet sheet, int row, short col) {
        for (int i = 0; i <= sheet.getNumMergedRegions() - 1; ++i) {
            Region region = sheet.getMergedRegionAt(i);
            if (row < region.getRowFrom() || row > region.getRowTo() || col < region.getColumnFrom() || col > region.getColumnTo()) continue;
            return region;
        }
        return null;
    }

    public static Region[] getMargedRegions(HSSFSheet sheet, PoiRange range) {
        LinkedList<Region> buffer = new LinkedList<Region>();
        for (int i = range.getRowFrom(); i <= range.getRowTo(); ++i) {
            for (short j = range.getColFrom(); j <= range.getColTo(); j = (short)(j + 1)) {
                Region region = PoiUtil.getMargedRegion(sheet, i, j);
                if (region == null) continue;
                boolean isContain = false;
                for (int c = 0; c <= buffer.size() - 1; ++c) {
                    Region r = (Region)buffer.get(c);
                    if (!PoiUtil.isEqualsRegion(r, region)) continue;
                    isContain = true;
                }
                if (isContain) continue;
                buffer.add(region);
            }
        }
        Region[] regions = new Region[buffer.size()];
        for (int i = 0; i <= buffer.size() - 1; ++i) {
            regions[i] = (Region)buffer.get(i);
        }
        return regions;
    }

    public static Date parseDate(String value) throws PoiException {
        SimpleDateFormat formatYYYYMMDD = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat formatYYYYsMMsDD = new SimpleDateFormat("yyyy/MM/dd");
        Date date = null;
        try {
            date = formatYYYYMMDD.parse(value);
        }
        catch (ParseException e) {
            try {
                date = formatYYYYsMMsDD.parse(value);
            }
            catch (ParseException e1) {
                throw new PoiException("\u5bfe\u5fdc\u3057\u3066\u3044\u308b\u65e5\u4ed8\u66f8\u5f0f\u5909\u63db\u66f8\u5f0f\u306fyyyyMMdd\u307e\u305f\u306fyyyy/MM/dd\u306e\u307f\u3067\u3059");
            }
        }
        return date;
    }
}

