package org.phosphoresce.commons.wpoi.dyna;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.phosphoresce.commons.wpoi.adapter.PoiCell;
import org.phosphoresce.commons.wpoi.adapter.PoiRange;
import org.phosphoresce.commons.wpoi.adapter.PoiRow;
import org.phosphoresce.commons.wpoi.adapter.PoiSheet;
import org.phosphoresce.commons.wpoi.adapter.PoiValue;
import org.phosphoresce.commons.wpoi.adapter.PoiWorkbook;
import org.phosphoresce.commons.wpoi.exception.PoiException;
import org.phosphoresce.commons.wpoi.exception.PoiIOException;
import org.phosphoresce.commons.wpoi.util.PoiPrintConfig;
import org.phosphoresce.commons.wpoi.util.PoiProgressMonitor;

/**
 * POIIo͑NXB<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/12/07
 * 
 *<!--
 * XV       XV          XVe
 * 2005/12/07	Kitagawa		VK쐬
 * 2006/01/18	Kitagawa		V[gɃV[gIƂȂoOC
 * 2006/01/25	Kitagawa		V[gɕV[gƂĂExcelt@CƂĐ\ɕύX(I/FύX)
 *-->
 */
public final class PoiDynaSheet implements Serializable {

	/** MOIuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** ev[gExcelt@CpX */
	private String path;

	/** ev[gExcelV[gCfbNX */
	private int index;

	/** [V[gz */
	private String[] sheetNames;

	/** _Ci~bN}bvz */
	private PoiDynaMap[] dynaMaps;

	/** [V[gݒIuWFNgz */
	private PoiPrintConfig[] printConfigs;

	/** fobOpJE^ */
	public int debugCount = 0;

	/** fobOpo̓tO */
	public static boolean debugOut = false;

	/** i󋵃j^IuWFNg */
	private PoiProgressMonitor monitor = null;

	/**
	 * RXgN^<br>
	 */
	private PoiDynaSheet() {
		//
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽev[gExcelt@Cƃev[gx[XƂȂ
	 * V[gCfbNXŃNX܂B<br>
	 * @param path ev[gExcelt@CpX
	 * @param index ev[gExcelV[gCfbNX(0`)
	 */
	public PoiDynaSheet(String path, int index) {
		this.path = path;
		this.index = index;
		this.sheetNames = new String[] {};
		this.dynaMaps = new PoiDynaMap[] {};
		this.printConfigs = new PoiPrintConfig[] {};
		this.monitor = null;
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽev[gExcelt@Cƃev[gx[XƂȂ
	 * V[gCfbNXŃNX܂B<br>
	 * @param path ev[gExcelt@CpX
	 * @param index ev[gExcelV[gCfbNX(0`)
	 * @param monitor i󋵃j^IuWFNg
	 */
	public PoiDynaSheet(String path, int index, PoiProgressMonitor monitor) {
		this.path = path;
		this.index = index;
		this.sheetNames = new String[] {};
		this.dynaMaps = new PoiDynaMap[] {};
		this.printConfigs = new PoiPrintConfig[] {};
		this.monitor = monitor;
	}

	/**
	 * fobOpV[go͂sB<br>
	 * t@C̓ev[gt@C(DEBUG+JE^.xls)t`ŏo͂B<br>
	 * ܂łJfobOpƂėp̂łB<br>
	 */
	private void debugOutSheet(PoiWorkbook pWorkbook) {
		if (debugOut) {
			debugCount++;
			String postfix = debugCounter(debugCount);

			try {
				pWorkbook.save(path + "." + "DEBUG" + postfix + ".xls");
			} catch (PoiIOException e) {
				e.printStackTrace();
			}

			log.trace("................................................................ fobOpo͂s܂[" + postfix + "]");
		}
	}

	/**
	 * w肳ꂽ4ɕ␳ĕŕԋp܂B<br>
	 * @param count
	 * @return
	 */
	private String debugCounter(int count) {
		String render = String.valueOf(count);
		for (; render.length() < 4; render = "0" + render)
			;
		return render;
	}

	/**
	 * ij^IuWFNgw肳ĂꍇɎw肳ꂽbZ[Wݒ肵܂B<br>
	 * @param message bZ[W
	 */
	private void setMonitorMessage(String message) {
		if (monitor != null) {
			monitor.setMessage(message);
		}
	}

	/**
	 * w肳ꂽV[gPoiDynaMapIuWFNgŐV[gǉ܂B<br>
	 * @param sheetName ΏۃV[g
	 * @param dynaMap Il}bvIuWFNg
	 * @throws PoiException ̃V[gǉA1ȉ̃V[gw肵ꍇɔ
	 */
	public void addDynaSheet(String sheetName, PoiDynaMap dynaMap) throws PoiException {
		// V[gnullIuWFNg܂͋̏ꍇ̓G[
		if (sheetName == null || sheetName.length() == 0) {
			throw new PoiException("w肷V[g1ȉ̕܂nullIuWFNgw肳܂");
		}

		// V[gꍇ̓G[
		for (int i = 0; i <= sheetNames.length - 1; i++) {
			if (sheetName.equals(sheetNames[i])) {
				throw new PoiException("ɑ݂V[g[" + sheetName + "]ŃV[gǉ悤Ƃ܂");
			}
		}

		// V[gz̒ǉ
		List sheetNameList = new LinkedList(Arrays.asList(sheetNames));
		sheetNameList.add(sheetName);
		sheetNames = (String[]) sheetNameList.toArray(new String[sheetNameList.size()]);

		// PoiDynaMapIuWFNg̒ǉ
		List dynaMapList = new LinkedList(Arrays.asList(dynaMaps));
		dynaMapList.add(dynaMap);
		dynaMaps = (PoiDynaMap[]) dynaMapList.toArray(new PoiDynaMap[dynaMapList.size()]);

		// PoiPrintConfigIuWFNg̒ǉ
		List printConfigList = new LinkedList(Arrays.asList(printConfigs));
		printConfigList.add(null);
		printConfigs = (PoiPrintConfig[]) printConfigList.toArray(new PoiPrintConfig[printConfigList.size()]);
	}

	/**
	 * w肳ꂽV[gPoiDynaMapIuWFNgŐV[gǉ܂B<br>
	 * V[gɎw肳ꂽݒIuWFNgKp܂B<br>
	 * @param sheetName ΏۃV[g
	 * @param dynaMap Il}bvIuWFNg
	 * @param printConfig ݒIuWFNg
	 * @throws PoiException ̃V[gǉA1ȉ̃V[gw肵ꍇɔ
	 */
	public void addDynaSheet(String sheetName, PoiDynaMap dynaMap, PoiPrintConfig printConfig) throws PoiException {
		// V[gnullIuWFNg܂͋̏ꍇ̓G[
		if (sheetName == null || sheetName.length() == 0) {
			throw new PoiException("w肷V[g1ȉ̕܂nullIuWFNgw肳܂");
		}

		// V[gꍇ̓G[
		for (int i = 0; i <= sheetNames.length - 1; i++) {
			if (sheetName.equals(sheetNames[i])) {
				throw new PoiException("ɑ݂V[g[" + sheetName + "]ŃV[gǉ悤Ƃ܂");
			}
		}

		// V[gz̒ǉ
		List sheetNameList = new LinkedList(Arrays.asList(sheetNames));
		sheetNameList.add(sheetName);
		sheetNames = (String[]) sheetNameList.toArray(new String[sheetNameList.size()]);

		// PoiDynaMapIuWFNg̒ǉ
		List dynaMapList = new LinkedList(Arrays.asList(dynaMaps));
		dynaMapList.add(dynaMap);
		dynaMaps = (PoiDynaMap[]) dynaMapList.toArray(new PoiDynaMap[dynaMapList.size()]);

		// PoiPrintConfigIuWFNg̒ǉ
		List printConfigList = new LinkedList(Arrays.asList(printConfigs));
		printConfigList.add(printConfig);
		printConfigs = (PoiPrintConfig[]) printConfigList.toArray(new PoiPrintConfig[printConfigList.size()]);
	}

	/**
	 * NXtB[hɐݒ肳Ăev[gt@CpXyуev[g
	 * V[gCfbNXPoiWorkbookIuWFNg𐶐B<br>
	 * @return PoiWorkbookIuWFNg
	 * @throws PoiException Ƀev[gExcelt@CIuWFNg𐶐łȂꍇɔ
	 * @throws PoiIOException IO삪sȂꍇɔ
	 */
	private PoiWorkbook createWorkbookManager() throws PoiException, PoiIOException {
		try {
			setMonitorMessage("[o͏Jn܂");

			// ݒ肳ĂpXHSSFWorkbookIuWFNg̐
			HSSFWorkbook workbook = new HSSFWorkbook(new POIFSFileSystem(new FileInputStream(new File(path))));

			// ݒ肳Ăev[gV[gCfbNXs̏ꍇ̓G[
			if (workbook.getNumberOfSheets() - 1 < index) {
				throw new PoiException("w肳ꂽV[gCfbNX[" + index + "]݂͑܂");
			}

			// ev[gV[gȊȌׂɕKvev[gV[gŌɃRs[
			workbook.cloneSheet(index);

			// ev[gV[gȊÕV[g
			int sheetCount = workbook.getNumberOfSheets();
			for (int i = 0; i <= sheetCount - 2; i++) {
				workbook.removeSheetAt(0);
			}

			// 2ȏ̃V[g𐶐ꍇev[gV[g𕡎
			for (int i = 1; i <= sheetNames.length - 1; i++) {
				workbook.cloneSheet(0);
			}

			// 擪V[gfBtHgIԂƂ
			for (int i = 0; i <= workbook.getNumberOfSheets() - 1; i++) {
				workbook.getSheetAt(i).setSelected(false);
			}
			workbook.getSheetAt(0).setSelected(true);

			log.trace("******** ev[gp̃[NubNV[gCX^X𐶐܂[" + path + ":" + index + "]");

			return new PoiWorkbook(workbook);
		} catch (FileNotFoundException e) {
			throw new PoiIOException("w肳ꂽt@C[" + path + "]ȂÃvZXŃbNĂ܂", e);
		} catch (IOException e) {
			throw new PoiIOException("w肳ꂽt@C[" + path + "]J܂ł", e);
		}
	}

	/**
	 * NXtB[hɐݒ肳Ăev[gt@CpXyуev[g
	 * V[gCfbNXPoiWorkbookIuWFNg𐶐APoiDynaMapIuWFNg
	 * ̓eZbgPoiWorkbook𐶐܂B<br>
	 * @return PoiWorkbookIuWFNg
	 * @throws PoiException Ƀev[gExcelt@CIuWFNg𐶐łȂA܂͒l̓IݒɎsꍇɔ
	 * @throws PoiIOException IO삪sȂꍇɔ
	 */
	private PoiWorkbook createDynaValuedWorkbookManager() throws PoiException, PoiIOException {

		// PoiWorkbook̐
		PoiWorkbook pWorkbook = createWorkbookManager();

		/*
		 * tB[hɐݒ肳Ă铮Il}bvIuWFNǧŃV[g𓮓Iɐ
		 * 1ȏ̃V[gIuWFNg݂ȂꍇOX[
		 */
		if (sheetNames.length == 0) {
			throw new PoiException("Io͑Ώۂ̃V[g1݂܂");
		}

		for (int i = 0; i <= sheetNames.length - 1; i++) {
			// PoiSheet̐
			PoiSheet pSheet = pWorkbook.getPoiSheet(i);

			// V[g̐ݒ
			pSheet.setSheetName(sheetNames[i]);

			// ݒIuWFNg̓Kp
			if (printConfigs[i] != null) {
				pSheet.applyPrintConfig(printConfigs[i]);
			}

			/*
			 * V[g̓IZɑ΂PoiDynaMap̒lݒ肷
			 */
			for (int j = 0; j <= pSheet.getLastRowNum(); j++) {
				log.trace("---------------- " + j + "sڂ̓IlZbgC[vJn܂");

				PoiRow pRow = pSheet.getPoiRow(j);

				// Xgwpɐ擪Z擾
				PoiCell headPCell = pRow == null ? null : pRow.getPoiCell((short) 0);

				// Csԍ
				int returnRow = -1;

				if (PoiDynaUtil.isDynaCell(headPCell) //
						&& (PoiDynaUtil.isDynaListStart(headPCell) || PoiDynaUtil.isDynaListEnd(headPCell))) {
					// XgIwXgJnwɒ`Ăꍇ̓G[
					if (PoiDynaUtil.isDynaListEnd(headPCell)) {
						throw new PoiException("XgJnwL[ɃXgIL[`Ă܂");
					}

					/*
					 * XgCe[g͈͂̓
					 */
					int endListRow = getDynaListEndIdentifierRowNum(pWorkbook, pSheet, headPCell);

					// XgJnwL[ɑΉ郊XgIwL[݂Ȃꍇ̓G[
					if (endListRow == -1) {
						throw new PoiException("XgJnwL[[" + PoiDynaUtil.getDynaKey(headPCell) + "]ɑΉIwL[݂܂");
					}

					log.trace("XgJnwL[擾[s(" + PoiDynaUtil.getDynaKey(headPCell) + ") : " + j + "-" + endListRow + "]");

					// Xgf[^Zbg
					returnRow = setDynaList(pWorkbook, pSheet, dynaMaps[i], PoiDynaUtil.getDynaKey(headPCell), PoiDynaUtil.getDynaComment(headPCell), j, endListRow, null);
				} else {
					returnRow = setDynaValues(pWorkbook, pSheet, pRow, dynaMaps[i]);
				}

				int adjustJ = returnRow >= 0 ? returnRow : j;

				log.trace("---------------- " + j + "sڂ̓IlZbgC[vI܂ / ㎟sԍ = " + (adjustJ + 1));

				// fobOpo
				debugOutSheet(pWorkbook);

				j = adjustJ;
			}
		}

		return pWorkbook;
	}

	/**
	 * w肳ꂽPoiCellɃXgIwL[݂sʒu擾܂B<br>
	 * @param pWorkbook PoiWorkbookIuWFNg
	 * @param pSheet PoiSheetIuWFNg
	 * @param pCell PoiCellIuWFNg
	 * @return XgIwL[݂sʒuA݂Ȃꍇ-1ԋp
	 * @throws PoiException ɏIxL[łȂꍇɔ
	 */
	private int getDynaListEndIdentifierRowNum(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiCell pCell) throws PoiException {
		/*
		 * XgCe[g͈͂̓
		 */
		int endListRow = -1;
		String listKey = PoiDynaUtil.getDynaKey(pCell);

		log.trace("XgJԂIs܂[" + listKey + "] : Jns" + pCell.getRowNum() + "ł");

		for (int j = pCell.getRowNum() + 1; j <= pSheet.getLastRowNum(); j++) {
			PoiRow checkPRow = pSheet.getPoiRow(j);

			// Xgwpɐ擪Z擾
			PoiCell checkHeadPCell = checkPRow.getPoiCell((short) 0);

			//log.trace("`FbNΏۃZl : " + (checkHeadPCell == null ? "null" : checkHeadPCell.getForceStringValue()));

			if (PoiDynaUtil.isDynaCell(checkHeadPCell) && PoiDynaUtil.isDynaListEnd(checkHeadPCell) //
					&& listKey.equals(PoiDynaUtil.getDynaKey(checkHeadPCell))) {
				endListRow = j;
				break;
			}
		}
		return endListRow;
	}

	/**
	 * w肳ꂽPoiCellIuWFNgɑ΂PoiDynaMapIuWFNgێl𓮓IɃZbg܂B<br>
	 * @param pWorkbook PoiWorkbookIuWFNg
	 * @param pSheet PoiSheetIuWFNg
	 * @param pCell PoiCellIuWFNg
	 * @param dynaMap PoiDynaMapIuWFNg
	 * @param range ͈͓̓IlZbg̏ꍇɕ␳sׂ̃WIuWFNg(␳KvȂꍇnullw)
	 * @throws PoiException ɒlZbgłȂꍇɔ
	 */
	private int setDynaValues(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiCell pCell, PoiDynaMap dynaMap, PoiRange range) throws PoiException {
		// lZbg㏈Asԍ
		int returnRow = pCell == null ? -1 : pCell.getRowNum();

		// HSSFCellIuWFNgnull̏ꍇ͏sȂ
		if (pCell == null) {
			log.trace("ZIuWFNgnull̈׏XLbv܂");
		} else {
			// HSSFCellIuWFNgXgf[^̊Jn܂͏IxĂꍇ̓G[
			if (PoiDynaUtil.isDynaListStart(pCell)) {
				if (pCell.getColNum() == (short) 0) {
					int innerListStartRow = pCell.getRowNum();
					int innerListEndRow = getDynaListEndIdentifierRowNum(pWorkbook, pSheet, pCell);
					String innerListKey = PoiDynaUtil.getDynaKey(pCell);
					String innerListComment = PoiDynaUtil.getDynaComment(pCell);

					log.trace("---- Kw\̃XgwL[擾܂ : " + innerListKey + "[" + innerListStartRow + "-" + innerListEndRow + "]");

					PoiDynaList list = dynaMap.getDynaList(innerListKey);

					returnRow = setDynaList(pWorkbook, pSheet, dynaMap, innerListKey, innerListComment, innerListStartRow, innerListEndRow, range);

					log.trace("---- Kw\̃Xg̐ݒ肪܂ : " + innerListKey + " Asԍ = " + returnRow);
				} else {
					throw new PoiException("ev[g̃Xgf[^wL[͐擪Ẑݒ`Ă܂");
				}
			} else if (PoiDynaUtil.isDynaListEnd(pCell)) {
				throw new PoiException("XgJnwL[ɃXgIL[`Ă܂");
			} else {
				// ev[g̓IZL[擾
				String key = PoiDynaUtil.getDynaKey(pCell);
				String comment = PoiDynaUtil.getDynaComment(pCell);

				// Zɑ΂l̐ݒ菈
				if (dynaMap != null) {
					if (!dynaMap.containsKey(key)) {
						//throw new PoiException("IZL[[" + key + "]POIDynaMapIuWFNgɑ݂܂");

						log.warn("PoiDynaMap͎̃L[ێĂ܂ : \"" + key + "\"");

						pCell.setValue(new PoiValue(""));
					} else if (dynaMap.isDynaList(key)) {
						throw new PoiException("PIuWFNgłׂIZL[[" + key + "]ɃXgf[^ݒ肳Ă܂");
					} else {
						PoiValue value = dynaMap.getDynaValue(key);

						log.trace("Ilݒ(" + debugCounter(pCell.getRowNum()) + "s) : \"" + key + "(" + comment + ")\" = " + value);

						pCell.setValue(value);
					}
				} else {
					log.warn("PoiDynaMap̓IuWFNgnullł : \"" + key + "\"");

					pCell.setValue(new PoiValue(""));
				}
			}
		}

		return returnRow;
	}

	/**
	 * w肳ꂽPoiRowIuWFNgɑ΂PoiDynaMapIuWFNgێl𓮓IɃZbg܂B<br>
	 * @param pWorkbook PoiWorkbookIuWFNg
	 * @param pSheet PoiSheetIuWFNg
	 * @param pRow PoiRowIuWFNg
	 * @param dynaMap PoiDynaMapIuWFNg
	 * @throws PoiException ɒlZbgłȂꍇɔ
	 */
	private int setDynaValues(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiRow pRow, PoiDynaMap dynaMap) throws PoiException {
		// lZbg㏈Asԍ
		int returnRow = pRow == null ? -1 : pRow.getRowNum();

		// HSSFRowIuWFNgnull̏ꍇ͏sȂ
		if (pRow == null) {
			return returnRow;
		}

		// HSSFRowIuWFNgHSSFCellIuWFNgŏIJ܂ŃCe[g
		for (short j = 0; j <= pRow.getLastColNum(); j++) {
			PoiCell pCell = pRow.getPoiCell(j);

			if (PoiDynaUtil.isDynaCell(pCell)) {
				returnRow = setDynaValues(pWorkbook, pSheet, pCell, dynaMap, null);
			}
		}

		return returnRow;
	}

	/**
	 * w肳ꂽPoiRangeIuWFNg͈̔͂ɑ΂PoiDynaMapIuWFNgێl𓮓IɃZbg܂B<br>
	 * @param pWorkbook PoiWorkbookIuWFNg
	 * @param pSheet PoiSheetIuWFNg
	 * @param range PoiRangeIuWFNg
	 * @param dynaMap PoiDynaMapIuWFNg
	 * @throws PoiException ɒlZbgłȂꍇɔ
	 */
	private int setDynaValues(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiRange range, PoiDynaMap dynaMap) throws PoiException {
		// lZbg㏈Asԍ
		int returnRow = -1;

		for (int i = range.getRowFrom(); i <= range.getRowTo(); i++) {
			for (short j = range.getColFrom(); j <= range.getColTo(); j++) {
				PoiCell pCell = pSheet.getPoiCell(i, j);

				if (PoiDynaUtil.isDynaCell(pCell)) {
					returnRow = setDynaValues(pWorkbook, pSheet, pCell, dynaMap, range);

					if (returnRow >= 0) {
						i = returnRow;
					}
				}
			}
		}

		return returnRow;
	}

	/**
	 * Xgf[^𓮓Iɐݒ肵܂B<br>
	 * @param pWorkbook PoiWorkbookIuWFNg
	 * @param pSheet PoiSheetIuWFNg
	 * @param dynaMap PoiDynaMapIuWFNg
	 * @param key PoiDynaMapɕێĂ郊XgIuWFNg̃L[
	 * @param comment IݒJRg
	 * @param startRow XgJnwʍs܂ފJnsCfbNX(0`)
	 * @param endRow XgIwʍs܂ޏIsCfbNX(0`)
	 * @return IɃXgf[^ݒ肵̃Xgf[^IssCfbNX
	 * @throws PoiException ɃXgf[^𓮓IɐݒłȂꍇɔ
	 */
	private int setDynaList(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiDynaMap dynaMap, String key, String comment, int startRow, int endRow, PoiRange adjustRange)
			throws PoiException {
		log.trace("-------- [" + debugCounter(startRow) + "s] IXgݒ菈Jn");

		// I}sl
		int adjustRow = 0;

		// Xgʍs̍폜
		pSheet.deleteRow(endRow);
		pSheet.deleteRow(startRow);

		// XgZbgs
		int setRows = (endRow - startRow + 1) - 2;

		// Xgf[^TCY
		int listSize = 0;

		log.trace("ev[gXgev[gsTCY" + setRows + "ł");

		// ␳Ώۂ̃WIuWFNgꍇ͕␳(Xgʎq)
		if (adjustRange != null) {
			log.trace("WIuWFNgݒ肳Ă̂Ŏʎqsk = -2" + " / ύXO : " + adjustRange);
			adjustRange.setRowTo(adjustRange.getRowTo() - 2);
			log.trace("ύX̃WIuWFNg : " + adjustRange);
		}

		// ev[gRange
		if (startRow + 1 == endRow) {
			log.warn("ev[gɓIl`1s݂ȂXgʎqׁ̈AXLbv܂");
		} else {
			PoiRange range = new PoiRange(startRow, (short) 0, endRow - 2, pSheet.getLastColNum());

			log.trace("XgJւRs[W[" + range.toString() + "]");

			if (!dynaMap.containsKey(key)) {
				log.warn("I}bṽL[ێ܂ : \"" + key + "\"");

				// Xgf[^L[݂ȂA܂̓Xgf[^̏ꍇ̓ev[gŝ̂폜
				for (int i = 0; i <= setRows - 1; i++) {
					pSheet.deleteRow(startRow);
				}

				// ␳Ώۂ̃WIuWFNgꍇ͕␳(Xgev[g)
				if (adjustRange != null) {
					log.trace("WIuWFNgݒ肳Ă̂Ńev[gk = -" + setRows + " / ύXO : " + adjustRange);
					adjustRange.setRowTo(adjustRange.getRowTo() - setRows);
					log.trace("ύX̃WIuWFNg : " + adjustRange);
				}
			} else if (dynaMap.getDynaList(key) == null || dynaMap.getDynaList(key).size() == 0) {
				log.trace("XgTCY0ׁ̈Aev[gs폜̂ݍs܂");

				// Xgf[^L[݂ȂA܂̓Xgf[^̏ꍇ̓ev[gŝ̂폜
				for (int i = 0; i <= setRows - 1; i++) {
					pSheet.deleteRow(startRow);
				}

				// ␳Ώۂ̃WIuWFNgꍇ͕␳(Xgev[g)
				if (adjustRange != null) {
					log.trace("WIuWFNgݒ肳Ă̂Ńev[gk = -" + setRows + " / ύXO : " + adjustRange);
					adjustRange.setRowTo(adjustRange.getRowTo() - setRows);
					log.trace("ύX̃WIuWFNg : " + adjustRange);
				}
			} else {
				listSize = dynaMap.getDynaList(key).size();

				log.trace("ZbgXgTCY" + listSize + "ł");

				// XgZbglXgTCY̍s}(1TCY͌̃ev[g)
				for (int i = 0; i <= (listSize - 1) * setRows - 1; i++) {
					pSheet.insertRow(startRow + setRows);
				}

				// }XgTCY̍sɑ΂ăev[gZ𕡎
				for (int i = 1; i <= listSize - 1; i++) {
					pSheet.copyPaste(range, startRow + (i * setRows), (short) 0);
				}

				// ␳Ώۂ̃WIuWFNgꍇ͕␳(XgsWg)
				if (adjustRange != null) {
					log.trace("WIuWFNgݒ肳Ă̂ŃXgg = +" + (setRows * (listSize - 1)) + " / ύXO : " + adjustRange);
					adjustRange.setRowTo(adjustRange.getRowTo() + (setRows * (listSize - 1)));
					log.trace("ύX̃WIuWFNg : " + adjustRange);
				}

				// ̃ev[g͈͋yѕʂev[gɑ΂Ēlݒ肷
				PoiRange setRange = new PoiRange(range);
				for (int i = 0; i <= listSize - 1; i++) {
					setMonitorMessage(listSize + "" + (i + 1) + "ڂ" + comment + "R[hł");

					log.trace("XgCfbNX(=" + i + ")̃XgZbg܂[" + debugCounter(startRow) + "sڂ̏]");
					log.trace("͈̔͂ɑ΂ďs܂ : " + setRange);

					// fobOpo
					debugOutSheet(pWorkbook);

					if (i > 0) {
						setRange.shift(setRows, (short) 0);
					}

					int returnRow = setDynaValues(pWorkbook, pSheet, setRange, dynaMap.getDynaList(key).get(i));
				}

				// slXgZbglR[hCNg
				adjustRow += listSize * setRows;
			}

			log.trace("XgZbg܂A" + (startRow + adjustRow) + "sڂ菈𑱍s܂");
		}

		log.trace("-------- [" + debugCounter(startRow) + "s] IXgݒ菈I");

		// fobOpo
		debugOutSheet(pWorkbook);

		return startRow + adjustRow - 1;
	}

	/**
	 * w肳ꂽExcelt@CpXɑ΂ĒlZbgeۑ܂B<br>
	 * @param path o͑ΏExcelt@CpX
	 * @throws PoiException ɒl̃ZbgAt@C̕ۑoȂꍇɔ
	 * @throws PoiIOException IO삪sȂꍇɔ
	 */
	public void save(String path) throws PoiException, PoiIOException {
		log.trace("######## w肳ꂽpX[" + path + "]ɑ΂ēIExcelt@C̐Jn܂");

		PoiWorkbook pWorkbook = createDynaValuedWorkbookManager();

		log.trace("######## w肳ꂽpX[" + path + "]ɑ΂ēIExcelt@C̐܂");

		pWorkbook.setSelectedSheet(pWorkbook.getNumberOfSheets() - 1);
		pWorkbook.save(path);

		log.trace("######## w肳ꂽpX[" + path + "]ɑ΂ēIExcelt@C̕ۑ܂");
	}

	/**
	 * w肳ꂽOutputStreamIuWFNglZbgeo͂܂B<br>
	 * <b>OutputStreamIuWFNgɑ΂N[Y͒S܂B</b>
	 * @param os OutputStreamIuWFNg
	 * @throws PoiException ɒl̃ZbgAt@C̏o͏oȂꍇɔ
	 * @throws PoiIOException IO삪sȂꍇɔ
	 */
	public void save(OutputStream os) throws PoiException, PoiIOException {
		log.trace("######## w肳ꂽOutputStreamɑ΂ēIExcelt@C̐Jn܂");

		PoiWorkbook pWorkbook = createDynaValuedWorkbookManager();

		log.trace("######## w肳ꂽpXOutputStreamɑ΂ēIExcelt@C̐܂");

		pWorkbook.setSelectedSheet(pWorkbook.getNumberOfSheets() - 1);
		pWorkbook.save(os);

		log.trace("######## w肳ꂽpXOutputStreamɑ΂ēIExcelt@C̕ۑ܂");
	}

	/**
	 * PoiWorkbookIuWFNgƂēIlZbgExcel񋟂܂B<br>
	 * t@C܂OutputStreamIuWFNgւ̕ۑ͎gp̃^C~OɈˑ܂B<br>
	 * @return PoiWorkbookIuWFNg
	 * @throws PoiException ɒl̃ZbgAt@C̏o͏oȂꍇɔ
	 * @throws PoiIOException IO삪sȂꍇɔ
	 */
	public PoiWorkbook save() throws PoiException, PoiIOException {
		log.trace("######## PoiWorkbookIuWFNg̐Jn܂");

		PoiWorkbook pWorkbook = createDynaValuedWorkbookManager();

		pWorkbook.setSelectedSheet(pWorkbook.getNumberOfSheets() - 1);

		log.trace("######## PoiWorkbookIuWFNg̐܂");

		return pWorkbook;
	}
}
