package org.phosphoresce.commons.wpoi.dyna;

import java.util.LinkedList;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.phosphoresce.commons.wpoi.adapter.PoiValue;
import org.phosphoresce.commons.wpoi.exception.PoiException;

/**
 * BeanIuWFNg_ONX<br>
 * BeanIuWFNggpꍇ͈ȑOɎgpMapCX^X񋟂B<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2006/02/16
 * 
 *<!--
 * XV       XV          XVe
 * 2006/02/16	Kitagawa		VK쐬
 *-->
 */
public class PoiDynaMapDescribe {

	/** IuWFNgobt@ */
	private LinkedList objects = new LinkedList();

	/** _Mapobt@ */
	private LinkedList renders = new LinkedList();

	/**
	 * w肳ꂽBeanIuWFNgMapIuWFNgƂĒ񋟂܂B<br>
	 * @param bean BeanIuWFNg
	 * @return MapIuWFNg
	 * @throws PoiException MapIuWFNgƂĕϊłȂꍇɔ
	 */
	public Map describe(Object bean) throws PoiException {
		try {
			if (objects.contains(bean)) {
				return (Map) renders.get(objects.indexOf(bean));
			}

			Map map = PropertyUtils.describe(bean);
			map.remove("class");

			objects.add(bean);
			renders.add(map);

			return map;
		} catch (Exception e) {
			throw new PoiException("BeanMapIuWFNgɎs܂", e);
		}
	}

	/**
	 * w肳ꂽBeanIuWFNgzQƂĂIuWFNgǂ𔻒肵܂B<br>
	 * @param bean ΏBeanIuWFNg
	 * @return zQƂĂIuWFNg̏ꍇtrueԋp
	 */
	public boolean isCirculate(Object bean) {
		return objects.contains(bean) && !(bean instanceof PoiValue) && !(bean instanceof PoiDynaMap) && !(bean instanceof PoiDynaList);
	}
}
