package org.phosphoresce.commons.wpoi.adapter;

import java.io.Serializable;

import org.phosphoresce.commons.wpoi.exception.PoiException;

/**
 * Z͈͕ێNXB<br>
 * org.apache.poi.hssf.util.RegionNXPOIpbP[WKw
 * ɂׁAʓŕ݂B<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/11/21
 * 
 *<!--
 * XV       XV          XVe
 * 2005/11/21	Kitagawa		VK쐬
 *-->
 */
public final class PoiRange implements Serializable {

	/** sʒu(Jn) */
	private int rowFrom;

	/** Jʒu(Jn) */
	private short colFrom;

	/** sʒu(I) */
	private int rowTo;

	/** Jʒu(I) */
	private short colTo;

	/**
	 * RXgN^<br>
	 * č[̃ZI͈͂ƂăNX܂B<br>
	 */
	public PoiRange() {
		this.rowFrom = 0;
		this.colFrom = 0;
		this.rowTo = 0;
		this.colTo = 0;
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽPoiRangeIuWFNgƔ͈͂̃NXƂď܂B<br>
	 * @param range PoiRangeIuWFNg
	 * @exception PoiException tB[h̒lƂȂĂ܂ꍇɔ
	 */
	public PoiRange(PoiRange range) throws PoiException {
		this.rowFrom = range.rowFrom;
		this.colFrom = range.colFrom;
		this.rowTo = range.rowTo;
		this.colTo = range.colTo;
		validate();
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽ͈͂̃NXƂď܂B<br>
	 * @param rowFrom sʒu(Jn)
	 * @param colFrom Jʒu(Jn)
	 * @param rowTo sʒu(I)
	 * @param colTo Jʒu(I)
	 * @throws PoiException tB[h̒lƂȂĂ܂ꍇɔ
	 */
	public PoiRange(int rowFrom, short colFrom, int rowTo, short colTo) throws PoiException {
		this.rowFrom = rowFrom;
		this.colFrom = colFrom;
		this.rowTo = rowTo;
		this.colTo = colTo;
		validate();
	}

	/**
	 * ͈͈ʒu̐ANXIuWFNgLȌ`ɂ܂B<br>
	 * syуJ̊JnʒuIʒu傫ꍇɂ͕KIʒuJnʒu
	 * lȂ悤ɕ␳܂B<br>
	 * @exception PoiException tB[h̒lƂȂĂ܂ꍇɔ
	 */
	private void validate() throws PoiException {
		if (rowTo < rowFrom) {
			int buffer = rowTo;
			rowTo = rowFrom;
			rowFrom = buffer;
		}

		if (colTo < colFrom) {
			short buffer = colTo;
			colTo = colFrom;
			colFrom = buffer;
		}

		if (rowFrom < 0 || rowTo < 0 || colFrom < 0 || colTo < 0) {
			throw new PoiException("͈͏񂪕ƂȂĂ܂[" + toString() + "]");
		}
	}

	/**
	 * colFrom擾܂B<br>
	 * @return colFrom
	 */
	public short getColFrom() {
		return colFrom;
	}

	/**
	 * colFromݒ肵܂B<br>
	 * <b>ʒuݒ肵^C~OŐׂ̏sIʒuJnʒul
	 * Ȃ悤ɕ␳܂B</b><br>
	 * @param colFrom colFrom
	 * @throws PoiException tB[h̒lƂȂĂ܂ꍇɔ
	 */
	public void setColFrom(short colFrom) throws PoiException {
		this.colFrom = colFrom;
		validate();
	}

	/**
	 * colTo擾܂B<br>
	 * @return colTo
	 */
	public short getColTo() {
		return colTo;
	}

	/**
	 * colToݒ肵܂B<br>
	 * <b>ʒuݒ肵^C~OŐׂ̏sIʒuJnʒul
	 * Ȃ悤ɕ␳܂B</b><br>
	 * @param colTo colTo
	 * @throws PoiException tB[h̒lƂȂĂ܂ꍇɔ
	 */
	public void setColTo(short colTo) throws PoiException {
		this.colTo = colTo;
		validate();
	}

	/**
	 * rowFrom擾܂B<br>
	 * @return rowFrom
	 */
	public int getRowFrom() {
		return rowFrom;
	}

	/**
	 * rowFromݒ肵܂B<br>
	 * <b>ʒuݒ肵^C~OŐׂ̏sIʒuJnʒul
	 * Ȃ悤ɕ␳܂B</b><br>
	 * @param rowFrom rowFrom
	 * @throws PoiException tB[h̒lƂȂĂ܂ꍇɔ
	 */
	public void setRowFrom(int rowFrom) throws PoiException {
		this.rowFrom = rowFrom;
		validate();
	}

	/**
	 * rowTo擾܂B<br>
	 * @return rowTo
	 */
	public int getRowTo() {
		return rowTo;
	}

	/**
	 * rowToݒ肵܂B<br>
	 * <b>ʒuݒ肵^C~OŐׂ̏sIʒuJnʒul
	 * Ȃ悤ɕ␳܂B</b><br>
	 * @param rowTo rowTo
	 * @throws PoiException tB[h̒lƂȂĂ܂ꍇɔ
	 */
	public void setRowTo(int rowTo) throws PoiException {
		this.rowTo = rowTo;
		validate();
	}

	/**
	 * ͈͏̍擾܂(ŏl=1)B<br>
	 * @return ͈͏̍
	 */
	public int getHeight() {
		return rowTo - rowFrom + 1;
	}

	/**
	 * ͈͏̕擾܂(ŏl=1)B<br>
	 * @return ͈͏̕
	 */
	public short getWidth() {
		return (short) (colTo - colFrom + 1);
	}

	/**
	 * w肳ꂽsAJɃVtg͈͂̃Vtgs܂B<br>
	 * <b>ʒuݒ肵^C~OŐׂ̏sIʒuJnʒul
	 * Ȃ悤ɕ␳܂B</b><br>
	 * @param row sVtgl
	 * @param col JVtgl
	 * @throws PoiException tB[h̒lƂȂĂ܂ꍇɔ
	 */
	public void shift(int row, short col) throws PoiException {
		colFrom += col;
		colTo += col;
		rowFrom += row;
		rowTo += row;
		validate();
	}

	/**
	 * NX𕶎Ŏ擾܂B<br>
	 * @return NX
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();

		buffer.append("{");
		buffer.append("rowFrom=");
		buffer.append(getRowFrom());
		buffer.append(",");
		buffer.append("colFrom=");
		buffer.append(Double.toString(getColFrom()));
		buffer.append(",");
		buffer.append("rowTo=");
		buffer.append(getRowTo());
		buffer.append(",");
		buffer.append("colTo=");
		buffer.append(Short.toString(getColTo()));
		buffer.append("}");

		return buffer.toString();
	}
}
