package org.phosphoresce.commons.wpoi.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.phosphoresce.commons.wpoi.exception.PoiException;

/**
 * POIZNXB<br>
 * org.apache.poi.hssf.usermodel.HSSFCell̐ƎȃC^tF[XyсA
 * sێA񋟂邱ƂړIƂNXB<br>
 * HSSFCellɑ΂SĂ̐C^tF[X͎ȂׁAg
 * HSSFCellIuWFNg̎擾\bh͓NXɎB<br>
 * NX̃CX^XPoiSheet񋟂̂
 * [UӐ}IɃCX^X𐶐邱Ƃ͑z肵ȂB<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/11/21
 * 
 *<!--
 * XV       XV          XVe
 * 2005/11/21	Kitagawa		VK쐬
 * 2006/02/09	Kitagawa		setValueɂnullIuWFNg𔻒肵ċ󕶎悤ɏC
 * 2006/03/24	Kitagawa		setValue̕ݒ莞ɐlɕϊł镶͐lƂăZbg悤ɏC(Exceldl)
 * 2006/04/19	Kitagawa		getForceStringValuẽC^tF[XƂČvZ̒l擾ׂ̃p^\bhǉ
 *-->
 */
public final class PoiCell {

	/** MOIuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** PoiWorkbookIuWFNgCX^X */
	private PoiWorkbook pWorkbook;

	/** PoiSheetIuWFNgCX^X */
	private PoiSheet pSheet;

	/** PoiRowIuWFNgCX^X */
	private PoiRow pRow;

	/** gHSSFCellIuWFNg */
	private HSSFCell hssfCell;

	/**
	 * RXgN^<br>
	 */
	private PoiCell() {
		//
	}

	/**
	 * RXgN^<br>
	 * @param pWorkbook PoiWorkbookIuWFNg
	 * @param pSheet PoiSheetIuWFNg
	 * @param pRow PoiRowIuWFNg
	 * @param hssfCell HSSFCellIuWFNg
	 */
	protected PoiCell(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiRow pRow, HSSFCell hssfCell) {
		this.pWorkbook = pWorkbook;
		this.pSheet = pSheet;
		this.pRow = pRow;
		this.hssfCell = hssfCell;
	}

	/**
	 * gHSSFCellIuWFNg擾܂B<br>
	 * @return HSSFCellIuWFNg
	 */
	protected HSSFCell getHssfCell() {
		return hssfCell;
	}

	/**
	 * g̃Z̍sʒu擾܂B<br>
	 * eV[gIuWFNg玩g̃ZłĂꍇA
	 * ܂̓Znull̏ꍇɂ͕ԋp܂B<br>
	 * @return g̃Z̍sʒu
	 */
	public int getRowNum() throws PoiException {
		if (hssfCell == null) {
			return -1;
		}

		for (int i = 0; i <= pSheet.getLastRowNum(); i++) {
			for (short j = 0; j <= pSheet.getLastColNum(); j++) {
				if (hssfCell.equals(pSheet.getPoiCell(i, j, true).getHssfCell())) {
					return i;
				}
			}
		}

		return -1;
	}

	/**
	 * g̃Z̃Jʒu擾܂B<br>
	 * eV[gIuWFNg玩g̃ZłĂꍇA
	 * ܂̓Znull̏ꍇɂ͕ԋp܂B<br>
	 * @return g̃Z̃Jʒu
	 */
	public short getColNum() throws PoiException {
		if (hssfCell == null) {
			return -1;
		}

		for (int i = 0; i <= pSheet.getLastRowNum(); i++) {
			for (short j = 0; j <= pSheet.getLastColNum(); j++) {
				if (hssfCell.equals(pSheet.getPoiCell(i, j, true).getHssfCell())) {
					return j;
				}
			}
		}

		return -1;
	}

	/**
	 * w肳ꂽPoiValue̒lZɐݒ肵܂B<br>
	 * @param value PoiValueIuWFNg
	 * @throws PoiException PoiValuelݒłȂꍇɔ
	 */
	public void setValue(PoiValue value) throws PoiException {
		if (hssfCell == null) {
			return;
		}

		// ZGR[h{ɑΉ
		hssfCell.setEncoding(HSSFCell.ENCODING_UTF_16);

		// l^CvɃZ̐ݒ菈s
		if (value.isNullValue()) {
			hssfCell.setCellValue("");
			log.trace("Zlݒ          : null");
		} else if (value.isBoolean()) {
			hssfCell.setCellValue(value.getBooleanValue());
			log.trace("Zlݒ(Boolean) : " + value.getBooleanValue());
		} else if (value.isDate()) {
			hssfCell.setCellValue(value.getDateValue());
			log.trace("Zlݒ(Date)    : " + value.getDateValue());
		} else if (value.isNumeric()) {
			hssfCell.setCellValue(value.getNumericValue());
			log.trace("Zlݒ(Numeric) : " + value.getNumericValue());
		} else if (value.isString()) {
			if (value.isNumericalStringValue()) {
				hssfCell.setCellValue(Long.parseLong(value.getStringValue()));
				log.trace("Zlݒ(String)  : " + value.getStringValue() + " [lƂăZbg܂]");
			} else {
				hssfCell.setCellValue(value.getStringValue());
				log.trace("Zlݒ(String)  : " + value.getStringValue());
			}
		}
	}

	/**
	 * Z̒lIɕƂĎ擾܂B<br>
	 * ZɎw肳Ăꍇ͌vZ̒lł͂Ȃ̒l擾܂B<br>
	 * @return IɕƂZ̒l
	 */
	public String getForceStringValue() {
		return getForceStringValue(false);
	}

	/**
	 * Z̒lIɕƂĎ擾܂B<br>
	 * @param forceCalc vZ̒l擾ꍇtruew
	 * @return IɕƂZ̒l
	 */
	public String getForceStringValue(boolean forceCalc) {
		if (hssfCell == null) {
			return "";
		} else if (hssfCell.getCellType() == HSSFCell.CELL_TYPE_BLANK) {
			return "";
		} else if (hssfCell.getCellType() == HSSFCell.CELL_TYPE_BOOLEAN) {
			return String.valueOf(hssfCell.getBooleanCellValue());
		} else if (hssfCell.getCellType() == HSSFCell.CELL_TYPE_ERROR) {
			return Byte.toString(hssfCell.getErrorCellValue());
		} else if (!forceCalc && hssfCell.getCellType() == HSSFCell.CELL_TYPE_FORMULA) {
			return String.valueOf(hssfCell.getCellFormula());
		} else if (forceCalc && hssfCell.getCellType() == HSSFCell.CELL_TYPE_FORMULA) {
			return "NaN".equals(renderIntOrDblValue(hssfCell.getNumericCellValue())) ? "" : renderIntOrDblValue(hssfCell.getNumericCellValue());
		} else if (hssfCell.getCellType() == HSSFCell.CELL_TYPE_NUMERIC) {
			return "NaN".equals(renderIntOrDblValue(hssfCell.getNumericCellValue())) ? "" : renderIntOrDblValue(hssfCell.getNumericCellValue());
		} else if (hssfCell.getCellType() == HSSFCell.CELL_TYPE_STRING) {
			return String.valueOf(hssfCell.getStringCellValue());
		} else {
			return "";
		}
	}

	/**
	 * w肳ꂽdoublel_ȉ̒lȂꍇ͐lƂĂStringIuWFNgԋpB<br>
	 * @param value doublel
	 * @return lStringIuWFNgƂ
	 */
	private String renderIntOrDblValue(double value) {
		try {
			String dBuf = String.valueOf(value);
			String iBuf = String.valueOf(new Double(value).intValue());
			return Double.parseDouble(dBuf) == Double.parseDouble(iBuf) ? iBuf : dBuf;
		} catch (Exception e) {
			return "NaN";
		}
	}
}
