/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.wpoi.adapter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.phosphoresce.commons.wpoi.adapter.PoiSheet;
import org.phosphoresce.commons.wpoi.exception.PoiIOException;

public final class PoiWorkbook {
    private Log log = LogFactory.getLog(this.getClass());
    private HSSFWorkbook hssfWorkbook;

    public PoiWorkbook() {
        this.hssfWorkbook = new HSSFWorkbook();
        this.log.trace((Object)"******** \u30ef\u30fc\u30af\u30d6\u30c3\u30af\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u751f\u6210\u3057\u307e\u3057\u305f[\u65b0\u898f\u4f5c\u6210]");
    }

    public PoiWorkbook(HSSFWorkbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
        this.log.trace((Object)("******** \u30ef\u30fc\u30af\u30d6\u30c3\u30af\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u751f\u6210\u3057\u307e\u3057\u305f[" + hssfWorkbook + "]"));
    }

    public PoiWorkbook(String path) throws PoiIOException {
        try {
            this.hssfWorkbook = new HSSFWorkbook(new POIFSFileSystem((InputStream)new FileInputStream(new File(path))));
            this.log.trace((Object)("******** \u30ef\u30fc\u30af\u30d6\u30c3\u30af\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u751f\u6210\u3057\u307e\u3057\u305f[" + path + "]"));
        }
        catch (FileNotFoundException e) {
            throw new PoiIOException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb[" + path + "]\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u304b\u3001\u4ed6\u306e\u30d7\u30ed\u30bb\u30b9\u3067\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u307e\u3059", e);
        }
        catch (IOException e) {
            throw new PoiIOException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb[" + path + "]\u3092\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    protected HSSFWorkbook getHssfWorkbook() {
        return this.hssfWorkbook;
    }

    public PoiSheet getPoiSheet(int index) {
        return new PoiSheet(this, this.hssfWorkbook.getSheetAt(index));
    }

    public int getNumberOfSheets() {
        return this.hssfWorkbook.getNumberOfSheets();
    }

    public void setSelectedSheet(int index) {
        for (int i = 0; i <= this.hssfWorkbook.getNumberOfSheets() - 1; ++i) {
            this.hssfWorkbook.getSheetAt(i).setSelected(false);
        }
        this.hssfWorkbook.getSheetAt(index).setSelected(true);
    }

    public void save(String path) throws PoiIOException {
        try {
            FileOutputStream os = new FileOutputStream(new File(path));
            this.save(os);
            os.close();
        }
        catch (FileNotFoundException e) {
            throw new PoiIOException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb[" + path + "]\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u304b\u3001\u4ed6\u306e\u30d7\u30ed\u30bb\u30b9\u3067\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u307e\u3059", e);
        }
        catch (IOException e) {
            throw new PoiIOException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb[" + path + "]\u4fdd\u5b58\u6642\u306b\u5165\u51fa\u529b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    public void save(OutputStream os) throws PoiIOException {
        try {
            this.hssfWorkbook.write(os);
        }
        catch (IOException e) {
            throw new PoiIOException("\u6307\u5b9a\u3055\u308c\u305fOutputStream\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u5bfe\u3057\u3066\u51fa\u529b\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }
}

