/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.wpoi.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.Region;
import org.phosphoresce.commons.wpoi.adapter.PoiCell;
import org.phosphoresce.commons.wpoi.adapter.PoiRange;
import org.phosphoresce.commons.wpoi.adapter.PoiRow;
import org.phosphoresce.commons.wpoi.adapter.PoiUtil;
import org.phosphoresce.commons.wpoi.adapter.PoiWorkbook;
import org.phosphoresce.commons.wpoi.exception.PoiException;
import org.phosphoresce.commons.wpoi.util.PoiPrintConfig;

public final class PoiSheet {
    private Log log = LogFactory.getLog(this.getClass());
    private PoiWorkbook pWorkbook;
    private HSSFSheet hssfSheet;

    private PoiSheet() {
    }

    protected PoiSheet(PoiWorkbook pWorkbook, HSSFSheet hssfSheet) {
        this.pWorkbook = pWorkbook;
        this.hssfSheet = hssfSheet;
        this.hssfSheet.createRow(hssfSheet.getLastRowNum() + 1);
        this.log.trace((Object)("******** \u30b7\u30fc\u30c8\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u751f\u6210\u3057\u307e\u3057\u305f[" + this.getSheetName() + "]"));
    }

    protected HSSFSheet getHssfSheet() {
        return this.hssfSheet;
    }

    public void applyPrintConfig(PoiPrintConfig config) {
        double MARGIN_COEFFICIENT = 2.5;
        this.hssfSheet.setAutobreaks(config.isAutobreaks());
        this.hssfSheet.setHorizontallyCenter(config.isHorizontallyCenter());
        this.hssfSheet.setVerticallyCenter(config.isVerticallyCenter());
        this.hssfSheet.setMargin((short)2, config.getMarginOfTop() / 2.5);
        this.hssfSheet.setMargin((short)3, config.getMarginOfBottom() / 2.5);
        this.hssfSheet.setMargin((short)0, config.getMarginOfLeft() / 2.5);
        this.hssfSheet.setMargin((short)1, config.getMarginOfRight() / 2.5);
        this.hssfSheet.getHeader().setLeft(config.getHeaderLeftString());
        this.hssfSheet.getHeader().setCenter(config.getHeaderCenterString());
        this.hssfSheet.getHeader().setRight(config.getHeaderRightString());
        this.hssfSheet.getFooter().setLeft(config.getFooterLeftString());
        this.hssfSheet.getFooter().setCenter(config.getFooterCenterString());
        this.hssfSheet.getFooter().setRight(config.getFooterRightString());
        this.hssfSheet.getPrintSetup().setHeaderMargin(config.getMarginOfHeader() / 2.5);
        this.hssfSheet.getPrintSetup().setFooterMargin(config.getMarginOfFooter() / 2.5);
        this.hssfSheet.getPrintSetup().setFitHeight(config.getFitPageVerticalCount());
        this.hssfSheet.getPrintSetup().setFitWidth(config.getFitPageHorizontalCount());
        this.hssfSheet.getPrintSetup().setLandscape(config.isLandscape());
        this.hssfSheet.getPrintSetup().setScale(config.getScale());
        this.hssfSheet.getPrintSetup().setCopies(config.getCopies());
        this.hssfSheet.getPrintSetup().setDraft(config.isDraft());
        this.hssfSheet.getPrintSetup().setHResolution(config.getDpi());
        this.hssfSheet.getPrintSetup().setVResolution(config.getDpi());
        this.hssfSheet.getPrintSetup().setLeftToRight(config.isPrintTopToDown());
        this.hssfSheet.getPrintSetup().setNoColor(config.isMonoPrint());
        this.hssfSheet.getPrintSetup().setNotes(config.isPrintComment());
        this.hssfSheet.getPrintSetup().setPageStart(config.getStartPage());
        this.hssfSheet.getPrintSetup().setPaperSize(config.getPaperSize());
    }

    public void setSheetName(String name) {
        for (int i = 0; i <= this.pWorkbook.getHssfWorkbook().getNumberOfSheets(); ++i) {
            if (!this.pWorkbook.getHssfWorkbook().getSheetAt(i).equals(this.hssfSheet)) continue;
            this.pWorkbook.getHssfWorkbook().setSheetName(i, name, (short)1);
            break;
        }
    }

    public String getSheetName() {
        for (int i = 0; i <= this.pWorkbook.getHssfWorkbook().getNumberOfSheets(); ++i) {
            if (!this.pWorkbook.getHssfWorkbook().getSheetAt(i).equals(this.hssfSheet)) continue;
            return this.pWorkbook.getHssfWorkbook().getSheetName(i);
        }
        return null;
    }

    public int getLastRowNum() {
        return this.hssfSheet.getLastRowNum();
    }

    public short getLastColNum() {
        short col = 0;
        for (int i = 0; i <= this.getLastRowNum(); ++i) {
            HSSFRow row = this.hssfSheet.getRow(i);
            if (row == null || col >= row.getLastCellNum()) continue;
            col = row.getLastCellNum();
        }
        return col;
    }

    public PoiRow getPoiRow(int row, boolean fourceInstance) {
        if (this.hssfSheet == null) {
            return null;
        }
        if (this.hssfSheet.getRow(row) == null) {
            if (fourceInstance) {
                return new PoiRow(this.pWorkbook, this, this.hssfSheet.createRow(row));
            }
            return null;
        }
        return new PoiRow(this.pWorkbook, this, this.hssfSheet.getRow(row));
    }

    public PoiRow getPoiRow(int row) {
        return this.getPoiRow(row, false);
    }

    public PoiCell getPoiCell(int row, short col, boolean fourceInstance) {
        if (fourceInstance) {
            PoiRow pRow = this.getPoiRow(row, true);
            PoiCell pCell = pRow.getPoiCell(col, true);
            return pCell;
        }
        PoiRow pRow = this.getPoiRow(row, false);
        PoiCell pCell = pRow.getPoiCell(col, false);
        return pCell;
    }

    public PoiCell getPoiCell(int row, short col) {
        return this.getPoiCell(row, col, false);
    }

    public void copyPaste(PoiRange fromRange, int row, short col) throws PoiException {
        int i;
        Region[] regions = PoiUtil.getMargedRegions(this.hssfSheet, fromRange);
        PoiRange toRange = new PoiRange(fromRange);
        int shiftRow = row - fromRange.getRowFrom();
        short shiftCol = (short)(col - fromRange.getColFrom());
        toRange.shift(shiftRow, shiftCol);
        PoiUtil.clearMargedRegions(this.hssfSheet, toRange);
        for (i = 0; i <= regions.length - 1; ++i) {
            Region region = new Region();
            region.setRowFrom(regions[i].getRowFrom() + shiftRow);
            region.setRowTo(regions[i].getRowTo() + shiftRow);
            region.setColumnFrom((short)(regions[i].getColumnFrom() + shiftCol));
            region.setColumnTo((short)(regions[i].getColumnTo() + shiftCol));
            this.hssfSheet.addMergedRegion(region);
        }
        for (i = fromRange.getRowFrom(); i <= fromRange.getRowTo(); ++i) {
            HSSFRow rowFrom = this.hssfSheet.getRow(i);
            HSSFRow rowTo = this.hssfSheet.getRow(i + shiftRow);
            PoiUtil.copyRow(rowFrom, rowTo);
        }
    }

    public void insertRow(int row) {
        this.hssfSheet.shiftRows(row, this.hssfSheet.getLastRowNum(), 1, true, true);
        this.hssfSheet.createRow(row);
    }

    public void deleteRow(int row) {
        if (this.hssfSheet.getRow(row) != null) {
            this.hssfSheet.removeRow(this.hssfSheet.getRow(row));
        }
        for (int i = 0; i <= this.hssfSheet.getNumMergedRegions() - 1; ++i) {
            Region region = this.hssfSheet.getMergedRegionAt(i);
            if (region.getRowFrom() == row && row == region.getRowTo()) {
                this.hssfSheet.removeMergedRegion(i);
                i = 0;
                continue;
            }
            if (row < region.getRowFrom() || region.getRowTo() < row) continue;
            this.hssfSheet.removeMergedRegion(i);
            region.setRowTo(region.getRowTo() - 1);
            this.hssfSheet.addMergedRegion(region);
            i = 0;
        }
        this.hssfSheet.shiftRows(row + 1, this.hssfSheet.getLastRowNum(), -1, true, true);
    }
}

