package org.phosphoresce.dbbrowser.gui.window.main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EMenu;
import org.phosphoresce.commons.eswing.EMenuBar;
import org.phosphoresce.commons.eswing.EMenuItem;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.dbbrowser.DatabaseBrowser;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.window.ConnectionConfigureFrame;
import org.phosphoresce.dbbrowser.gui.window.about.AboutDialog;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

/**
 * DatabaseBorwserAvP[Vj[o[NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/27	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserMenuBar extends EMenuBar implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static DatabaseBrowserMenuBar instance = null;

	/** uEUj[(File) */
	private EMenu browserMenuFile = null;

	/** uEUj[(View) */
	private EMenu browserMenuView = null;

	/** uEUj[(Help) */
	private EMenu browserMenuHelp = null;

	/** uEUj[ACe(About) */
	private EMenuItem browserMenuItemAbout = null;

	/** uEUj[ACe(NewConnection) */
	private EMenuItem browserMenuItemNewConnection = null;

	/** uEUj[ACe(Exit) */
	private EMenuItem browserMenuItemExit = null;

	/** uEUj[ACe(ClientInformationView) */
	private EMenuItem browserMenuItemClientInformationView = null;

	/** uEUj[ACe(DatabaseInformationView) */
	private EMenuItem browserMenuItemDatabaseInformationView = null;

	/** uEUj[ACe(QueryManagerView) */
	private EMenuItem browserMenuItemQueryManagerView = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowserMenuBar() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static DatabaseBrowserMenuBar instance() {
		if (instance == null) {
			instance = new DatabaseBrowserMenuBar();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.add(getBrowserMenuFile());
		this.add(getBrowserMenuView());
		this.add(getBrowserMenuHelp());
	}

	// Menu Components

	/**
	 * uEUj[(File)擾܂B<br>
	 * @return uEUj[(File)
	 */
	private EMenu getBrowserMenuFile() {
		if (browserMenuFile == null) {
			browserMenuFile = new EMenu("File");
			browserMenuFile.setMnemonic('F');
			browserMenuFile.add(getBrowserMenuItemNewConnection());
			browserMenuFile.addSeparator();
			browserMenuFile.add(getBrowserMenuItemExit());
		}
		return browserMenuFile;
	}

	/**
	 * uEUj[(Window)擾܂B<br>
	 * @return uEUj[(Window)
	 */
	private EMenu getBrowserMenuView() {
		if (browserMenuView == null) {
			browserMenuView = new EMenu("View");
			browserMenuView.setMnemonic('V');
			browserMenuView.add(getBrowserMenuItemClientInformationView());
			browserMenuView.add(getBrowserMenuItemDatabaseInformationView());
			browserMenuView.add(getBrowserMenuItemQueryManagerView());
		}
		return browserMenuView;
	}

	/**
	 * uEUj[(Help)擾܂B<br>
	 * @return uEUj[(Help)
	 */
	private EMenu getBrowserMenuHelp() {
		if (browserMenuHelp == null) {
			browserMenuHelp = new EMenu("Help");
			browserMenuHelp.setMnemonic('H');
			browserMenuHelp.add(getBrowserMenuItemAbout());
		}
		return browserMenuHelp;
	}

	// Menu Item Components

	/**
	 * uEUj[ACe(About)擾܂B<br>
	 * @return uEUj[ACe(About)
	 */
	private EMenuItem getBrowserMenuItemAbout() {
		if (browserMenuItemAbout == null) {
			browserMenuItemAbout = new EMenuItem("About...");
			browserMenuItemAbout.setMnemonic('A');
			browserMenuItemAbout.setIconTextGap(5);
			browserMenuItemAbout.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_APP_ICON_20));
			browserMenuItemAbout.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						AboutDialog.showAboutDialog();
					} catch (Throwable throwable) {
						String errorMessage = "failed to show about dialog.";
						log.error(errorMessage, throwable);
						EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
					}
				}
			});
		}
		return browserMenuItemAbout;
	}

	/**
	 * uEUj[ACe(NewConnection)擾܂B<br>
	 * @return uEUj[ACe(NewConnection)
	 */
	private EMenuItem getBrowserMenuItemNewConnection() {
		if (browserMenuItemNewConnection == null) {
			browserMenuItemNewConnection = new EMenuItem("New Connection...");
			browserMenuItemNewConnection.setIconTextGap(5);
			browserMenuItemNewConnection.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_SPACER_20));
			browserMenuItemNewConnection.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						new ConnectionConfigureFrame(DatabaseBrowserSession.instance().getBrowserFrame(), DatabaseBrowserSession.instance()).setVisible(true);
						DatabaseBrowserFrame.instance().refresh();
					} catch (Throwable throwable) {
						String errorMessage = "failed to connect new database instance.";
						log.error(errorMessage, throwable);
						EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
					}
				}
			});
		}
		return browserMenuItemNewConnection;
	}

	/**
	 * uEUj[ACe(Exit)擾܂B<br>
	 * @return uEUj[ACe(Exit)
	 */
	private EMenuItem getBrowserMenuItemExit() {
		if (browserMenuItemExit == null) {
			browserMenuItemExit = new EMenuItem("Exit");
			browserMenuItemExit.setMnemonic('X');
			browserMenuItemExit.setIconTextGap(5);
			browserMenuItemExit.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_SPACER_20));
			browserMenuItemExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					DatabaseBrowser.exit();
				}
			});
		}
		return browserMenuItemExit;
	}

	/**
	 * uEUj[ACe(ClientInformationView)擾܂B<br>
	 * @return uEUj[ACe(ClientInformationView)
	 */
	private EMenuItem getBrowserMenuItemClientInformationView() {
		if (browserMenuItemClientInformationView == null) {
			browserMenuItemClientInformationView = new EMenuItem("ClientInformationView");
			browserMenuItemClientInformationView.setMnemonic('C');
			browserMenuItemClientInformationView.setIconTextGap(5);
			browserMenuItemClientInformationView.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CLIENTPC_20));
			browserMenuItemClientInformationView.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					DatabaseBrowserTabbedPane.instance().setSelectedIndex(0);
				}
			});
		}
		return browserMenuItemClientInformationView;
	}

	/**
	 * uEUj[ACe(DatabaseInformationView)擾܂B<br>
	 * @return uEUj[ACe(DatabaseInformationView)
	 */
	private EMenuItem getBrowserMenuItemDatabaseInformationView() {
		if (browserMenuItemDatabaseInformationView == null) {
			browserMenuItemDatabaseInformationView = new EMenuItem("DatabaseInformationView");
			browserMenuItemDatabaseInformationView.setMnemonic('D');
			browserMenuItemDatabaseInformationView.setIconTextGap(5);
			browserMenuItemDatabaseInformationView.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATABASE_20));
			browserMenuItemDatabaseInformationView.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					DatabaseBrowserTabbedPane.instance().setSelectedIndex(1);
				}
			});
		}
		return browserMenuItemDatabaseInformationView;
	}

	/**
	 * uEUj[ACe(QueryManagerView)擾܂B<br>
	 * @return uEUj[ACe(QueryManagerView)
	 */
	private EMenuItem getBrowserMenuItemQueryManagerView() {
		if (browserMenuItemQueryManagerView == null) {
			browserMenuItemQueryManagerView = new EMenuItem("QueryManagerView");
			browserMenuItemQueryManagerView.setMnemonic('Q');
			browserMenuItemQueryManagerView.setIconTextGap(5);
			browserMenuItemQueryManagerView.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_QUERY_20));
			browserMenuItemQueryManagerView.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					DatabaseBrowserTabbedPane.instance().setSelectedIndex(2);
				}
			});
		}
		return browserMenuItemQueryManagerView;
	}
}
