/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.phosphoresce.commons.database.accessor.ResultAccessorAbstract;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public final class ResultColumnDefinition
extends ResultAccessorAbstract {
    private int index;
    private String catalog;
    private String schema;
    private String table;
    private Class clazz;
    private String typeName;
    private String label;
    private String name;
    private int displaySize;
    private int type;
    private int precision;
    private int scale;

    ResultColumnDefinition(ResultSet resultSet, int index) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        super(resultSet, ResultAccessorState.STATIC, null);
        this.index = index;
        this.refreshResult();
    }

    protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        int currentRow = this.getResultSetRowIndex();
        try {
            ResultSetMetaData metadata = this.resultSet.getMetaData();
            this.catalog = metadata.getCatalogName(this.index + 1);
            this.clazz = Class.forName(metadata.getColumnClassName(this.index + 1));
            this.label = metadata.getColumnLabel(this.index + 1);
            this.name = metadata.getColumnName(this.index + 1);
            this.typeName = metadata.getColumnTypeName(this.index + 1);
            this.schema = metadata.getSchemaName(this.index + 1);
            this.table = metadata.getTableName(this.index + 1);
            this.displaySize = metadata.getColumnDisplaySize(this.index + 1);
            this.type = metadata.getColumnType(this.index + 1);
            this.precision = metadata.getPrecision(this.index + 1);
            this.scale = metadata.getScale(this.index + 1);
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to refresh result.", e);
        }
        catch (ClassNotFoundException e) {
            throw new ResultSetAccessException("failed to refresh result.", e);
        }
        finally {
            this.moveCurser(currentRow);
        }
    }

    protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
    }

    public int getIndex() {
        return this.index;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Class getColumnClass() {
        return this.clazz;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("catalog=").append(this.catalog);
        buffer.append(", ");
        buffer.append("schema=").append(this.schema);
        buffer.append(", ");
        buffer.append("table=").append(this.table);
        buffer.append(", ");
        buffer.append("class=").append(this.clazz.getName());
        buffer.append(", ");
        buffer.append("typeName=").append(this.typeName);
        buffer.append(", ");
        buffer.append("label=").append(this.label);
        buffer.append(", ");
        buffer.append("name=").append(this.name);
        buffer.append(", ");
        buffer.append("displaySize=").append(this.displaySize);
        buffer.append(", ");
        buffer.append("type=").append(this.type);
        buffer.append(", ");
        buffer.append("precision=").append(this.precision);
        buffer.append(", ");
        buffer.append("scale=").append(this.scale);
        buffer.append("}");
        return buffer.toString();
    }
}

