/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.resource.definition.dbdriver;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.dbbrowser.resource.definition.dbdriver.DatabaseBrowserJDBCSampleDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

final class DatabaseBrowserJDBCSampleContentHandler
implements ContentHandler {
    private Log log = LogFactory.getLog(this.getClass());
    public static final String NODE_NAME_DEFINITION = "definition";
    public static final String NODE_ATTR_DEFINITION_NAME = "name";
    public static final String NODE_NAME_DRIVER = "driver";
    public static final String NODE_NAME_SAMPLE_ADDRESS = "sample-address";
    private DatabaseBrowserJDBCSampleDefinition definition = null;
    private List definitionList = new LinkedList();
    private StringBuffer buffer = new StringBuffer();
    private boolean parsing = false;
    private boolean parseInDefinition = false;

    public List getDefinitionList() {
        return this.definitionList;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.log.info((Object)"Start parse sample JDBC definition resource.");
        this.parsing = true;
    }

    public void endDocument() throws SAXException {
        this.log.info((Object)"Parsed sample JDBC definition resource.");
        this.parsing = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (NODE_NAME_DEFINITION.equals(localName)) {
            if (this.parseInDefinition) {
                throw new SAXException("not found 'definition' node end tag.");
            }
            this.parseInDefinition = true;
            this.definition = new DatabaseBrowserJDBCSampleDefinition();
            this.definition.setName(atts.getValue(NODE_ATTR_DEFINITION_NAME));
        } else if (NODE_NAME_DRIVER.equals(localName)) {
            if (!this.parseInDefinition) {
                throw new SAXException("not found 'definition' start end tag.");
            }
            this.buffer = new StringBuffer();
        } else if (NODE_NAME_SAMPLE_ADDRESS.equals(localName)) {
            if (!this.parseInDefinition) {
                throw new SAXException("not found 'definition' start end tag.");
            }
            this.buffer = new StringBuffer();
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (NODE_NAME_DEFINITION.equals(localName)) {
            if (!this.parseInDefinition) {
                throw new SAXException("not found 'definition' node start tag.");
            }
            this.parseInDefinition = false;
            this.definitionList.add(this.definition);
            this.log.debug((Object)("loaded JDBC sample definition : " + this.definition));
        } else if (NODE_NAME_DRIVER.equals(localName)) {
            this.definition.setDriver(this.buffer.toString());
        } else if (NODE_NAME_SAMPLE_ADDRESS.equals(localName)) {
            this.definition.setSampleUrl(this.buffer.toString());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }
}

