/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.window.main;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.ETabbedPane;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.panel.dbinformation.DatabaseInformationPanel;
import org.phosphoresce.dbbrowser.gui.panel.pcinformation.ClientPCInformationPanel;
import org.phosphoresce.dbbrowser.gui.panel.querymanage.QueryManagePanel;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

public final class DatabaseBrowserTabbedPane
extends ETabbedPane
implements RefreshableComponent {
    private Log log = LogFactory.getLog(this.getClass());
    private static DatabaseBrowserTabbedPane instance = null;

    private DatabaseBrowserTabbedPane() {
        this.initialize();
    }

    public static DatabaseBrowserTabbedPane instance() {
        if (instance == null) {
            instance = new DatabaseBrowserTabbedPane();
        }
        return instance;
    }

    public void refresh() throws Throwable {
        for (int i = 0; i <= this.getTabCount() - 1; ++i) {
            Component component = this.getComponentAt(i);
            if (!(component instanceof RefreshableComponent)) continue;
            ((RefreshableComponent)((Object)component)).refresh();
        }
    }

    private void initialize() {
        this.addTab("Client Information", new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CLIENTPC_20), (Component)((Object)ClientPCInformationPanel.instance()), "Client PC Information");
        this.addTab("Database Information", new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATABASE_20), (Component)((Object)DatabaseInformationPanel.instance()), "Database Information");
        this.addTab("Query Manager", new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_QUERY_20), (Component)((Object)QueryManagePanel.instance()), "Query Manager");
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (DatabaseBrowserTabbedPane.this.getSelectedComponent() instanceof RefreshableComponent) {
                    try {
                        ((RefreshableComponent)((Object)DatabaseBrowserTabbedPane.this.getSelectedComponent())).refresh();
                    }
                    catch (Throwable throwable) {
                        String errorMessage = "failed to refresh browser panel.";
                        DatabaseBrowserTabbedPane.this.log.error((Object)errorMessage, throwable);
                        EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
                    }
                }
            }
        });
        try {
            ClientPCInformationPanel.instance().refresh();
        }
        catch (Throwable throwable) {
            String errorMessage = "failed to refresh client pc information panel.";
            this.log.error((Object)errorMessage, throwable);
            EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
        }
    }
}

