/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.util.ObjectUtil;
import org.phosphoresce.dbbrowser.exception.BrowserConfigException;

public final class DatabaseBrowserConfig
implements Serializable {
    private static final long serialVersionUID = 4013287882658631214L;
    private static transient Log log = LogFactory.getLog((Class)DatabaseBrowserConfig.class);
    private static transient DatabaseBrowserConfig instance = null;
    private DatabaseConfig recentDatabaseConfig = null;
    private List databaseConfigDefinitionList = null;
    private List databaseConfigDefinitionNameList = null;

    private DatabaseBrowserConfig() {
    }

    public static DatabaseBrowserConfig instance() {
        if (instance == null) {
            instance = new DatabaseBrowserConfig();
        }
        return instance;
    }

    public static void save() throws BrowserConfigException {
        try {
            ObjectUtil.saveSerializableObject((Serializable)instance, (String)"dbbrowser-connection.cfg");
        }
        catch (Throwable e) {
            throw new BrowserConfigException("failed to save config file.", e);
        }
    }

    public static void load() throws BrowserConfigException {
        try {
            instance = new File("dbbrowser-connection.cfg").exists() ? (DatabaseBrowserConfig)ObjectUtil.loadSerializableObject((String)"dbbrowser-connection.cfg") : null;
        }
        catch (Throwable e) {
            log.warn((Object)"failed to load config.", e);
        }
    }

    private List getDatabaseConfigDefinitionNameList() {
        if (this.databaseConfigDefinitionNameList == null) {
            this.databaseConfigDefinitionNameList = new LinkedList();
        }
        return this.databaseConfigDefinitionNameList;
    }

    private List getDatabaseConfigDefinitionList() {
        if (this.databaseConfigDefinitionList == null) {
            this.databaseConfigDefinitionList = new LinkedList();
        }
        return this.databaseConfigDefinitionList;
    }

    public DatabaseConfig getRecentDatabaseConfig() {
        if (this.recentDatabaseConfig == null) {
            this.recentDatabaseConfig = new DatabaseConfig();
        }
        return this.recentDatabaseConfig;
    }

    public void setRecentDatabaseConfig(DatabaseConfig recentDatabaseConfig) {
        this.recentDatabaseConfig = recentDatabaseConfig;
    }

    public int getDatabaseConfigDefinitionCount() {
        return this.getDatabaseConfigDefinitionList().size();
    }

    public boolean containsDatabaseConfigDefinitionName(String name) {
        return this.getDatabaseConfigDefinitionNameList().contains(name);
    }

    public int getDatabaseConfigDefinitionIndex(String name) {
        return this.getDatabaseConfigDefinitionNameList().indexOf(name);
    }

    public String getDatabaseConfigDefinitionName(int index) {
        if (index < 0 || index > this.getDatabaseConfigDefinitionNameList().size() - 1) {
            return "";
        }
        return (String)this.getDatabaseConfigDefinitionNameList().get(index);
    }

    public DatabaseConfig getDatabaseConfigDefinition(int index) {
        if (index < 0 || index > this.getDatabaseConfigDefinitionList().size() - 1) {
            return new DatabaseConfig();
        }
        return (DatabaseConfig)this.getDatabaseConfigDefinitionList().get(index);
    }

    public void setDatabaseConfigDefinition(int index, String name, DatabaseConfig config) {
        if (index < 0 || index > this.getDatabaseConfigDefinitionList().size() - 1) {
            this.getDatabaseConfigDefinitionNameList().add(name);
            this.getDatabaseConfigDefinitionList().add(config);
        } else {
            this.getDatabaseConfigDefinitionNameList().set(index, name);
            this.getDatabaseConfigDefinitionList().set(index, config);
        }
    }
}

