package org.phosphoresce.commons.eswing;

import java.util.Vector;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

import org.phosphoresce.commons.eswing.core.ESwingComponent;
import org.phosphoresce.commons.eswing.table.ETableCellHoverColoredRenderer;

/**
 * JTablegNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/01	Kitagawa		VK쐬
 *-->
 */
public class ETable extends JTable implements ESwingComponent {

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		setDoubleBuffered(true);
		setOpaque(true);

		setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		setAutoscrolls(true);
		setRowSelectionAllowed(true);
		setRowHeight(20);

		setDefaultRenderer(Object.class, new ETableCellHoverColoredRenderer(this));
	}

	/**
	 * RXgN^<br>
	 * @see JTable#JTable()
	 */
	public ETable() {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param rows s
	 * @param columns J
	 * @see JTable#JTable(int, int)
	 */
	public ETable(int rows, int columns) {
		super(rows, columns);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param data f[^z
	 * @param columnNames Jz
	 * @see JTable#JTable(Object[][], Object[])
	 */
	public ETable(Object[][] data, Object[] columnNames) {
		super(data, columnNames);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param tableModel TableModelIuWFNg
	 * @param columnModel TableColumnModelIuWFNg
	 * @param selectionModel ListSelectionModelIuWFNg
	 * @see JTable#JTable(TableModel, TableColumnModel, ListSelectionModel)
	 */
	public ETable(TableModel tableModel, TableColumnModel columnModel, ListSelectionModel selectionModel) {
		super(tableModel, columnModel, selectionModel);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param tableModel TableModelIuWFNg
	 * @param columnModel TableColumnModelIuWFNg
	 * @see JTable#JTable(TableModel, TableColumnModel)
	 */
	public ETable(TableModel tableModel, TableColumnModel columnModel) {
		super(tableModel, columnModel);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param tableModel TableModelIuWFNg
	 * @see JTable#JTable(TableModel)
	 */
	public ETable(TableModel tableModel) {
		super(tableModel);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param rowData f[^Vector
	 * @param columnNames JVector
	 * @see JTable#JTable(Vector, Vector)
	 */
	public ETable(Vector rowData, Vector columnNames) {
		super(rowData, columnNames);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param stepColoring XebvJ[O_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @param hoverHighlighting zo[nCCeBO_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @see JTable#JTable()
	 */
	public ETable(boolean stepColoring, boolean hoverHighlighting) {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param rows s
	 * @param columns J
	 * @param stepColoring XebvJ[O_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @param hoverHighlighting zo[nCCeBO_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @see JTable#JTable(int, int)
	 */
	public ETable(int rows, int columns, boolean stepColoring, boolean hoverHighlighting) {
		super(rows, columns);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param data f[^z
	 * @param columnNames Jz
	 * @param stepColoring XebvJ[O_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @param hoverHighlighting zo[nCCeBO_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @see JTable#JTable(Object[][], Object[])
	 */
	public ETable(Object[][] data, Object[] columnNames, boolean stepColoring, boolean hoverHighlighting) {
		super(data, columnNames);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param tableModel TableModelIuWFNg
	 * @param columnModel TableColumnModelIuWFNg
	 * @param selectionModel ListSelectionModelIuWFNg
	 * @param stepColoring XebvJ[O_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @param hoverHighlighting zo[nCCeBO_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @see JTable#JTable(TableModel, TableColumnModel, ListSelectionModel)
	 */
	public ETable(TableModel tableModel, TableColumnModel columnModel, ListSelectionModel selectionModel, boolean stepColoring, boolean hoverHighlighting) {
		super(tableModel, columnModel, selectionModel);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param tableModel TableModelIuWFNg
	 * @param columnModel TableColumnModelIuWFNg
	 * @param stepColoring XebvJ[O_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @param hoverHighlighting zo[nCCeBO_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @see JTable#JTable(TableModel, TableColumnModel)
	 */
	public ETable(TableModel tableModel, TableColumnModel columnModel, boolean stepColoring, boolean hoverHighlighting) {
		super(tableModel, columnModel);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param tableModel TableModelIuWFNg
	 * @param stepColoring XebvJ[O_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @param hoverHighlighting zo[nCCeBO_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @see JTable#JTable(TableModel)
	 */
	public ETable(TableModel tableModel, boolean stepColoring, boolean hoverHighlighting) {
		super(tableModel);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param rowData f[^Vector
	 * @param columnNames JVector
	 * @param stepColoring XebvJ[O_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @param hoverHighlighting zo[nCCeBO_gpꍇtruewB̓fBtHg̃_ƂĐݒ肳܂B
	 * @see JTable#JTable(Vector, Vector)
	 */
	public ETable(Vector rowData, Vector columnNames, boolean stepColoring, boolean hoverHighlighting) {
		super(rowData, columnNames);
		dressup();
	}
}
