package org.phosphoresce.commons.eswing;

import java.awt.Component;

import javax.swing.JSplitPane;

import org.phosphoresce.commons.eswing.core.ESwingComponent;
import org.phosphoresce.commons.eswing.core.ESwingConfig;

/**
 * JSplitPanegNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/01	Kitagawa		VK쐬
 *-->
 */
public class ESplitPane extends JSplitPane implements ESwingComponent {

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		setDoubleBuffered(true);
		setOpaque(true);

		setContinuousLayout(true);
	}

	/**
	 * RXgN^<br>
	 * @see JSplitPane#JSplitPane()
	 */
	public ESplitPane() {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param orientation JSplitPane.HORIZONTAL_SPLIT ܂ JSplitPane.VERTICAL_SPLIT
	 * @param continuousLayout fBoC_̈ʒuύXƂɁAR|[lgAčĕ`悳悤ɂꍇtrue
	 * @param leftComponent ɕꂽ̍A܂͐ɕꂽ̏ɕ\Component
	 * @param rightComponent ɕꂽ̉EA܂͐ɕꂽ̉ɕ\Component
	 * @see JSplitPane#JSplitPane(int, boolean, Component, Component)
	 */
	public ESplitPane(int orientation, boolean continuousLayout, Component leftComponent, Component rightComponent) {
		super(orientation, continuousLayout, leftComponent, rightComponent);
		dressup();

		setContinuousLayout(continuousLayout);
	}

	/**
	 * RXgN^<br>
	 * @param orientation JSplitPane.HORIZONTAL_SPLIT ܂ JSplitPane.VERTICAL_SPLIT
	 * @param continuousLayout fBoC_̈ʒuύXƂɁAR|[lgAčĕ`悳悤ɂꍇtrue
	 * @see JSplitPane#JSplitPane(int, boolean)
	 */
	public ESplitPane(int orientation, boolean continuousLayout) {
		super(orientation, continuousLayout);
		dressup();

		setContinuousLayout(continuousLayout);
	}

	/**
	 * RXgN^<br>
	 * @param orientation JSplitPane.HORIZONTAL_SPLIT ܂ JSplitPane.VERTICAL_SPLIT
	 * @param leftComponent ɕꂽ̍A܂͐ɕꂽ̏ɕ\Component
	 * @param rightComponent ɕꂽ̉EA܂͐ɕꂽ̉ɕ\Component
	 * @see JSplitPane#JSplitPane(int, Component, Component)
	 */
	public ESplitPane(int orientation, Component leftComponent, Component rightComponent) {
		super(orientation, leftComponent, rightComponent);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param orientation JSplitPane.HORIZONTAL_SPLIT ܂ JSplitPane.VERTICAL_SPLIT
	 * @see JSplitPane#JSplitPane(int)
	 */
	public ESplitPane(int orientation) {
		super(orientation);
		dressup();
	}
}
