package org.phosphoresce.commons.csv;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/**
 * CSVg[NXgŕێCSVR[hNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/16	Kitagawa		VK쐬
 *-->
 */
public final class CSVRecord implements Serializable {

	/** CSVg[NێXgIuWFNg */
	private List list = null;

	/**
	 * RXgN^<br>
	 */
	public CSVRecord() {
		super();
		this.list = new LinkedList();
	}

	/**
	 * RXgN^<br>
	 * @param record CSVR[hIuWFNg
	 */
	public CSVRecord(CSVRecord record) {
		super();
		this.list = new LinkedList(record.list);
	}

	/**
	 * R[hCSVg[Nێł邩肵܂B<br>
	 * @return R[hCSVg[Nێłꍇtrueԋp
	 */
	public boolean isEmpty() {
		return list.isEmpty();
	}

	/**
	 * w肳ꂽCSVg[NێĂ邩肵܂B<br>
	 * @param token ΏCSVg[N
	 * @return XgCSVg[NێĂꍇtrueԋp
	 */
	public boolean contains(CSVToken token) {
		return list.contains(token);
	}

	/**
	 * w肳ꂽCSVR[heSĕێĂ邩肵܂B<br>
	 * @param record ΏCSVR[h
	 * @return w肳ꂽCSVR[heSĕێĂꍇtrueԋp
	 */
	public boolean containsAll(CSVRecord record) {
		return this.list.containsAll(record.list);
	}

	/**
	 * CSVR[hCe[^擾܂B<br>
	 * @return CSVR[hCe[^
	 */
	public Iterator iterator() {
		return list.iterator();
	}

	/**
	 * w肳ꂽTCY܂Ńg[NXgTCYg܂B<br>
	 * @param size g̃TCY
	 */
	public void expand(int size) {
		int listSize = list.size();
		for (int i = 0; i <= size - listSize; i++) {
			list.add(new CSVToken());
		}
	}

	/**
	 * ێĂCSVg[NzƂĎ擾܂B<br>
	 * @return CSVg[Nz
	 */
	public CSVToken[] toArray() {
		return (CSVToken[]) list.toArray(new CSVToken[list.size()]);
	}

	/**
	 * w肳ꂽCSVR[hSĒǉ܂B<br>
	 * @param record ǉΏCSVR[h
	 * @return ǉ̌ʁAXgeύXꂽꍇtrueԋp
	 */
	public boolean addAll(CSVRecord record) {
		return this.list.addAll(record.list);
	}

	/**
	 * w肳ꂽCSVR[hwʒuɑSĒǉ܂B<br>
	 * @param index ǉʒuCfbNX
	 * @param record ǉΏCSVR[h
	 * @return ̌ʁAXgeύXꂽꍇtrueԋp
	 */
	public boolean addAll(int index, CSVRecord record) {
		expand(index);
		return this.list.addAll(index, record.list);
	}

	/**
	 * w肳ꂽCSVg[NXgɊi[Ăvf݂̂căXgҏW܂B<br>
	 * @param record ێΏۂCSVg[Nێ郊XgIuWFNg
	 * @return ̌ʁAXgeύXꂽꍇtrueԋp
	 */
	public boolean retainAll(CSVRecord record) {
		return this.list.retainAll(record.list);
	}

	/**
	 * ێĂCSVg[NSč폜܂B<br>
	 */
	public void clear() {
		this.list.clear();
	}

	/**
	 * ێĂCSVg[N擾܂B<br>
	 * @return ێĂCSVg[N
	 */
	public int size() {
		return list.size();
	}

	/**
	 * w肳ꂽCSVg[Nǉ܂B<br>
	 * @param token CSVg[N
	 */
	public void add(CSVToken token) {
		list.add(token);
	}

	/**
	 * w肳ꂽCfbNXʒuCSVg[Nǉ܂B<br>
	 * @param index ǉʒuCfbNX
	 * @param token ǉΏCSVg[N
	 */
	public void add(int index, CSVToken token) {
		expand(index);
		list.add(index, token);
	}

	/**
	 * w肳ꂽCfbNXCSVg[N擾܂B<br>
	 * @param index 擾ΏۃCfbNX
	 * @return CSVg[N
	 */
	public CSVToken get(int index) {
		expand(index + 1);
		return (CSVToken) list.get(index);
	}

	/**
	 * w肳ꂽCfbNXɑ΂CSVg[Nݒ肵܂B<br>
	 * @param index CfbNX
	 * @param token CSVg[N
	 * @return ݒ菈OɕێĂCSVg[N
	 */
	public CSVToken set(int index, CSVToken token) {
		expand(index + 1);
		return (CSVToken) list.set(index, token);
	}

	/**
	 * w肳ꂽCSVg[N폜܂B<br>
	 * @param token 폜ΏCSVg[N
	 * @return w肳ꂽCSVg[NێĂꍇtrueԋp
	 */
	public boolean remove(CSVToken token) {
		return list.remove(token);
	}

	/**
	 * w肳ꂽCfbNXCSVg[N폜܂B<br>
	 * @param index g[NCfbNX
	 * @return w肳ꂽCfbNXɑ݂CSVg[N
	 */
	public CSVToken remove(int index) {
		expand(index + 1);
		return (CSVToken) list.remove(index);
	}

	/**
	 * w肳ꂽCSVR[hɊi[Ă邷ׂĂ̗vfXg폜܂B<br>
	 * @param record 폜ΏۂCSVg[Nێ郊XgIuWFNg
	 * @return ̌ʁAXgeύXꂽꍇtrueԋp
	 */
	public boolean removeAll(CSVRecord record) {
		return this.list.removeAll(record.list);
	}

	/**
	 * w肳ꂽCSVg[Nʒu擾܂B<br>
	 * @param token ʒu擾ΏCSVg[N
	 * @return w肳ꂽvfXgōŏɌoꂽʒũCfbNXBXgɂ̗vfȂꍇ-1ԋpB
	 */
	public int indexOf(CSVToken token) {
		return list.indexOf(token);
	}

	/**
	 * w肳ꂽCSVg[N̍ŏIoʒu擾܂B<br>
	 * @param token ʒu擾ΏCSVg[N
	 * @return w肳ꂽvfXgōŌɌoꂽʒũCfbNXBXgɂ̗vfȂꍇ-1ԋpB
	 */
	public int lastIndexOf(CSVToken token) {
		return list.lastIndexOf(token);
	}

	/**
	 * CSVg[NXg̗vfK؂ȏŌJԂ锽q擾܂B<br>
	 * @return  CSVg[NXg̗vfK؂ȏŌJԂ锽q
	 */
	public ListIterator listIterator() {
		return list.listIterator();
	}

	/**
	 * Xg̗vfK؂ȏŌJԂAXg̎w肳ꂽʒuJn锽q擾܂B<br>
	 * @param index next\bȟĂяoɂăXgqԂŏ̗vf̃CfbNX
	 * @return  CSVg[NXg̗vfK؂ȏŌJԂ锽q
	 */
	public ListIterator listIterator(int index) {
		expand(index);
		return list.listIterator(index);
	}

	/**
	 * w肳ꂽCfbNX͈͂CSVR[h擾܂B<br>
	 * @param fromIndex JnCfbNX
	 * @param toIndex ICfbNX
	 * @return w͈͂CSVR[h
	 */
	public CSVRecord subList(int fromIndex, int toIndex) {
		expand(fromIndex);
		expand(toIndex);
		List record = this.list.subList(fromIndex, toIndex);
		CSVRecord result = new CSVRecord();
		for (Iterator iterator = record.iterator(); iterator.hasNext();) {
			result.add((CSVToken) iterator.next());
		}
		return result;
	}

	/**
	 * CSVR[h񋟂CSV擾܂B<br>
	 * @return CSVR[h
	 */
	public String getRecordValue() {
		StringBuffer buffer = new StringBuffer();
		for (Iterator iterator = list.iterator(); iterator.hasNext();) {
			CSVToken token = (CSVToken) iterator.next();
			buffer.append(token.getEncodedValue());
			if (iterator.hasNext()) {
				buffer.append(CSVToken.SEPARATOR);
			}
		}
		return buffer.toString();
	}
}
