/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class FileUtil {
    private FileUtil() {
    }

    public static void delete(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                if (file.listFiles().length > 0) {
                    for (int i = 0; file != null && i <= file.listFiles().length - 1; ++i) {
                        FileUtil.delete(file.listFiles()[i--]);
                    }
                    file.delete();
                } else {
                    file.delete();
                }
            } else {
                file.delete();
            }
        }
    }

    public static void copy(File source, File destination) throws IOException {
        FileChannel src = new FileInputStream(source).getChannel();
        FileChannel dst = new FileOutputStream(destination).getChannel();
        dst.transferFrom(src, 0L, src.size());
    }

    public static File getDirectory(File file) {
        if (file.isDirectory()) {
            return new File(file.getAbsolutePath());
        }
        String path = file.getAbsolutePath();
        path = path.substring(0, path.lastIndexOf(File.separator));
        return new File(path);
    }

    public static String getAutoIncrementFilename(String filename) {
        File file = new File(filename);
        String incrementedFilename = filename;
        if (file.exists()) {
            if (file.isDirectory()) {
                int counter = 1;
                File check = new File(filename + " [" + counter + "]");
                while (check.exists()) {
                    ++counter;
                }
                incrementedFilename = filename + " [" + counter + "]";
            } else {
                String basename = filename;
                String extension = "";
                if (filename.lastIndexOf(46) > 0) {
                    basename = filename.substring(0, filename.lastIndexOf(46));
                    extension = filename.substring(filename.lastIndexOf(46));
                }
                int counter = 1;
                File check = new File(filename + " [" + counter + "]" + extension);
                while (check.exists()) {
                    ++counter;
                }
                incrementedFilename = filename + " [" + counter + "]" + extension;
            }
        }
        return incrementedFilename;
    }

    public static void renameWithDatePostfix(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            if (file.isDirectory()) {
                int counter = 1;
                String rename = filename + new SimpleDateFormat(".yyyyMMdd.hhmmss").format(new Date());
                File check = new File(rename);
                while (check.exists()) {
                    rename = rename + " [" + counter + "]";
                    check = new File(rename);
                    ++counter;
                }
                file.renameTo(new File(rename));
            } else {
                String head;
                String basename = filename;
                String extension = "";
                if (filename.lastIndexOf(46) > 0) {
                    basename = filename.substring(0, filename.lastIndexOf(46));
                    extension = filename.substring(filename.lastIndexOf(46));
                }
                int counter = 1;
                String rename = head = basename + new SimpleDateFormat(".yyyyMMdd.hhmmss").format(new Date());
                File check = new File(rename + extension);
                while (check.exists()) {
                    rename = head + " [" + counter + "]";
                    check = new File(rename + extension);
                    ++counter;
                }
                file.renameTo(new File(rename + extension));
            }
        }
    }
}

