package org.phosphoresce.commons.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;

import javax.mail.Part;
import javax.mail.internet.MimeUtility;

import org.phosphoresce.commons.mail.exception.MailIOException;
import org.phosphoresce.commons.mail.exception.MailResourceException;
import org.phosphoresce.commons.mail.mail.MailUtil;
import org.phosphoresce.commons.util.StringUtil;

/**
 * [Ytt@CێNXB<br>
 * NX͑M[AM[ʂ̃\[XIuWFNgƂĎgpB<br>
 * NXCX^XMpł邩AMpł邩̓NXɌ肳܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 *-->
 */
public final class MailAttachResource implements Serializable {

	/** \[XMptO */
	private boolean income = false;

	/** \[Xt@C */
	private String name = "";

	/** M\[XPartIuWFNg */
	private Part part = null;

	/** M\[XFileIuWFNg */
	private File file = null;

	/**
	 * RXgN^<br>
	 * w肳ꂽPartIuWFNgMp\[XƂăNX܂B<br>
	 * @param part PartIuWFNg
	 * @throws MailResourceException ɃNXłȂꍇɔ
	 */
	MailAttachResource(Part part) throws MailResourceException {
		super();
		try {
			this.income = true;
			this.name = StringUtil.isEmpty(part.getFileName()) ? MailUtil.getContentType(part, "name") : MimeUtility.decodeText(part.getFileName());
			this.part = part;
		} catch (Exception e) {
			throw new MailResourceException("Mp\[XƂăNX邱Ƃł܂ł", e);
		}
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽFileIuWFNg著Mp\[XƂăNX܂B<br>
	 * @param file FileIuWFNg
	 * @throws MailResourceException ɃNXłȂꍇɔ
	 */
	MailAttachResource(File file) throws MailResourceException {
		super();
		try {
			this.income = false;
			this.name = file.getName();
			this.file = file;
		} catch (Exception e) {
			throw new MailResourceException("Mp\[XƂăNX邱Ƃł܂ł", e);
		}
	}

	/**
	 * \[XMptO擾܂B<br>
	 * @return \[XMptO
	 */
	public boolean isIncome() {
		return this.income;
	}

	/**
	 * \[Xt@C擾܂B<br>
	 * @return \[Xt@C
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * NXێ郊\[XInputStreamIuWFNg擾܂B<br>
	 * @return \[XInputStreamIuWFNg
	 * @throws MailIOException Ƀ\[XInputStreamIuWFNg擾łȂꍇɔ
	 */
	private InputStream getInputStream() throws MailIOException {
		try {
			if (income) {
				return part.getInputStream();
			} else {
				return new FileInputStream(file);
			}
		} catch (Exception e) {
			throw new MailIOException("Ytt@C\[XInputStreamIuWFNg̎擾Ɏs܂", e);
		}
	}

	/**
	 * M\[XPartIuWFNg擾܂B<br>
	 * @return M\[XPartIuWFNg
	 * @throws MailResourceException \[XIuWFNgMpł͂Ȃɂւ炸APartIuWFNg擾悤Ƃꍇɔ܂
	 */
	Part getPart() throws MailResourceException {
		if (!isIncome()) {
			throw new MailResourceException("Mp\[XIuWFNgł͂ȂׁAPartIuWFNg̎擾͍s܂");
		}
		return this.part;
	}

	/**
	 * M\[XFileIuWFNg擾܂B<br>
	 * @return M\[XFileIuWFNg
	 * @throws MailResourceException \[XIuWFNgMpł͂Ȃɂւ炸AFileIuWFNg擾悤Ƃꍇɔ܂
	 */
	File getFile() throws MailResourceException {
		if (isIncome()) {
			throw new MailResourceException("Mp\[XIuWFNgł͂ȂׁAFileIuWFNg̎擾͍s܂");
		}
		return this.file;
	}

	/**
	 * Ytt@Cw肳ꂽt@CIuWFNgɕۑ܂B<br>
	 * w肳ꂽt@CIuWFNgfBNgłꍇ͓Ytt@C
	 * t@CƂt@CỸfBNgɑ΂ďo͂܂B<br>
	 * @param file t@CIuWFNg
	 * @throws MailIOException ɓYtt@C̏o͂sȂꍇɔ
	 */
	public void save(File file) throws MailIOException {
		try {
			final int READ_BYTE = 8192;
			File target = file.isDirectory() ? new File((file.getAbsolutePath().endsWith(File.separator) ? file.getAbsolutePath() : file.getAbsolutePath() + File.separator)
					+ StringUtil.escapeFilename(name, "_")) : file;
			FileOutputStream os = new FileOutputStream(target);
			InputStream is = getInputStream();
			byte bytes[] = new byte[READ_BYTE];
			int i;
			while ((i = is.read(bytes)) > 0) {
				os.write(bytes, 0, i);
			}
			os.close();
		} catch (Exception e) {
			throw new MailIOException("Ytt@C\[X̕ۑɎs܂", e);
		}
	}

	/**
	 * Ytt@Cw肳ꂽt@CpXɕۑ܂B<br>
	 * w肳ꂽt@CpXfBNgłꍇ͓Ytt@C
	 * t@CƂt@CỸfBNgɑ΂ďo͂܂B<br>
	 * @param path t@CpX
	 * @throws MailIOException ɓYtt@C̏o͂sȂꍇɔ
	 */
	public void save(String path) throws MailIOException {
		save(new File(path));
	}
}
