/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.mail;

import javax.mail.Folder;
import javax.mail.Session;
import javax.mail.Store;
import org.phosphoresce.commons.mail.MailConfiguration;
import org.phosphoresce.commons.mail.MailDeclareInterface;
import org.phosphoresce.commons.mail.exception.MailTransactionException;

public abstract class MailTransaction
implements MailDeclareInterface {
    private MailConfiguration configuration = null;
    private boolean opened = false;
    private boolean readonly = true;
    private Session session = null;
    private Store store = null;
    private Folder folder = null;

    private MailTransaction() {
    }

    protected MailTransaction(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public final void begin(boolean readonly) throws MailTransactionException {
        try {
            this.readonly = readonly;
            this.session = this.configuration.getSession();
            if (!this.configuration.isSender()) {
                this.store = this.session.getStore(this.configuration.getProtocol());
                this.store.connect(this.configuration.getServer(), this.configuration.getPort(), this.configuration.getUser(), this.configuration.getPassword());
                this.folder = this.store.getFolder("INBOX");
                this.folder.open(readonly ? 1 : 2);
            }
            this.opened = true;
        }
        catch (Exception e) {
            throw new MailTransactionException("\u30e1\u30fc\u30eb\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public final void close() throws MailTransactionException {
        try {
            if (!this.configuration.isSender()) {
                this.folder.close(!this.readonly);
                this.store.close();
            }
            this.folder = null;
            this.store = null;
            this.session = null;
            this.opened = false;
        }
        catch (Exception e) {
            throw new MailTransactionException("\u30e1\u30fc\u30eb\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public final boolean isOpened() {
        return this.opened;
    }

    final MailConfiguration getConfiguration() {
        return this.configuration;
    }

    final Folder getFolder() {
        return this.folder;
    }

    final Session getSession() {
        return this.session;
    }

    final Store getStore() {
        return this.store;
    }
}

