/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.mail;

import java.util.LinkedList;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.phosphoresce.commons.mail.MailConfiguration;
import org.phosphoresce.commons.mail.MailMessage;
import org.phosphoresce.commons.mail.MailTransaction;
import org.phosphoresce.commons.mail.exception.MailException;
import org.phosphoresce.commons.mail.exception.MailTransactionException;

public final class MailReciveTransaction
extends MailTransaction {
    public MailReciveTransaction(MailConfiguration configuration) {
        super(configuration);
    }

    public int getMessageCount() throws MailException, MailTransactionException {
        try {
            if (!this.isOpened()) {
                throw new MailTransactionException("\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u958b\u59cb\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            return this.getFolder().getMessageCount();
        }
        catch (MessagingException e) {
            throw new MailException("\u6b63\u5e38\u306b\u30e1\u30c3\u30bb\u30fc\u30b8\u6570\u306e\u53d6\u5f97\u304c\u884c\u3048\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    public int getUnreadMessageCount() throws MailException, MailTransactionException {
        try {
            if (!this.isOpened()) {
                throw new MailTransactionException("\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u958b\u59cb\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            return this.getFolder().getUnreadMessageCount();
        }
        catch (MessagingException e) {
            throw new MailException("\u6b63\u5e38\u306b\u672a\u8aad\u30e1\u30c3\u30bb\u30fc\u30b8\u6570\u306e\u53d6\u5f97\u304c\u884c\u3048\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    public int getNewMessageCount() throws MailException, MailTransactionException {
        try {
            if (!this.isOpened()) {
                throw new MailTransactionException("\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u958b\u59cb\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            return this.getFolder().getNewMessageCount();
        }
        catch (MessagingException e) {
            throw new MailException("\u6b63\u5e38\u306b\u672a\u8aad\u30e1\u30c3\u30bb\u30fc\u30b8\u6570\u306e\u53d6\u5f97\u304c\u884c\u3048\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    public MailMessage[] recive() throws MailException, MailTransactionException {
        try {
            if (!this.isOpened()) {
                throw new MailTransactionException("\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u958b\u59cb\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            LinkedList<MailMessage> list = new LinkedList<MailMessage>();
            if (this.getMessageCount() > 0) {
                Message[] messages = this.getFolder().getMessages();
                for (int i = 0; i <= messages.length - 1; ++i) {
                    Message message = messages[i];
                    this.getFolder().setFlags(new Message[]{message}, new Flags(Flags.Flag.DELETED), true);
                    list.add(new MailMessage(message));
                }
            }
            return list.toArray(new MailMessage[list.size()]);
        }
        catch (Exception e) {
            throw new MailException("\u6b63\u5e38\u306b\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u53d7\u4fe1\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }
}

