/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.mail;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.phosphoresce.commons.mail.MailDeclareInterface;
import org.phosphoresce.commons.mail.exception.MailAddressException;
import org.phosphoresce.commons.mail.mail.MailUtil;
import org.phosphoresce.commons.util.StringUtil;

public final class MailAddressContainer
implements Serializable,
MailDeclareInterface {
    private List fromList = new LinkedList();
    private List replyList = new LinkedList();
    private List recipientTOList = new LinkedList();
    private List recipientCCList = new LinkedList();
    private List recipientBCCList = new LinkedList();

    private void add(List list, Address address) {
        if (address != null) {
            list.add(address);
        }
    }

    private void add(List list, Address[] address) {
        if (address != null) {
            list.addAll(Arrays.asList(address));
        }
    }

    private void add(List list, String address, String charset) throws MailAddressException {
        try {
            if (!StringUtil.isEmpty((String)address)) {
                InternetAddress[] iAddresses = InternetAddress.parse((String)address);
                for (int i = 0; i <= iAddresses.length - 1; ++i) {
                    String personal = iAddresses[i].getPersonal();
                    String mailaddress = iAddresses[i].getAddress();
                    if (personal == null) continue;
                    iAddresses[i].setPersonal(MimeUtility.encodeText((String)personal, (String)charset, null));
                }
                this.add(list, (Address[])iAddresses);
            }
        }
        catch (AddressException e) {
            throw new MailAddressException("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306e\u30d1\u30fc\u30b9\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MailAddressException("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306e\u30d1\u30fc\u30b9\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    private int getNumberOf(List list) {
        return list.size();
    }

    private Iterator iterator(List list) {
        return list.iterator();
    }

    private String getAddressesValue(List list) throws MailAddressException {
        try {
            Address[] addresses = list.toArray(new Address[list.size()]);
            return MailUtil.createMailAddressValue(addresses);
        }
        catch (Exception e) {
            throw new MailAddressException("\u30a2\u30c9\u30ec\u30b9\u306e\u53d6\u5f97\u51e6\u7406\u6642\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    private Address[] getAddresses(List list) {
        return list.toArray(new Address[list.size()]);
    }

    public void addFrom(Address address) {
        this.add(this.fromList, address);
    }

    public void addReply(Address address) {
        this.add(this.replyList, address);
    }

    public void addRecipientTo(Address address) {
        this.add(this.recipientTOList, address);
    }

    public void addRecipientCc(Address address) {
        this.add(this.recipientCCList, address);
    }

    public void addRecipientBcc(Address address) {
        this.add(this.recipientBCCList, address);
    }

    public void addFrom(Address[] address) {
        this.add(this.fromList, address);
    }

    public void addReply(Address[] address) {
        this.add(this.replyList, address);
    }

    public void addRecipientTo(Address[] address) {
        this.add(this.recipientTOList, address);
    }

    public void addRecipientCc(Address[] address) {
        this.add(this.recipientCCList, address);
    }

    public void addRecipientBcc(Address[] address) {
        this.add(this.recipientBCCList, address);
    }

    public void addFrom(String address) throws MailAddressException {
        this.add(this.fromList, address, null);
    }

    public void addReply(String address) throws MailAddressException {
        this.add(this.replyList, address, null);
    }

    public void addRecipientTo(String address) throws MailAddressException {
        this.add(this.recipientTOList, address, null);
    }

    public void addRecipientCc(String address) throws MailAddressException {
        this.add(this.recipientCCList, address, null);
    }

    public void addRecipientBcc(String address) throws MailAddressException {
        this.add(this.recipientBCCList, address, null);
    }

    public void addFrom(String address, String charset) throws MailAddressException {
        this.add(this.fromList, address, charset);
    }

    public void addReply(String address, String charset) throws MailAddressException {
        this.add(this.replyList, address, charset);
    }

    public void addRecipientTo(String address, String charset) throws MailAddressException {
        this.add(this.recipientTOList, address, charset);
    }

    public void addRecipientCc(String address, String charset) throws MailAddressException {
        this.add(this.recipientCCList, address, charset);
    }

    public void addRecipientBcc(String address, String charset) throws MailAddressException {
        this.add(this.recipientBCCList, address, charset);
    }

    public int getNumberOfFrom() {
        return this.getNumberOf(this.fromList);
    }

    public int getNumberOfReply() {
        return this.getNumberOf(this.replyList);
    }

    public int getNumberOfRecipientTo() {
        return this.getNumberOf(this.recipientTOList);
    }

    public int getNumberOfRecipientCc() {
        return this.getNumberOf(this.recipientCCList);
    }

    public int getNumberOfRecipientBcc() {
        return this.getNumberOf(this.recipientBCCList);
    }

    public Iterator fromIterator() {
        return this.iterator(this.fromList);
    }

    public Iterator replyIterator() {
        return this.iterator(this.replyList);
    }

    public Iterator recipientToIterator() {
        return this.iterator(this.recipientTOList);
    }

    public Iterator recipientCcIterator() {
        return this.iterator(this.recipientCCList);
    }

    public Iterator recipientBccIterator() {
        return this.iterator(this.recipientBCCList);
    }

    public String getFromAddressesValue() throws MailAddressException {
        return this.getAddressesValue(this.fromList);
    }

    public String getReplyAddressesValue() throws MailAddressException {
        return this.getAddressesValue(this.replyList);
    }

    public String getRecipientToAddressesValue() throws MailAddressException {
        return this.getAddressesValue(this.recipientTOList);
    }

    public String getRecipientCcAddressesValue() throws MailAddressException {
        return this.getAddressesValue(this.recipientCCList);
    }

    public String getRecipientBccAddressesValue() throws MailAddressException {
        return this.getAddressesValue(this.recipientBCCList);
    }

    public Address[] getFromAddresses() {
        return this.getAddresses(this.fromList);
    }

    public Address[] getReplyAddresses() {
        return this.getAddresses(this.replyList);
    }

    public Address[] getRecipientToAddresses() {
        return this.getAddresses(this.recipientTOList);
    }

    public Address[] getRecipientCcAddresses() {
        return this.getAddresses(this.recipientCCList);
    }

    public Address[] getRecipientBccAddresses() {
        return this.getAddresses(this.recipientBCCList);
    }
}

