/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.contentnotifier.strategy;

import java.io.BufferedReader;
import java.io.FileReader;
import org.phosphoresce.contentnotifier.exception.ContentCheckException;
import org.phosphoresce.contentnotifier.exception.PropertiesLoadException;
import org.phosphoresce.contentnotifier.strategy.CheckStrategy;
import org.phosphoresce.contentnotifier.util.PropertiesUtil;

public class ContentStringCheckStrategy
implements CheckStrategy {
    private String checkFile;
    private String checkString;

    public ContentStringCheckStrategy(String properties) throws PropertiesLoadException {
        this.checkFile = PropertiesUtil.getValue(properties, "check.file");
        this.checkString = PropertiesUtil.getValue(properties, "check.string");
    }

    public boolean check() throws ContentCheckException {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.checkFile));
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.indexOf(this.checkString) <= 0) continue;
                return false;
            }
            reader.close();
            return true;
        }
        catch (Exception e) {
            throw new ContentCheckException("\u30c1\u30a7\u30c3\u30af\u51e6\u7406\u4e2d\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }
}

